/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.utils;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;

public class CheckUtil {
    private static final String PHONE_PATTERN = "(\\+\\d+)?1[345789]\\d{9}$";
    private static final String FIX_PHONE_PATTERN = "(?:(\\(\\+?86\\))(0[0-9]{2,3}-?)?([2-9][0-9]{6,7})+(-[0-9]{1,4})?)|(?:(86-?)?(0[0-9]{2,3}-?)?([2-9][0-9]{6,7})+(-[0-9]{1,4})?)";

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return !CheckUtil.isEmpty(collection);
    }

    public static boolean isEmpty(Object str) {
        return str == null || str.toString().length() == 0;
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !CheckUtil.isBlank(str);
    }

    public static boolean isNotBlank(Object str) {
        return !CheckUtil.isBlank(str);
    }

    public static boolean isBlank(Object str) {
        int strLen;
        String nullValue = "null";
        if (str == null || (strLen = str.toString().length()) == 0 || nullValue.equals(str.toString())) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.toString().charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String str) {
        int strLen;
        String nullValue = "null";
        if (str == null || (strLen = str.length()) == 0 || nullValue.equals(str)) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPhone(Object value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches(PHONE_PATTERN, value.toString().trim());
    }

    public static boolean isFixPhone(Object value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches(FIX_PHONE_PATTERN, value.toString().trim());
    }
}

