/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public class BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);

    public static <S, T> List<T> copyProperties(List<S> list, Class<T> tClass) {
        ArrayList targetList = new ArrayList(list.size());
        list.forEach(s -> targetList.add(BeanUtils.copyNonNullProperties(s, BeanUtils.newInstance(tClass))));
        return targetList;
    }

    public static <S, T> T copyProperties(S src, T target) {
        org.springframework.beans.BeanUtils.copyProperties(src, target);
        return target;
    }

    public static <S, T> T copyProperties(S src, Class<T> tClass) {
        return BeanUtils.copyProperties(src, BeanUtils.newInstance(tClass));
    }

    public static <S, T> T copyNonNullProperties(S src, T target) {
        org.springframework.beans.BeanUtils.copyProperties(src, target, (String[])BeanUtils.getNullProperties(src));
        return target;
    }

    private static String[] getNullProperties(Object src) {
        BeanWrapperImpl srcBean = new BeanWrapperImpl(src);
        PropertyDescriptor[] pds = srcBean.getPropertyDescriptors();
        HashSet<String> emptyName = new HashSet<String>();
        for (PropertyDescriptor p : pds) {
            try {
                Object srcValue = srcBean.getPropertyValue(p.getName());
                if (srcValue != null) continue;
                emptyName.add(p.getName());
            }
            catch (Exception e) {
                log.trace(e.toString(), (Throwable)e);
            }
        }
        String[] result = new String[emptyName.size()];
        return emptyName.toArray(result);
    }

    public static <T> T newInstance(Class<T> rClass) {
        try {
            return rClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }
}

