/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileUpLoad {
    private static final Logger log = LoggerFactory.getLogger(FileUpLoad.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type:FASTDFS}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    public static final String FILE_TYPE_MINIO = "MINIO";
    @Value(value="${minio.download-noauth-url}")
    private String downloadNoAuthUrl;

    public String upload(String fileNamePre, byte[] file, String endType) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
        String fileName = fileNamePre + endType;
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String path = FILE_TYPE_MINIO.equals(this.fileType) ? this.fileClient.uploadFileByInputStream("", fileName, (InputStream)inputStream) : this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)inputStream);
        String fileUrl = null;
        String innerFileUrl = null;
        log.error("\u670d\u52a1\u5668\u7c7b\u578b\uff1a" + this.fileType);
        if ("OSS".equals(this.fileType)) {
            String httphead = "https://";
            if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                httphead = "http://";
            }
            fileUrl = this.ossFileUrl + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else if (FILE_TYPE_MINIO.equals(this.fileType)) {
            String encode;
            int lastSlash = path.lastIndexOf(47);
            String extractFileName = lastSlash >= 0 && lastSlash < path.length() - 1 ? path.substring(lastSlash + 1) : path;
            try {
                encode = URLEncoder.encode(extractFileName, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new BusinessException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            path = path.substring(0, lastSlash) + "/" + encode;
            fileUrl = this.downloadNoAuthUrl + "?path=" + path;
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return fileUrl;
    }
}

