/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApprovalBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityRspBO;
import com.tydic.commodity.dao.UccBeforeStatusRecordEditMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpAndOffApprovalBusiServiceImpl
implements UccUpAndOffApprovalBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;
    @Autowired
    private UccBeforeStatusRecordEditMapper uccBeforeStatusRecordEditMapper;

    @Override
    public UccUpAndOffApprovalAbilityRspBO dealUpAndOffApproval(UccUpAndOffApprovalAbilityReqBO reqBO, ExtReqBO extReqBO) {
        UccUpAndOffApprovalAbilityRspBO rspBO = new UccUpAndOffApprovalAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5ba1\u6279\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getAuditResult() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getAuditResult() != 0 && reqBO.getAuditResult() != 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u679c\u5165\u53c2\u5fc5\u987b\u4e3a0\u62161");
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<Object> uccSkuPos = new ArrayList();
            try {
                uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
                ArrayList failIds = new ArrayList();
                List<Long> failIdAudit = new ArrayList();
                if (uccSkuPos.size() < skus.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                    return rspBO;
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getApprovalStatus().toString().equals(extReqBO.getAuditStatusCheck())) continue;
                        failIdAudit.add(uccSkuPo.getSkuId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIdAudit.toString() + "\u4e0d\u5904\u4e8e\u5ba1\u6279\u4e2d\u72b6\u6001");
                    return rspBO;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = null;
            Map<String, List<UccSkuPo>> mapForAuditSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getStepId));
            HashMap ext = new HashMap(1);
            for (Map.Entry<String, List<UccSkuPo>> stringListEntry : mapForAuditSku.entrySet()) {
                UacNoTaskAuditOrderAuditRspBO uocAuditAbilityAuditRspBO;
                uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(extReqBO.getAuditObjType());
                List<UccSkuPo> skuPoListTmp = stringListEntry.getValue();
                List<Long> skuIds = skuPoListTmp.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                uocAuditAbilityAuditReqBO.setObjId(skuIds);
                uocAuditAbilityAuditReqBO.setStepId(stringListEntry.getKey().toString());
                uocAuditAbilityAuditReqBO.setAuditResult(reqBO.getAuditResult());
                uocAuditAbilityAuditReqBO.setOperId(reqBO.getUserId().toString());
                uocAuditAbilityAuditReqBO.setUsername(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setOrgId(reqBO.getOrgId());
                uocAuditAbilityAuditReqBO.setOrgName(reqBO.getOrgName());
                uocAuditAbilityAuditReqBO.setOperDept(reqBO.getCompanyName());
                uocAuditAbilityAuditReqBO.setExt(ext);
                uocAuditAbilityAuditReqBO.setMsgFlag(Integer.valueOf(0));
                try {
                    uocAuditAbilityAuditRspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
                    if (!"0000".equals(uocAuditAbilityAuditRspBO.getRespCode())) {
                        throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), uocAuditAbilityAuditRspBO.getRespDesc());
                    }
                }
                catch (BusinessException e) {
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
                }
                if (uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                    if (reqBO.getAuditResult() == 0) {
                        this.updateSkuStatus(extReqBO.getStatusApproval(), extReqBO.getAuditStatusConsent(), "null", skuIds, supplierShopId, reqBO);
                        try {
                            for (Long skuId : skuIds) {
                                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setUptype(1);
                                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                                }
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setDownType(1);
                                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                                }
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setUptype(1);
                                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                                }
                                uccSkuPutCirReqBO.setSkuId(skuId);
                                uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                                uccSkuPutCirReqBO.setRemark("\u5f3a\u5236\u4e0b\u67b6");
                                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                                if ("0000".equals(uccSkuPutCirRspBO.getRespCode())) continue;
                                throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                        }
                    }
                    if (reqBO.getAuditResult() != 1) continue;
                    try {
                        if (extReqBO.isNoChangeStatus()) {
                            this.updateSkuStatus(null, extReqBO.getAuditStatusReject(), "null", skus, supplierShopId, reqBO);
                            continue;
                        }
                        this.updateSkuStatus(extReqBO.getStatusOld().get(0), extReqBO.getAuditStatusReject(), "null", skus, supplierShopId, reqBO);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                    }
                }
                try {
                    if (StringUtils.isEmpty((Object)uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId())) continue;
                    this.uccSkuMapper.batchUpdateStep(skuIds, uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId(), supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUpAndOffApprovalAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

