/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UocApprovalObjPO;
import com.tydic.commodity.po.UocSpuApproverLogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuManagementListQryCombServiceImpl
implements UccSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @Override
    public UccSkuManagementListQryCombRspBO getSkuManagementListQry(UccSkuManagementListQryCombReqBO reqBO) {
        BoolQueryBuilder extBoolQueryBuilder;
        String queryString;
        String result;
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        if (reqBO.getIsNoAgrSku() != null && reqBO.getOrgId() != null) {
            if ("0".equals(reqBO.getIsprofess())) {
                if (!StringUtils.isEmpty((Object)reqBO.getRunMainBodyId()) && !reqBO.getOrgPath().contains(reqBO.getRunMainBodyId())) {
                    rspBo.setTotal(0);
                    rspBo.setRespCode("0000");
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList());
                    return rspBo;
                }
                if (StringUtils.isEmpty((Object)reqBO.getRunMainBodyId())) {
                    String[] orgIds = reqBO.getOrgPath().split("-");
                    reqBO.setRunMainBodyIds(Arrays.asList(orgIds));
                }
            } else {
                reqBO.setSupplierOrgId(reqBO.getOrgId().toString());
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            List<Long> skus = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            for (UccSkuManagementListCombQryBO row : rspBo.getRows()) {
                SkuDataGovernSamePricePO pricePo = new SkuDataGovernSamePricePO();
                pricePo.setSkuId(row.getSkuId());
                pricePo.setType(1);
                List<SkuDataGovernSamePricePO> list = this.skuDataGovernSamePriceMapper.getList(pricePo);
                list.stream().map(SkuDataGovernSamePricePO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).ifPresent(row::setLowestComPrice);
            }
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && (groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = ladderMap.keySet().iterator();
                HashMap<Long, List> longListMap = new HashMap<Long, List>();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = ladderMap.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class);
                    eachBo.sort(new Comparator<UccEstoreLadderPriceBO>(){

                        @Override
                        public int compare(UccEstoreLadderPriceBO o1, UccEstoreLadderPriceBO o2) {
                            return o2.getStart().compareTo(o1.getStart());
                        }
                    });
                    for (UccEstoreLadderPriceBO each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryCombReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        WildcardQueryBuilder wildcardQuery2;
        BoolQueryBuilder boolQueryBuilderSon3;
        BoolQueryBuilder boolQueryBuilderSon2;
        BoolQueryBuilder boolQueryBuilderSon1;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getSurpassVpt() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"surpass_vpt"));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"surpass_vpt", (Object)reqBo.getSurpassVpt()));
        }
        if (reqBo.getIfGovern() != null) {
            if (1 == reqBo.getIfGovern()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
            } else {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
            }
        }
        if (reqBo.getGovernResult() != null) {
            if (reqBo.getGovernResult() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"govern_result", (Object)reqBo.getGovernResult()));
            } else {
                boolQueryBuilderSon1 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2 = QueryBuilders.boolQuery();
                boolQueryBuilderSon3 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2.must((QueryBuilder)QueryBuilders.termQuery((String)"govern_result", (Object)reqBo.getGovernResult()));
                boolQueryBuilderSon3.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon2);
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon3);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
            }
        }
        if (reqBo.getMaterialType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_type", (Object)reqBo.getMaterialType()));
        }
        if (reqBo.getBrandVerify() != null) {
            if (reqBo.getBrandVerify() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_verify", (Object)reqBo.getBrandVerify()));
            } else {
                boolQueryBuilderSon1 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2 = QueryBuilders.boolQuery();
                boolQueryBuilderSon3 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_verify", (Object)reqBo.getBrandVerify()));
                boolQueryBuilderSon3.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"brand_verify"));
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon2);
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon3);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
            }
        }
        if (reqBo.getBelongModule() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"belongModule", (Object)reqBo.getBelongModule()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRunMainBodyId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"runMainBodyId.keyword", (String)reqBo.getRunMainBodyId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getRunMainBodyIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"runMainBodyId.keyword", reqBo.getRunMainBodyIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            if (reqBo.getApprovalStatus().equals(0)) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"sku_approval_status"));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (Object)reqBo.getApprovalStatus()));
            }
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", reqBo.getApprovalStatusList()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSupplierIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_id", reqBo.getSupplierIds()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityTypeIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", reqBo.getCommodityTypeIds()));
        }
        try {
            Long timeBegin;
            RangeQueryBuilder qb = null;
            if (reqBo.getCreateTimeStart() != null && reqBo.getCreateTimeEnd() != null) {
                timeBegin = reqBo.getCreateTimeStart().getTime();
                String[] timeEnd = Long.valueOf(reqBo.getCreateTimeEnd().getTime());
                qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin).to((Object)timeEnd);
            } else {
                if (reqBo.getCreateTimeStart() != null) {
                    timeBegin = reqBo.getCreateTimeStart().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin);
                }
                if (reqBo.getCreateTimeEnd() != null) {
                    Long timeEnd = reqBo.getCreateTimeEnd().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").to((Object)timeEnd);
                }
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u521b\u5efa\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            if (reqBo.getExtSpuId().contains(",")) {
                String[] extSpuIds = reqBo.getExtSpuId().split(",");
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"ext_spu_id.keyword", (String[])extSpuIds));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id.keyword", (String)reqBo.getExtSpuId()));
            }
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            if (reqBo.getExtSkuId().contains(",")) {
                String[] extSkuIds = reqBo.getExtSkuId().split(",");
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"ext_sku_id.keyword", (String[])extSkuIds));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id.keyword", (String)reqBo.getExtSkuId()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)(reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)(reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)(reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)(reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)(reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)(reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)(reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)(reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            if (reqBo.getCommodityCode().contains(",")) {
                String[] commodityCodes;
                BoolQueryBuilder commodityCodeBuilder = QueryBuilders.boolQuery();
                for (String commodityCode : commodityCodes = reqBo.getCommodityCode().split(",")) {
                    wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)(commodityCode + "*"));
                    commodityCodeBuilder.should((QueryBuilder)wildcardQuery);
                }
                boolQueryBuilder.must((QueryBuilder)commodityCodeBuilder);
            } else {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)(reqBo.getCommodityCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            if (reqBo.getSkuCode().contains(",")) {
                String[] skuCodes;
                BoolQueryBuilder skuCodeBuilder = QueryBuilders.boolQuery();
                for (String skuCode : skuCodes = reqBo.getSkuCode().split(",")) {
                    wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(skuCode + "*"));
                    skuCodeBuilder.should((QueryBuilder)wildcardQuery);
                }
                boolQueryBuilder.must((QueryBuilder)skuCodeBuilder);
            } else {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(reqBo.getSkuCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)(reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (reqBo.getUpCount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"up_count", (Object)reqBo.getUpCount()));
        }
        RangeQueryBuilder discountQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private UccSkuManagementListQryCombRspBO dealSearchData(String result, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        log.info("ES\u67e5\u8be2\u5217\u8868" + commodityModels);
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSkuManagementListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            DicDictionaryPo dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccEMdmMaterialPO uccEMdmMaterialPO;
                    UccSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccSkuManagementListCombQryBO();
                    uccSkuManagementListQryBO.setGovernResult(cnncEsCommodityBo.getGovern_result());
                    uccSkuManagementListQryBO.setMaterialType(cnncEsCommodityBo.getMaterial_type());
                    uccSkuManagementListQryBO.setIfGovernDesc(cnncEsCommodityBo.getGovern_result() == null ? "\u5426" : "\u662f");
                    uccSkuManagementListQryBO.setBrandVerifyDesc(cnncEsCommodityBo.getBrand_verify() == null ? "\u5426" : (cnncEsCommodityBo.getBrand_verify() == 1 ? "\u662f" : "\u5426"));
                    uccSkuManagementListQryBO.setRegularPrice(cnncEsCommodityBo.getRegular_price());
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setUpCount(cnncEsCommodityBo.getUp_count());
                    dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(cnncEsCommodityBo.getCommodity_status().toString(), CommodityEnum.COMMODITY_STATUS.toString());
                    if (dicDictionaryPo != null) {
                        uccSkuManagementListQryBO.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_status()), SkuEnum.SKU_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
                        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.FROZEN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                            uccSkuManagementListQryBO.setDownTypeDesc(dicDictionaryPo.getTitle());
                            try {
                                List<UocSpuApproverLogPO> uocSpuApproverLogPOS;
                                UocApprovalObjPO uocApprovalObjPO = new UocApprovalObjPO();
                                uocApprovalObjPO.setObjId(uccSkuManagementListQryBO.getSkuId());
                                uocApprovalObjPO.setObjType(4);
                                List<UocApprovalObjPO> uocApprovalObjPOS = this.uocApprovalObjMapper.queryPo(uocApprovalObjPO);
                                if (!CollectionUtils.isEmpty(uocApprovalObjPOS) && !CollectionUtils.isEmpty(uocSpuApproverLogPOS = this.uocApprovalObjMapper.qryApproverLog(uocApprovalObjPOS.get(0).getAuditOrderId()))) {
                                    if (uocSpuApproverLogPOS.size() >= 2) {
                                        uccSkuManagementListQryBO.setDownReason(uocSpuApproverLogPOS.get(1).getAuditAdvice());
                                    } else {
                                        uccSkuManagementListQryBO.setDownReason(uocSpuApproverLogPOS.get(0).getAuditAdvice());
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u67e5\u8be2\u5ba1\u6279\u4e2d\u5fc3\u4e0b\u67b6\u539f\u56e0\u5931\u8d25", (Object)e.getMessage());
                            }
                        }
                    }
                    if (cnncEsCommodityBo.getSku_approval_status() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_approval_status()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_source()), SkuEnum.SKU_SOURCE.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(dicDictionaryPo.getTitle());
                    }
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
                    uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
                    uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
                        uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
                    }
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
                    }
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
                    }
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
                    uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
                    uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
                    uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
                    if (cnncEsCommodityBo.getCreate_time() != null) {
                        uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
                    }
                    if (cnncEsCommodityBo.getAudit_time() != null) {
                        uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
                    }
                    if ((uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByMaterialCode(uccSkuManagementListQryBO.getMaterialCode())) != null) {
                        uccSkuManagementListQryBO.setTexture(uccEMdmMaterialPO.getTexture());
                    }
                    uccSkuManagementListQryBO.setBelongModule(cnncEsCommodityBo.getBelongModule());
                    uccSkuManagementListQryBO.setCreateOperName(cnncEsCommodityBo.getCreate_oper_name());
                    uccSkuManagementListQryBO.setOrgName(cnncEsCommodityBo.getSupplier_org_name());
                    if (cnncEsCommodityBo.getBelongModule() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getBelongModule()), "BELONG_MODULE")) != null) {
                        uccSkuManagementListQryBO.setBelongModuleStr(dicDictionaryPo.getTitle());
                    }
                    uccSkuManagementListQryBO.setRunMainBodyId(cnncEsCommodityBo.getRunMainBodyId());
                    uccSkuManagementListQryBO.setRunMainBodyName(cnncEsCommodityBo.getRunMainBodyName());
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
            log.info("COPY\u5217\u8868\u2014\u2014" + uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Autowired
    public void setSkuDataGovernSamePriceMapper(SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper) {
        this.skuDataGovernSamePriceMapper = skuDataGovernSamePriceMapper;
    }
}

