/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuReqBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuRspBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuSpecBo;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDataGovernPushSkuServiceImpl
implements UccDataGovernPushSkuService {
    private static final Logger log = LoggerFactory.getLogger(UccDataGovernPushSkuServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Value(value="${DATA_GOVERN_SKU_PUSH_URL:}")
    private String skuPushUrl;
    @Value(value="${DATA_GOVERN_SKU_PRICE_PUSH_URL:}")
    private String skuPricePushUrl;

    @Override
    public UccDataGovernPushSkuRspBo dealDataGovernPushSku(UccDataGovernPushSkuReqBo reqBo) {
        List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
        UccDataGovernPushSkuRspBo rspBo = new UccDataGovernPushSkuRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBo.getSkuIds()) || reqBo.getType() == null) {
            return rspBo;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            return rspBo;
        }
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        Map<Object, Object> skuPirceMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            skuPirceMap = uccSkuPricePos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (first, second) -> first));
        }
        Map<Object, Object> materialMap = new HashMap();
        List<Long> materialIds = uccSkuPos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterialId())).map(a -> Long.valueOf(a.getMaterialId())).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds))) {
            materialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(a -> a.getMaterialId(), b -> b, (first, second) -> first));
        }
        List<Long> typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getListByType(typeIds);
        Map<Object, Object> catalogMap = new HashMap();
        Map<Object, Object> codeAndName = new HashMap();
        if (!CollectionUtils.isEmpty(uccEMdmCatalogPOS)) {
            catalogMap = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCommodityTypeId(), b -> b, (first, second) -> first));
            codeAndName = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCatalogCode(), b -> b.getCatalogName(), (first, second) -> first));
        }
        Map<Object, Object> skuSpecMap = new HashMap();
        List<UccSkuSpecPo> uccSkuSpecPos = this.uccSkuSpecMapper.qryBatchBySkus(reqBo.getSkuIds());
        if (!CollectionUtils.isEmpty(uccSkuSpecPos)) {
            skuSpecMap = uccSkuSpecPos.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
        }
        ArrayList<Object> skuBos = new ArrayList<Object>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccSkuPricePo uccSkuPricePo;
            UccEMdmCatalogPO uccEMdmCatalogPO;
            UccDataGovernPushSkuBo uccDataGovernPushSkuBo = new UccDataGovernPushSkuBo();
            BeanUtils.copyProperties((Object)uccSkuPo, (Object)uccDataGovernPushSkuBo);
            uccDataGovernPushSkuBo.setShopId(uccSkuPo.getSupplierShopId().toString());
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMaterialId())) {
                uccDataGovernPushSkuBo.setMaterialCode(((UccEMdmMaterialPO)materialMap.get(Long.valueOf(uccSkuPo.getMaterialId()))).getMaterialCode());
            }
            if ((uccEMdmCatalogPO = (UccEMdmCatalogPO)catalogMap.get(uccSkuPo.getCommodityTypeId())) != null) {
                uccDataGovernPushSkuBo.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
                uccDataGovernPushSkuBo.setCategoryName(uccEMdmCatalogPO.getCatalogName());
            }
            if ((uccSkuPricePo = (UccSkuPricePo)skuPirceMap.get(uccSkuPo.getSkuId())) != null) {
                uccDataGovernPushSkuBo.setSalesPrice(uccSkuPricePo.getSalePrice());
                uccDataGovernPushSkuBo.setMarketPrice(uccSkuPricePo.getMarketPrice());
                uccDataGovernPushSkuBo.setPrice(uccSkuPricePo.getAgreementPrice());
                if (uccSkuPricePo.getUpdateTime() != null) {
                    uccDataGovernPushSkuBo.setChangeTime(DateUtils.dateToStr(uccSkuPricePo.getUpdateTime()));
                }
            }
            ArrayList<UccDataGovernPushSkuSpecBo> specs = new ArrayList<UccDataGovernPushSkuSpecBo>();
            List skuSpecPos = (List)skuSpecMap.get(uccSkuPo.getSkuId());
            if (!CollectionUtils.isEmpty((Collection)skuSpecPos)) {
                for (UccSkuSpecPo skuSpecPo : skuSpecPos) {
                    UccDataGovernPushSkuSpecBo uccDataGovernPushSkuSpecBo = new UccDataGovernPushSkuSpecBo();
                    uccDataGovernPushSkuSpecBo.setPropName(skuSpecPo.getPropName());
                    uccDataGovernPushSkuSpecBo.setPropValue(skuSpecPo.getPropValue());
                    specs.add(uccDataGovernPushSkuSpecBo);
                }
            }
            uccDataGovernPushSkuBo.setSpecs(specs);
            skuBos.add(uccDataGovernPushSkuBo);
        }
        Map<String, List<UccDataGovernPushSkuBo>> reqData = skuBos.stream().collect(Collectors.groupingBy(a -> a.getCategoryCode()));
        String url = "";
        if (reqBo.getType() != null) {
            url = reqBo.getType() == 1 ? this.skuPushUrl : this.skuPricePushUrl;
        }
        try {
            for (Map.Entry entry : reqData.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("categoryCode", entry.getKey());
                jsonObject.put("categoryName", codeAndName.get(entry.getKey()));
                jsonObject.put("skuInfos", entry.getValue());
                JSONObject data = new JSONObject();
                data.put("data", (Object)jsonObject);
                data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                String reqStr = data.toJSONString();
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2\uff1a" + reqStr);
                HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rspBo;
    }
}

