/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.bo.QueryParam;
import com.tydic.commodity.busibase.busi.bo.SearchEsSQLRspBO;
import com.tydic.commodity.busibase.comb.api.SearchEsQueryService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.CommoditySingileRspBo;
import com.tydic.commodity.busibase.comb.bo.PropertyGrpRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.map.HashedMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SearchEsQueryServiceImpl
implements SearchEsQueryService {
    private static final Logger LOGGER = LogManager.getLogger(SearchEsQueryServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @Override
    public SearchEsRspBo executeSQL(SearchEsSQLRspBO searchEsSQLRspBO) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        String queryString = this.getQueryString(searchEsSQLRspBO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + queryString);
        }
        LOGGER.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result---->" + result);
            }
            SearchEsRspBo searchEsRspBo = this.dealSearchData(result, searchEsSQLRspBO.isNeedKeyWorld());
            if (searchEsSQLRspBO.isField()) {
                String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
                int total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
                searchEsRspBo.setTotal(total);
            }
            return searchEsRspBo;
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String getQueryString(SearchEsSQLRspBO searchEsSQLRspBO) {
        TermsAggregationBuilder teamAggSupplierCategory;
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)searchEsSQLRspBO.getPageSize());
        queryJson.put("from", (Object)(searchEsSQLRspBO.getPageSize() * (searchEsSQLRspBO.getPageNo() - 1)));
        String queryString = null;
        queryString = searchEsSQLRspBO.getFunctionScoreQueryBuilder() != null ? searchEsSQLRspBO.getFunctionScoreQueryBuilder().toString() : searchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = searchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSONObject.parseArray((String)searchEsSQLRspBO.getSortQuery().toString()));
        if (searchEsSQLRspBO.isField()) {
            JSONObject collapse = new JSONObject();
            collapse.put("field", (Object)"sku_id");
            queryJson.put("collapse", (Object)collapse);
        }
        JSONObject aggs = new JSONObject();
        boolean filterSupplier = true;
        boolean filterBrand = false;
        boolean filterCategory = false;
        boolean filterVendor = false;
        List<String> params = searchEsSQLRspBO.getHiddenParamsForRsp();
        if (params != null) {
            for (String param : params) {
                if ("supplier_id_name".equals(param)) {
                    filterSupplier = true;
                }
                if ("brand_id_name".equals(param)) {
                    filterBrand = true;
                }
                if ("l3_category_id_name".equals(param)) {
                    filterCategory = true;
                }
                if (!"vendor_id_name".equals(param)) continue;
                filterVendor = true;
            }
        }
        if (searchEsSQLRspBO.getLevel() != null && searchEsSQLRspBO.getLevel() == 3) {
            filterCategory = true;
        }
        if (!filterSupplier) {
            TermsAggregationBuilder teamAggSupplier = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_name").field("supplier_name.keyword")).size(2000);
            aggs.put("group_by_supplier_name", JSON.parseObject((String)teamAggSupplier.toString()).get((Object)"group_by_supplier_name"));
        }
        if (!filterBrand) {
            TermsAggregationBuilder teamAggSupplierBrand = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_name").field("brand_name.keyword")).size(2000);
            aggs.put("group_by_brand_name", JSON.parseObject((String)teamAggSupplierBrand.toString()).get((Object)"group_by_brand_name"));
        }
        if (!filterCategory) {
            teamAggSupplierCategory = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_name").field("l3_category_name.keyword")).size(2000);
            aggs.put("group_by_l3_category_name", JSON.parseObject((String)teamAggSupplierCategory.toString()).get((Object)"group_by_l3_category_name"));
        }
        if (!filterVendor) {
            teamAggSupplierCategory = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_vendor_name").field("vendor_name.keyword")).size(2000);
            aggs.put("group_by_vendor_name", JSON.parseObject((String)teamAggSupplierCategory.toString()).get((Object)"group_by_vendor_name"));
        }
        if (searchEsSQLRspBO.isField()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"sku_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private SearchEsRspBo dealSearchData(String result, boolean isNeedKeyWorld) {
        SearchEsRspBo rspBo = new SearchEsRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<CommodityRspBo> commodityModels = new ArrayList<CommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        ArrayList<String> propertyList = new ArrayList<String>();
        ArrayList<CommodityRspBo> otherProperty = new ArrayList<CommodityRspBo>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                CommodityRspBo commodity;
                block22: {
                    JSONObject hitObj = listObject.getJSONObject(i);
                    JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                    commodity = new CommodityRspBo();
                    try {
                        commodity = (CommodityRspBo)JSON.toJavaObject((JSON)data, CommodityRspBo.class);
                    }
                    catch (Exception e) {
                        LOGGER.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                        CommoditySingileRspBo single = new CommoditySingileRspBo();
                        try {
                            single = (CommoditySingileRspBo)JSON.toJavaObject((JSON)data, CommoditySingileRspBo.class);
                        }
                        catch (Exception e1) {
                            LOGGER.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
                            return rspBo;
                        }
                        BeanUtils.copyProperties((Object)single, (Object)commodity);
                        if (single.getL1_category_id() != null) {
                            commodity.setL1_category_id(new ArrayList<Long>(Arrays.asList(single.getL1_category_id())));
                        }
                        if (single.getL2_category_id() != null) {
                            commodity.setL2_category_id(new ArrayList<Long>(Arrays.asList(single.getL2_category_id())));
                        }
                        if (single.getL3_category_id() != null) {
                            commodity.setL3_category_id(new ArrayList<Long>(Arrays.asList(single.getL3_category_id())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL1_category_name())) {
                            commodity.setL1_category_name(new ArrayList<String>(Arrays.asList(single.getL1_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL2_category_name())) {
                            commodity.setL2_category_name(new ArrayList<String>(Arrays.asList(single.getL2_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL3_category_name())) {
                            commodity.setL3_category_name(new ArrayList<String>(Arrays.asList(single.getL3_category_name())));
                        }
                        if (single.getChannel_id() != null) {
                            commodity.setChannel_id(new ArrayList<Long>(Arrays.asList(single.getChannel_id())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getChannel_Name())) break block22;
                        commodity.setChannel_Name(Lists.newArrayList((Object[])new String[]{single.getChannel_Name()}));
                    }
                }
                if (!skuIdSet.contains(commodity.getSku_id())) {
                    String properties = commodity.getProperties();
                    if (!StringUtils.isEmpty((Object)properties)) {
                        propertyList.add(properties);
                        otherProperty.add(commodity);
                    }
                    commodityModels.add(commodity);
                }
                skuIdSet.add(commodity.getSku_id());
            }
        }
        rspBo.setTotal(total);
        rspBo.setCommodityRspBos(commodityModels);
        if (propertyList != null && propertyList.size() > 0 && isNeedKeyWorld) {
            this.queryAllPropertyList(rspBo, propertyList);
        }
        LinkedList<QueryParam> resultParams = new LinkedList<QueryParam>();
        JSONObject aggsObj = (JSONObject)resultObj.get((Object)"aggregations");
        if (aggsObj != null && !aggsObj.isEmpty()) {
            JSONObject vendorObject;
            JSONObject supplierObject;
            JSONObject brandObject;
            JSONObject categoryObject = aggsObj.getJSONObject("group_by_l3_category_name");
            if (categoryObject != null && !categoryObject.isEmpty()) {
                List<String> categoryValues = this.getNameList(categoryObject);
                QueryParam category3IdQP = new QueryParam();
                category3IdQP.setFilterId("l3_category_id_name");
                category3IdQP.setFilterName("\u5206\u7c7b");
                category3IdQP.setFilterValues(categoryValues);
                resultParams.add(category3IdQP);
            }
            if ((brandObject = aggsObj.getJSONObject("group_by_brand_name")) != null && !brandObject.isEmpty()) {
                List<String> brandValues = this.getNameList(brandObject);
                QueryParam brandQP = new QueryParam();
                brandQP.setFilterId("brand_id_name");
                brandQP.setFilterName("\u54c1\u724c");
                brandQP.setFilterValues(brandValues);
                resultParams.add(brandQP);
            }
            if ((supplierObject = aggsObj.getJSONObject("group_by_supplier_name")) != null && !supplierObject.isEmpty()) {
                List<String> supplierValues = this.getNameList(supplierObject);
                QueryParam supplierQP = new QueryParam();
                supplierQP.setFilterId("supplier_id_name");
                supplierQP.setFilterName("\u5546\u6237");
                supplierQP.setFilterValues(supplierValues);
                resultParams.add(supplierQP);
            }
            if ((vendorObject = aggsObj.getJSONObject("group_by_vendor_name")) != null && !vendorObject.isEmpty()) {
                List<String> vendorValues = this.getNameList(vendorObject);
                QueryParam vendorQP = new QueryParam();
                vendorQP.setFilterId("vendor_id_name");
                vendorQP.setFilterName("\u4f9b\u5e94\u5546");
                vendorQP.setFilterValues(vendorValues);
                resultParams.add(vendorQP);
            }
        }
        rspBo.setQueryParams(resultParams);
        return rspBo;
    }

    private List<String> getNameList(JSONObject object) {
        ArrayList<String> nameList = new ArrayList<String>();
        JSONArray bucketObject = object.getJSONArray("buckets");
        for (int i = 0; i < bucketObject.size(); ++i) {
            JSONObject jsonObject = bucketObject.getJSONObject(i);
            String name = jsonObject.getString("key");
            nameList.add(name);
        }
        return nameList;
    }

    private void queryAllPropertyList(SearchEsRspBo rspBo, List<String> properties) {
        TreeSet<String> defIds = new TreeSet<String>();
        for (String property : properties) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(property.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] propValues;
                    if (StringUtils.isEmpty((Object)line) || (propValues = line.split("\\*~~")) == null || propValues.length <= 0 || propValues.length != 3) continue;
                    defIds.add(propValues[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("\u5206\u89e3\u6240\u6709\u7684\u5c5e\u6027\u7ec4\u5f02\u5e38", (Throwable)e);
            }
        }
        if (defIds == null) {
            return;
        }
        String endPoint = "/" + this.esConfig.getPropIndexName() + "/" + this.esConfig.getPropIndexType() + "/_search";
        LinkedList<QueryParam> resultParams = new LinkedList<QueryParam>();
        String queryString = this.getQueryAttrString(defIds);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            List<QueryParam> queryParam;
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result---->" + result);
            }
            if ((queryParam = this.dealSearchAttributeData(result)) != null) {
                resultParams.addAll(queryParam);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u5206\u89e3\u6240\u6709\u7684\u5c5e\u6027\u7ec4\u5f02\u5e38", (Throwable)e);
        }
        rspBo.setPropParams(resultParams);
    }

    private void queryOtherPropertyList(List<CommodityRspBo> rspBos) {
        if (rspBos == null || rspBos.size() == 0) {
            return;
        }
        TreeSet<String> defIds = new TreeSet<String>();
        TreeSet<String> eachEdfIds = null;
        HashedMap defMap = new HashedMap();
        for (CommodityRspBo each : rspBos) {
            if (StringUtils.isEmpty((Object)each.getProperties())) continue;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(each.getProperties().getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
            eachEdfIds = new TreeSet<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] propValues;
                    if (StringUtils.isEmpty((Object)line) || (propValues = line.split("\\*~~")) == null || propValues.length <= 0 || propValues.length != 3) continue;
                    defIds.add(propValues[0]);
                    eachEdfIds.add(propValues[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("\u5206\u89e3\u6240\u6709\u7684\u5c5e\u6027\u7ec4\u5f02\u5e38", (Throwable)e);
            }
            defMap.put(each.getSku_id(), eachEdfIds);
        }
        if (defIds == null) {
            return;
        }
        String endPoint = "/" + this.esConfig.getPropIndexName() + "/" + this.esConfig.getPropIndexType() + "/_search";
        LinkedList resultParams = new LinkedList();
        JSONObject otherProp = new JSONObject();
        String queryString = this.getQueryAttrOther(rspBos);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            QueryParam queryParam;
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result---->" + result);
            }
            if ((queryParam = this.dealSearchAttributeData(result).get(0)) != null) {
                otherProp.put(queryParam.getFilterName(), queryParam.getFilterValues().get(0));
            }
        }
        catch (IOException e) {
            LOGGER.error("\u5206\u89e3\u6240\u6709\u7684\u5c5e\u6027\u7ec4\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getQueryAttrString(Set<String> defIds) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)1);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"filter_flag", (int)1));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_prop_def_id", (Object[])defIds.toArray()));
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"commodity_prop_grp_type", (int)3));
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        JSONObject aggs = new JSONObject();
        TermsAggregationBuilder termsAggrName = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_prop_name").field("show_name")).size(2000);
        TermsAggregationBuilder termsAggrvalue = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_prop_value").field("prop_value")).size(2000);
        termsAggrName.subAggregation((AggregationBuilder)termsAggrvalue);
        aggs.put("group_by_prop_name", JSON.parseObject((String)termsAggrName.toString()).get((Object)"group_by_prop_name"));
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private String getQueryAttrOther(List<CommodityRspBo> rspBos) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)10000);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_prop_grp_type", (int)3));
        ArrayList queryBuildersuery = new ArrayList();
        BoolQueryBuilder eachQueryBuilder = null;
        BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
        for (CommodityRspBo each : rspBos) {
            if (StringUtils.isEmpty((Object)each.getProperties())) continue;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(each.getProperties().getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] propValues;
                    if (StringUtils.isEmpty((Object)line) || (propValues = line.split("\\*~~")) == null || propValues.length <= 0 || propValues.length != 3) continue;
                    eachQueryBuilder = QueryBuilders.boolQuery();
                    eachQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_prop_def_id", (String)propValues[0]));
                    eachQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"prop_value_list_id", (String)propValues[1]));
                    shouldQueryBuilder.should((QueryBuilder)eachQueryBuilder);
                }
            }
            catch (IOException e) {
                LOGGER.error("\u5206\u89e3\u6240\u6709\u7684\u5c5e\u6027\u7ec4\u5f02\u5e38", (Throwable)e);
            }
        }
        boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"prop_value_list_id");
        queryJson.put("collapse", (Object)collapse);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        return queryJson.toString();
    }

    private List<QueryParam> dealSearchAttributeData(String result) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u5c5e\u6027\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        PropertyGrpRspBo attributeModel = new PropertyGrpRspBo();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                attributeModel = (PropertyGrpRspBo)JSON.toJavaObject((JSON)data, PropertyGrpRspBo.class);
            }
        }
        JSONObject aggsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject propNameObject = aggsObj.getJSONObject("group_by_prop_name");
        ArrayList<QueryParam> attributeQP = null;
        if (!propNameObject.isEmpty() && attributeModel.getProp_value_list_id() != null) {
            attributeQP = new ArrayList<QueryParam>();
            List<JSONObject> propNameList = this.getBuckets(propNameObject);
            if (!CollectionUtils.isEmpty(propNameList)) {
                for (JSONObject propName : propNameList) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.setFilterId("prop_name_" + propName.get((Object)"key").toString());
                    queryParam.setFilterName(propName.get((Object)"key").toString());
                    JSONObject propValueObject = propName.getJSONObject("group_by_prop_value");
                    queryParam.setFilterValues(this.getNameList(propValueObject));
                    attributeQP.add(queryParam);
                }
            }
        }
        return attributeQP;
    }

    private List<JSONObject> getBuckets(JSONObject object) {
        ArrayList<JSONObject> buckets = new ArrayList<JSONObject>();
        JSONArray bucketObject = object.getJSONArray("buckets");
        for (int i = 0; i < bucketObject.size(); ++i) {
            JSONObject jsonObject = bucketObject.getJSONObject(i);
            buckets.add(jsonObject);
        }
        return buckets;
    }
}

