/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomRspBo;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.busibase.atom.api.UccDealPoolSyncESAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ChannelPoolQryBo;
import com.tydic.commodity.po.CnncUccSkuPo;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealPoolSyncESAtomServiceImpl
implements UccDealPoolSyncESAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccDealPoolSyncESAtomServiceImpl.class);
    private static final int pageSize = 10000;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccRelCatalogBrandVendorPoolMapper uccRelCatalogBrandVendorPoolMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @Override
    public UccDealPoolSyncESAtomRspBo dealPoolSyncES(UccDealPoolSyncESAtomReqBo reqBo) {
        UccDealPoolSyncESAtomRspBo rspBo = new UccDealPoolSyncESAtomRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        switch (reqBo.getSyncType()) {
            case 0: {
                this.dealSkuIds(reqBo.getSkuIds());
                break;
            }
            case 1: {
                this.dealList(reqBo.getVendorIds(), null, null, null);
                break;
            }
            case 2: {
                this.dealList(null, null, reqBo.getTypeIds(), null);
                break;
            }
            case 3: {
                this.dealList(null, reqBo.getAgrIds(), null, null);
                break;
            }
            case 4: {
                this.dealByPoolIds(reqBo.getPoolIds());
                break;
            }
            case 5: {
                List<Long> typeIds = this.uccGuideCatalogExtMapper.getTypeIdByCat(reqBo.getGuideCatalogIds());
                this.dealList(null, null, typeIds, null);
                break;
            }
            case 6: {
                this.dealSpuIds(reqBo.getSpuIds());
                break;
            }
            case 7: {
                this.dealBrands(reqBo.getBrandIds());
            }
        }
        return rspBo;
    }

    private void dealBrands(List<Long> relIds) {
        List<UccRelCatalogBrandVendorPoolPO> uccRelCatalogBrandVendorPoolPOS = this.uccRelCatalogBrandVendorPoolMapper.qryListByRelIds(relIds);
        if (!CollectionUtils.isEmpty(uccRelCatalogBrandVendorPoolPOS)) {
            List<Long> skuIds;
            List<Long> vendorIds = uccRelCatalogBrandVendorPoolPOS.stream().map(UccRelCatalogBrandVendorPoolPO::getVendorId).collect(Collectors.toList());
            List<Long> catalogIds = uccRelCatalogBrandVendorPoolPOS.stream().map(UccRelCatalogBrandVendorPoolPO::getCatalogId).collect(Collectors.toList());
            List<Long> brandIds = uccRelCatalogBrandVendorPoolPOS.stream().map(UccRelCatalogBrandVendorPoolPO::getBrandId).collect(Collectors.toList());
            if (!(CollectionUtils.isEmpty(vendorIds) || CollectionUtils.isEmpty(catalogIds) || CollectionUtils.isEmpty(brandIds) || CollectionUtils.isEmpty(skuIds = this.uccSkuMapper.batchQrySkuBrandList(brandIds, catalogIds, vendorIds, new Page(-1, 10000))))) {
                this.dealSkuIds(skuIds);
            }
        }
    }

    private void dealList(List<Long> vendorIds, List<Long> argIds, List<Long> typeIds, List<Long> spus) {
        List<Long> skuList = this.uccSkuMapper.batchQrySkuList(vendorIds, argIds, typeIds, spus, 0, 0, new Page(-1, 10000));
        if (!CollectionUtils.isEmpty(skuList)) {
            this.dealSkuIds(skuList);
        }
    }

    private void dealSkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List<CnncUccSkuPo> uccSkuPos1 = this.uccSkuMapper.batchQrySkuForskuPool(null, skuIds);
        if (!CollectionUtils.isEmpty(uccSkuPos1)) {
            this.syncSkuPoolToES(uccSkuPos1);
            this.dealChannel(uccSkuPos1);
            for (CnncUccSkuPo uccSkuPo : uccSkuPos1) {
                JSONObject object = new JSONObject();
                object.put("skuPoolIds", uccSkuPo.getSkuPoolIds());
                object.put("channel_Name", uccSkuPo.getChannelNames());
                object.put("channel_id", uccSkuPo.getChannelIds());
                object.put("labelNames", uccSkuPo.getLabelNames());
                object.put("labelIds", uccSkuPo.getLabelIds());
                object.put("showLabelNames", uccSkuPo.getShowLabelNames());
                object.put("showLabelIds", uccSkuPo.getShowLabelIds());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), uccSkuPo.getSkuId().toString(), object);
            }
            log.info("\u540c\u6b65\u5546\u54c1\u6c60\u7ed3\u675f\uff01");
        }
    }

    private void dealSpuIds(List<Long> spuIds) {
        if (CollectionUtils.isEmpty(spuIds)) {
            return;
        }
        List<CnncUccSkuPo> uccSkuPos1 = this.uccSkuMapper.batchQrySkuForPoolBySpu(null, spuIds);
        if (!CollectionUtils.isEmpty(uccSkuPos1)) {
            this.syncSkuPoolToES(uccSkuPos1);
            this.dealChannel(uccSkuPos1);
            for (CnncUccSkuPo uccSkuPo : uccSkuPos1) {
                JSONObject object = new JSONObject();
                object.put("skuPoolIds", uccSkuPo.getSkuPoolIds());
                object.put("channel_Name", uccSkuPo.getChannelNames());
                object.put("channel_id", uccSkuPo.getChannelIds());
                object.put("labelNames", uccSkuPo.getLabelNames());
                object.put("labelIds", uccSkuPo.getLabelIds());
                object.put("showLabelNames", uccSkuPo.getShowLabelNames());
                object.put("showLabelIds", uccSkuPo.getShowLabelIds());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), uccSkuPo.getSkuId().toString(), object);
            }
            log.info("\u540c\u6b65\u5546\u54c1\u6c60\u7ed3\u675f\uff01");
        }
    }

    private void syncSkuPoolToES(List<CnncUccSkuPo> uccSkuPos) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agrIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<Long> spuIds = new ArrayList<Long>();
        ArrayList<Long> brandCataLogVendorId = new ArrayList<Long>();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId())) {
                spuIds.add(each.getCommodityId());
            }
            if (!brandCataLogVendorId.contains(each.getBrandCataLogVendorId())) {
                brandCataLogVendorId.add(each.getBrandCataLogVendorId());
            }
        });
        List<Object> uccRelPoolCommodityPosBySku = new ArrayList();
        List<Object> uccRelPoolCommodityPosByType = new ArrayList();
        List<Object> uccRelPoolCommodityPosByVendor = new ArrayList();
        List<Object> uccRelPoolCommodityPosByAgr = new ArrayList();
        List<Object> uccRelPoolCommodityPosByspu = new ArrayList();
        List<Object> uccRelPoolCommodityPosBybrandCataLogVendor = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(skuIds)) {
            uccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(typeIds)) {
            uccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(vendorIds)) {
            uccRelPoolCommodityPosByVendor = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(agrIds)) {
            uccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(spuIds)) {
            uccRelPoolCommodityPosByspu = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(brandCataLogVendorId)) {
            uccRelPoolCommodityPosBybrandCataLogVendor = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(brandCataLogVendorId, SkuPoolRelTypeConstant.REL_BY_BRANDCATALOGVENDOR);
        }
        for (CnncUccSkuPo uccSkuPo : uccSkuPos) {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosBySku)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosBySku) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getSkuId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                    uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByType)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByType) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getCommodityTypeId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                    uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByVendor)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByVendor) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getVendorId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                    uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByAgr)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByAgr) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getAgreementId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                    uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByspu)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByspu) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getCommodityId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                    uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                        uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        continue;
                    }
                    uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                    uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosBybrandCataLogVendor)) continue;
            for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosBybrandCataLogVendor) {
                if (!channelPoolQryBo.getSource().equals(uccSkuPo.getBrandCataLogVendorId())) continue;
                if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                    uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                    if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    }
                    if (channelPoolQryBo.getLabelId() == null) continue;
                    uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                    uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                    uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                    continue;
                }
                if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                    uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                }
                if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                    uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                    uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                    uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                    uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                }
                if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                    uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                    uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                    if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                    uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                    uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                    continue;
                }
                if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) || uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) continue;
                uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                if (channelPoolQryBo.getIsShow() == null || channelPoolQryBo.getIsShow() != 1) continue;
                if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                    uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                    uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                    continue;
                }
                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
            }
        }
    }

    private void dealChannel(List<CnncUccSkuPo> uccSkuPos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPos)) {
            return;
        }
        List<Long> skuIds = uccSkuPos.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        List<CnncUccSkuPo> uccSkuChanelPos = this.uccChannelMapper.qrySkuChannel(skuIds);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuChanelPos)) {
            HashMap skuAndChannelId = new HashMap();
            HashMap skuAndChannelName = new HashMap();
            Map<Long, List<CnncUccSkuPo>> map = uccSkuChanelPos.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
            for (Map.Entry<Long, List<CnncUccSkuPo>> each2 : map.entrySet()) {
                List channelIds = each2.getValue().stream().map(a -> a.getChannelId()).collect(Collectors.toList());
                List channelNames = each2.getValue().stream().map(a -> a.getChannelName()).collect(Collectors.toList());
                skuAndChannelId.put(each2.getKey(), channelIds);
                skuAndChannelName.put(each2.getKey(), channelNames);
            }
            uccSkuPos.forEach(each -> {
                if (CollectionUtils.isEmpty(each.getChannelIds())) {
                    each.setChannelIds((List)skuAndChannelId.get(each.getSkuId()));
                    each.setChannelNames((List)skuAndChannelName.get(each.getSkuId()));
                } else {
                    ((List)skuAndChannelId.get(each.getSkuId())).forEach(next -> {
                        if (!each.getChannelIds().contains(next)) {
                            each.getChannelIds().add((Long)next);
                        }
                    });
                    ((List)skuAndChannelName.get(each.getSkuId())).forEach(next -> {
                        if (!each.getChannelNames().contains(next)) {
                            each.getChannelNames().add((String)next);
                        }
                    });
                }
            });
        }
    }

    private void dealByPoolIds(List<Long> poolIds) {
        for (Long poolId : poolIds) {
            List<UccRelPoolCommodityPo> uccRelPoolCommodityPOS = this.uccRelPoolCommodityMapper.qryListShard(poolId, 0, 0, new Page(-1, 10000));
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPOS)) continue;
            Map<Integer, List<UccRelPoolCommodityPo>> map = uccRelPoolCommodityPOS.stream().collect(Collectors.groupingBy(a -> a.getPoolRelated()));
            for (Map.Entry<Integer, List<UccRelPoolCommodityPo>> each : map.entrySet()) {
                List<Long> dealIds = each.getValue().stream().map(a -> a.getSource()).collect(Collectors.toList());
                switch (each.getKey()) {
                    case 1: {
                        this.dealList(null, null, dealIds, null);
                        break;
                    }
                    case 2: {
                        this.dealList(null, dealIds, null, null);
                        break;
                    }
                    case 3: {
                        this.dealList(dealIds, null, null, null);
                        break;
                    }
                    case 4: {
                        this.dealSkuIds(dealIds);
                        break;
                    }
                    case 5: {
                        this.dealList(null, null, null, dealIds);
                    }
                }
            }
        }
    }
}

