/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccMallBrandDetailInfoGroupListAbilityPO;
import com.tydic.commodity.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccBrandAddBusiServiceImpl
implements UccBrandAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    private UccBrandDealMapper mapper;
    private UccBrandExtMapper uccBrandExtMapper;
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
    @Autowired
    private UccSyncBrandToDGAtomService uccSyncBrandToDGAtomService;

    @Override
    public UccBrandAddRspBO addBrand(UccBrandAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPo = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPo);
        UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPo);
        Long brandId = null;
        try {
            brandId = Sequence.getInstance().nextId();
            brandDealPo.setBrandId(brandId);
            if (brandDealPo.getBrandType() == null) {
                brandDealPo.setBrandType(1);
            }
            if (StringUtils.isEmpty((Object)brandDealPo.getBrandCode())) {
                brandDealPo.setBrandCode(brandDealPo.getBrandId().toString());
            }
            brandDealPo.setCreateOperId(reqBO.getUsername());
            brandDealPo.setCreateOperName(reqBO.getName());
            int result = this.mapper.addBrand(brandDealPo);
            if (result > 0) {
                this.rspBO.setRespCode("0000");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                this.rspBO.setBrandId(brandId);
            } else {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        try {
            UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
            uccSyncBrandToDGAtomReqBo.setBrandIds(Lists.newArrayList((Object[])new Long[]{brandId}));
            this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandAddReqBO reqBO) {
        Date expTime;
        if (CheckUtil.isBlank((String)reqBO.getBrandName())) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CheckUtil.isBlank((String)reqBO.getBelongOrg())) {
            this.rspBO.setRespDesc("\u65b0\u589e\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UccMallBrandDetailInfoGroupListAbilityPO queryPo = new UccMallBrandDetailInfoGroupListAbilityPO();
        queryPo.setMallBrandName(reqBO.getBrandName());
        queryPo.setBelongOrg(reqBO.getBelongOrg());
        List<UccMallBrandDetailInfoGroupListAbilityPO> mallBrandDetailGroupListByParam = this.uccBrandExtMapper.getMallBrandDetailGroupListByParam(queryPo);
        if (mallBrandDetailGroupListByParam.size() > 0) {
            this.rspBO.setRespDesc("\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u54c1\u724c\u540d\u79f0\u3001\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u7684\u6709\u6548\u54c1\u724c\u4e86\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = dateFormat.parse(reqBO.getExpTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (expTime.getTime() < new Date(System.currentTimeMillis()).getTime()) {
                this.rspBO.setRespDesc("\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                return false;
            }
        }
        if (reqBO.getBrandStatus() != null) {
            Map<String, String> map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime()) && !StringUtils.isEmpty((Object)reqBO.getEffTime())) {
            SimpleDateFormat str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        return true;
    }

    public static void transStringToDate(UccBrandAddReqBO reqBO, UccBrandDealPO brandDealPo) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        try {
            Date effTime1 = DateUtils.strToDate(effTime);
            Date expTime1 = DateUtils.strToDate(expTime);
            brandDealPo.setEffTime(effTime1);
            brandDealPo.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Autowired
    public void setMapper(UccBrandDealMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setUccBrandExtMapper(UccBrandExtMapper uccBrandExtMapper) {
        this.uccBrandExtMapper = uccBrandExtMapper;
    }

    @Autowired
    public void setUccDictionaryAtomService(UccBaseDictionaryAtomService uccDictionaryAtomService) {
        this.uccDictionaryAtomService = uccDictionaryAtomService;
    }
}

