/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApprovalBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMaterlSkuInfoBO;
import com.tydic.commodity.common.ability.bo.UccQryMaterialClassRspBO;
import com.tydic.commodity.dao.UccBeforeStatusRecordEditMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpAndOffApprovalBusiServiceImpl
implements UccUpAndOffApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpAndOffApprovalBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;
    @Autowired
    private UccBeforeStatusRecordEditMapper uccBeforeStatusRecordEditMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Resource(name="welfareActiveCalatalogUccProvider")
    private ProxyMessageProducer welfareActiveCalatalogUccProvider;
    @Value(value="${ACTIVE_SKU_CATALOG_TOPIC:ACTIVE_SKU_CATALOG_TOPIC}")
    private String ACTIVE_SKU_CATALOG_TOPIC;
    @Value(value="${ACTIVE_SKU_CATALOG_TAG:*}")
    private String ACTIVE_SKU_CATALOG_TAG;

    @Override
    public UccUpAndOffApprovalAbilityRspBO dealUpAndOffApproval(UccUpAndOffApprovalAbilityReqBO reqBO, ExtReqBO extReqBO) {
        UccUpAndOffApprovalAbilityRspBO rspBO = new UccUpAndOffApprovalAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5ba1\u6279\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getAuditResult() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getAuditResult() != 0 && reqBO.getAuditResult() != 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u679c\u5165\u53c2\u5fc5\u987b\u4e3a0\u62161");
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        Iterator<Long> iteratorSku = mapSku.keySet().iterator();
        ArrayList<Long> skuActiveList = new ArrayList<Long>();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<Object> uccSkuPos = new ArrayList();
            try {
                uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
                ArrayList failIds = new ArrayList();
                List<Long> failIdAudit = new ArrayList();
                if (uccSkuPos.size() < skus.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                    return rspBO;
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getApprovalStatus().toString().equals(extReqBO.getAuditStatusCheck())) continue;
                        failIdAudit.add(uccSkuPo.getSkuId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit))) {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(failIdAudit));
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u5355\u54c1" + failIdAudit.toString() + "\u4e0d\u5904\u4e8e\u5ba1\u6279\u4e2d\u72b6\u6001");
                    return rspBO;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = null;
            Map<String, List<UccSkuPo>> mapForAuditSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getStepId));
            HashMap ext = new HashMap(1);
            for (Map.Entry<String, List<UccSkuPo>> stringListEntry : mapForAuditSku.entrySet()) {
                UacNoTaskAuditOrderAuditRspBO uocAuditAbilityAuditRspBO;
                uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(extReqBO.getAuditObjType());
                List<UccSkuPo> skuPoListTmp = stringListEntry.getValue();
                List<Long> skuIds = skuPoListTmp.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                uocAuditAbilityAuditReqBO.setObjId(skuIds);
                uocAuditAbilityAuditReqBO.setStepId(stringListEntry.getKey().toString());
                uocAuditAbilityAuditReqBO.setAuditResult(reqBO.getAuditResult());
                uocAuditAbilityAuditReqBO.setOperId(reqBO.getUserId().toString());
                uocAuditAbilityAuditReqBO.setUsername(reqBO.getName());
                uocAuditAbilityAuditReqBO.setOrgId(reqBO.getOrgId());
                uocAuditAbilityAuditReqBO.setOrgName(reqBO.getOrgName());
                uocAuditAbilityAuditReqBO.setOperDept(reqBO.getCompanyName());
                uocAuditAbilityAuditReqBO.setExt(ext);
                uocAuditAbilityAuditReqBO.setMsgFlag(Integer.valueOf(0));
                uocAuditAbilityAuditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
                try {
                    uocAuditAbilityAuditRspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
                    if (!"0000".equals(uocAuditAbilityAuditRspBO.getRespCode())) {
                        throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), uocAuditAbilityAuditRspBO.getRespDesc());
                    }
                }
                catch (BusinessException e) {
                    log.error("\u5ba1\u6279\u62a5\u9519\uff1a" + e.getMessage());
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
                }
                if (uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                    if (reqBO.getAuditResult() == 0) {
                        this.updateSkuStatus(extReqBO.getStatusApproval(), extReqBO.getAuditStatusConsent(), "null", skuIds, supplierShopId, reqBO);
                        rspBO.setFinish(uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish());
                        try {
                            for (Long skuId : skuIds) {
                                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                                uccSkuPutCirReqBO.setRemark("\u5f3a\u5236\u4e0b\u67b6");
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setUptype(1);
                                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                                    uccSkuPutCirReqBO.setRemark("\u6062\u590d\u4e0a\u67b6\u5ba1\u6279");
                                }
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setDownType(1);
                                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                                    uccSkuPutCirReqBO.setRemark("\u4e0b\u67b6\u5ba1\u6279");
                                }
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) {
                                    uccSkuPutCirReqBO.setUptype(1);
                                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                                    uccSkuPutCirReqBO.setRemark("\u4e0a\u67b6\u5ba1\u6279");
                                }
                                uccSkuPutCirReqBO.setSkuId(skuId);
                                uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                                if (!"0000".equals(uccSkuPutCirRspBO.getRespCode())) {
                                    throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                                }
                                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) continue;
                                skuActiveList.add(skuId);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                        }
                    }
                    if (reqBO.getAuditResult() != 1) continue;
                    try {
                        if (extReqBO.isNoChangeStatus()) {
                            this.updateSkuStatus(null, extReqBO.getAuditStatusReject(), "null", skus, supplierShopId, reqBO);
                            continue;
                        }
                        this.updateSkuStatus(extReqBO.getStatusOld().get(0), extReqBO.getAuditStatusReject(), "null", skus, supplierShopId, reqBO);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                    }
                }
                try {
                    if (StringUtils.isEmpty((Object)uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId())) continue;
                    this.uccSkuMapper.batchUpdateStepBySkuId(skuIds, uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId(), supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
        }
        this.newlyAddedActivite(reqBO.getAuditResult(), skuActiveList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUpAndOffApprovalAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }

    private void newlyAddedActivite(Integer auditResult, List<Long> skuActiveList) {
        if (auditResult == 0 && !CollectionUtils.isEmpty(skuActiveList)) {
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.selectMaterialCatalogWelfare(null, skuActiveList);
            UccQryMaterialClassRspBO classRspBO = new UccQryMaterialClassRspBO();
            List collect = uccSkuPos.stream().map(obj -> {
                UccMaterlSkuInfoBO infoBO = new UccMaterlSkuInfoBO();
                BeanUtils.copyProperties((Object)obj, (Object)infoBO);
                if (obj.getSkuPrice() != null) {
                    infoBO.setBuyPrice(MoneyUtils.haoToYuan(obj.getSkuPrice()));
                }
                return infoBO;
            }).collect(Collectors.toList());
            classRspBO.setMaterlSkuInfoBOS(collect);
            log.info("\u4e0a\u67b6\u5ba1\u6279-\u6d3b\u52a8\u7c7b\u76ee\u53d1\u9001\u6d88\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)classRspBO));
            this.welfareActiveCalatalogUccProvider.send(new ProxyMessage(this.ACTIVE_SKU_CATALOG_TOPIC, this.ACTIVE_SKU_CATALOG_TAG, JSON.toJSONString((Object)classRspBO)));
        }
    }
}

