/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.UccProcNodePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccApproveCreationAtomServiceImpl
implements UccApproveCreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveCreationAtomServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService auditCreateListAbilityService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Override
    @DuplicateCommitLimit
    public UccApproveCreationAtomRspBO createApprove(UccApproveCreationAtomReqBO reqBO) {
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        UccApproveCreationAtomRspBO rspBO = new UccApproveCreationAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getObjId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u5bf9\u8c61\u96c6\u5408");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMenuId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u83dc\u5355ID");
        }
        ArrayList listBusiReqBOS = Lists.newArrayList();
        for (Long each : reqBO.getObjId()) {
            UccProcNodePO uccProcNodePO;
            if (reqBO.getCheckOnAudit().booleanValue() && reqBO.getOrderId() != null && (uccProcNodePO = this.uocApprovalObjMapper.qryProcNode(each.toString(), reqBO.getOrderId())) != null && !StringUtils.isEmpty((Object)uccProcNodePO.getProcDefId())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8be5\u6570\u636e\u5df2\u7ecf\u5728\u5ba1\u6279\u4e2d");
            }
            ArrayList approvalObjBOS = Lists.newArrayList();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(String.valueOf(each));
            approvalObjBO.setOrderId(reqBO.getOrderId());
            approvalObjBOS.add(approvalObjBO);
            UacNoTaskAuditCreateInfoReqBO auditOrderCreateListBusiReqBO = new UacNoTaskAuditCreateInfoReqBO();
            auditOrderCreateListBusiReqBO.setApprovalObjInfo((List)approvalObjBOS);
            auditOrderCreateListBusiReqBO.setObjNum(String.valueOf(approvalObjBOS.size()));
            auditOrderCreateListBusiReqBO.setObjType(reqBO.getObjType());
            auditOrderCreateListBusiReqBO.setOrderId(reqBO.getOrderId());
            auditOrderCreateListBusiReqBO.setOrgId(reqBO.getOrgId());
            auditOrderCreateListBusiReqBO.setDownload(reqBO.getFileAnnex());
            auditOrderCreateListBusiReqBO.setRemark(reqBO.getAuditAdvice());
            listBusiReqBOS.add(auditOrderCreateListBusiReqBO);
        }
        UacNoTaskAuditCreateReqBO uocAuditAbiltyCreateListReqBO = new UacNoTaskAuditCreateReqBO();
        uocAuditAbiltyCreateListReqBO.setCreateBusiReqBO((List)listBusiReqBOS);
        uocAuditAbiltyCreateListReqBO.setCreateOperId(reqBO.getUserId().toString());
        uocAuditAbiltyCreateListReqBO.setCreateOperName(reqBO.getName());
        uocAuditAbiltyCreateListReqBO.setCreateOperDept(reqBO.getOrgName());
        uocAuditAbiltyCreateListReqBO.setMenuId(reqBO.getMenuId());
        uocAuditAbiltyCreateListReqBO.setProcDefKey(reqBO.getProcDefKey());
        if (reqBO.getOrgIdIn() != null && ("APPLY_SHELVES_FORM_PROCESS".equals(reqBO.getMenuId()) || reqBO.getMenuId().contains("M00100"))) {
            uocAuditAbiltyCreateListReqBO.setOrgId(reqBO.getOrgIdIn().toString());
        }
        uocAuditAbiltyCreateListReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        try {
            log.info("\u521b\u5efa\u5ba1\u6279\u5355\u6570\u636euocAuditAbiltyCreateListReqBO \uff1a" + JSON.toJSON((Object)uocAuditAbiltyCreateListReqBO));
            uacNoTaskAuditCreateRspBO = this.auditCreateListAbilityService.auditOrderCreate(uocAuditAbiltyCreateListReqBO);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        rspBO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
        rspBO.setFinish(uacNoTaskAuditCreateRspBO.getFinish());
        rspBO.setNotFindFlag(uacNoTaskAuditCreateRspBO.getNotFindFlag());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

