/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.PoolRelatedTypeEnum;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageCombService;
import com.tydic.commodity.busibase.comb.api.UccQrySkuPoolListCombService;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombReqBo;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombRspBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombReqBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombRspBo;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccQrySkuPoolListCombServiceImpl
implements UccQrySkuPoolListCombService {
    private static final Logger log = LoggerFactory.getLogger(UccQrySkuPoolListCombServiceImpl.class);
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private SearchCommodityManageCombService searchCommodityManageCombService;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;

    @Override
    public UccQrySkuPoolListCombRspBo qrySkuPoolList(UccQrySkuPoolListCombReqBo reqBo) {
        UccQrySkuPoolListCombRspBo rspBo = new UccQrySkuPoolListCombRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UccCommodityPoolPO uccCommodityPoolPO = new UccCommodityPoolPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)uccCommodityPoolPO);
        uccCommodityPoolPO.setPoolState(reqBo.getPoolStatus());
        List<UccCommodityPoolPO> uccCommodityPoolPOS = this.uccCommodityPoolMapper.queryPageList(page, uccCommodityPoolPO);
        ArrayList cnncQrySkuPoolListAbilityBos = new ArrayList();
        if (!CollectionUtils.isEmpty(uccCommodityPoolPOS)) {
            uccCommodityPoolPOS.forEach(each -> {
                List<UccRelPoolCommodityPo> uccRelPoolCommodityPos;
                Map<Integer, Long> isShowLabelCountMap;
                UccQrySkuPoolListCombBo cnncQrySkuPoolListAbilityBo = new UccQrySkuPoolListCombBo();
                BeanUtils.copyProperties((Object)each, (Object)cnncQrySkuPoolListAbilityBo);
                cnncQrySkuPoolListAbilityBo.setPoolStatus(each.getPoolState());
                if (each.getPoolState() != null) {
                    cnncQrySkuPoolListAbilityBo.setPoolStatusDesc(each.getPoolState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                }
                cnncQrySkuPoolListAbilityBo.setRelSkuType(each.getPoolRelated());
                if (each.getPoolRelated() != null) {
                    cnncQrySkuPoolListAbilityBo.setRelSkuTypeDesc(PoolRelatedTypeEnum.getPoolRelatedTypeDesc((Integer)each.getPoolRelated()).getDesc());
                }
                SearchCommodityManageCombReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageCombReqBo();
                searchCommodityManageAbilityReqBo.setPoolIds(Lists.newArrayList((Object[])new Long[]{each.getPoolId()}));
                SearchCommodityManageCombRspBo searchCommodityManageAbilityRspBo = this.searchCommodityManageCombService.searchCommodity(searchCommodityManageAbilityReqBo);
                try {
                    cnncQrySkuPoolListAbilityBo.setPoolSkuNum(Long.valueOf(searchCommodityManageAbilityRspBo.getRecordsTotal()));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u83b7\u53d6\u603b\u6570\u5931\u8d25\uff01");
                }
                List<UccCommodityLabelPo> cnncCommodityLabelPos = this.cnncCommodityLabelMapper.selectLabel(null, Lists.newArrayList((Object[])new Long[]{each.getPoolId()}));
                if (!CollectionUtils.isEmpty(cnncCommodityLabelPos) && !CollectionUtils.isEmpty(isShowLabelCountMap = cnncCommodityLabelPos.stream().collect(Collectors.groupingBy(UccCommodityLabelPo::getIsShow, Collectors.counting())))) {
                    Long isShowLabelCount = isShowLabelCountMap.get(1);
                    cnncQrySkuPoolListAbilityBo.setConnectLabelNum(cnncCommodityLabelPos.size());
                    cnncQrySkuPoolListAbilityBo.setIsShowLabelNum(isShowLabelCount);
                }
                if (!CollectionUtils.isEmpty(uccRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPoolsRelated(Lists.newArrayList((Object[])new Long[]{each.getPoolId()}), each.getPoolRelated()))) {
                    cnncQrySkuPoolListAbilityBo.setRelNum(uccRelPoolCommodityPos.size());
                } else {
                    cnncQrySkuPoolListAbilityBo.setRelNum(0);
                }
                cnncQrySkuPoolListAbilityBos.add(cnncQrySkuPoolListAbilityBo);
            });
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRows(cnncQrySkuPoolListAbilityBos);
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

