/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.dao.BrandAccessoryVersionMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccBrandVersionMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.po.BrandAccessoryVersionPO;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccBrandVersionPO;
import com.tydic.commodity.po.UccMallBrandDetailInfoGroupListAbilityPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccBrandAddBusiServiceImpl
implements UccBrandAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    private UccBrandDealMapper mapper;
    private UccBrandExtMapper uccBrandExtMapper;
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
    @Autowired
    private UccSyncBrandToDGAtomService uccSyncBrandToDGAtomService;
    @Autowired
    private UccBrandVersionMapper uccBrandVersionMapper;
    @Autowired
    private BrandAccessoryVersionMapper brandAccessoryVersionMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;

    @Override
    public UccBrandAddRspBO addBrandVersion(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        log.info("^^^^^^^^^^^^^^^^^^^^^addBrandVersionaddBrandVersionaddBrandVersion^^^{}", JSON.toJSON((Object)reqBO));
        try {
            if (!this.judgeVersion(reqBO)) {
                throw new Exception("\u8be5\u54c1\u724c\u5df2\u5b58\u5728\u6216\u7533\u8bf7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
            }
            UccBrandVersionPO brandDealPo = new UccBrandVersionPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPo);
            UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPo);
            Long brandId = null;
            brandId = Sequence.getInstance().nextId();
            brandDealPo.setBrandId(brandId);
            if (brandDealPo.getBrandType() == null) {
                brandDealPo.setBrandType(1);
            }
            if (StringUtils.isEmpty((Object)brandDealPo.getBrandCode())) {
                brandDealPo.setBrandCode(brandDealPo.getBrandId().toString());
            }
            if (!ObjectUtils.isEmpty((Object)reqBO.getIsprofess()) && "2".equals(reqBO.getIsprofess())) {
                brandDealPo.setCreateOperId(reqBO.getOrgId() + "");
                brandDealPo.setCreateOperName(reqBO.getOrgName());
            } else {
                brandDealPo.setCreateOperId(reqBO.getUsername());
                brandDealPo.setCreateOperName(reqBO.getName());
            }
            brandDealPo.setCreateTime(new Date());
            brandDealPo.setBrandVersion("V1");
            int result = this.uccBrandVersionMapper.insert(brandDealPo);
            if (result > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                rspBO.setBrandId(brandId);
                List brandAccessoryVersionBOs = reqBO.getBrandAccessoryVersionBOs();
                List brandAccessoryVersionPOS = JSON.parseArray((String)JSON.toJSONString((Object)brandAccessoryVersionBOs), BrandAccessoryVersionPO.class);
                brandAccessoryVersionPOS.forEach(a -> {
                    a.setBrandVersion(brandDealPo.getBrandVersion());
                    a.setRelId(brandDealPo.getBrandId());
                });
                this.brandAccessoryVersionMapper.insertBatch(brandAccessoryVersionPOS);
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        return rspBO;
    }

    @Override
    public UccBrandAddRspBO selectBrandVersion(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccBrandVersionPO uccBrandVersionPO = (UccBrandVersionPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccBrandVersionPO.class);
        log.info("^^^^^^^^^^^^^^POuccBrandVersionPOuccBrandVersionPO---{}", (Object)JSONObject.toJSONString((Object)uccBrandVersionPO));
        List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.selectAll(uccBrandVersionPO, (Page<UccBrandVersionPO>)page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(uccBrandVersionPOS);
        return rspBO;
    }

    @Override
    public UccBrandAddRspBO selectBrandVersionDetail(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        UccBrandVersionPO uccBrandVersionPO = new UccBrandVersionPO();
        uccBrandVersionPO.setId(reqBO.getId());
        List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.selectAll(uccBrandVersionPO);
        if (!ObjectUtils.isEmpty(uccBrandVersionPOS)) {
            BrandAccessoryVersionPO po = new BrandAccessoryVersionPO();
            po.setRelId(uccBrandVersionPOS.get(0).getBrandId());
            po.setBrandVersion(uccBrandVersionPOS.get(0).getBrandVersion());
            List<BrandAccessoryVersionPO> brandAccessoryVersionPOS = this.brandAccessoryVersionMapper.selectAll(po);
            uccBrandVersionPOS.get(0).setBrandAccessoryVersionPOS(brandAccessoryVersionPOS);
        }
        rspBO.setRows(uccBrandVersionPOS);
        return rspBO;
    }

    @Override
    public UccBrandAddRspBO deleteBrandVersion(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        UccBrandVersionPO uccBrandVersionPO = new UccBrandVersionPO();
        uccBrandVersionPO.setId(reqBO.getId());
        uccBrandVersionPO = this.uccBrandVersionMapper.selectById(uccBrandVersionPO);
        try {
            this.uccBrandVersionMapper.delete(uccBrandVersionPO);
            BrandAccessoryVersionPO brandAccessoryVersionPO = new BrandAccessoryVersionPO();
            brandAccessoryVersionPO.setRelId(uccBrandVersionPO.getBrandId());
            brandAccessoryVersionPO.setBrandVersion(uccBrandVersionPO.getBrandVersion());
            this.brandAccessoryVersionMapper.delete(brandAccessoryVersionPO);
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(uccBrandVersionPO.getBrandId());
            UccBrandDealPO uccBrandDeal = this.mapper.selectById(uccBrandDealPO);
            if (!ObjectUtils.isEmpty((Object)uccBrandDeal)) {
                uccBrandDealPO.setIsChange(0);
                this.mapper.updateBrand(uccBrandDealPO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        return rspBO;
    }

    @Override
    public UccBrandAddRspBO updateBrandVersion(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBo = new UccBrandAddRspBO();
        log.info("^^^^^^^^^^^^^^^updateBrandVersionupdateBrandVersion^^^^^^{}", (Object)JSON.toJSONString((Object)reqBO));
        try {
            UccBrandVersionPO queryPo = new UccBrandVersionPO();
            queryPo.setBrandName(reqBO.getBrandName());
            queryPo.setBelongOrg(reqBO.getBelongOrg());
            queryPo.setBrandId(reqBO.getBrandId());
            List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.verifyBrandRepetition(queryPo);
            if (!ObjectUtils.isEmpty(uccBrandVersionPOS) && uccBrandVersionPOS.size() > 0) {
                throw new Exception("\u8be5\u54c1\u724c\u5df2\u5b58\u5728\u6216\u7533\u8bf7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
            }
            UccBrandVersionPO uccBrandVersionPO = (UccBrandVersionPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UccBrandVersionPO.class);
            this.uccBrandVersionMapper.update(uccBrandVersionPO);
            UccBrandVersionPO po = new UccBrandVersionPO();
            po.setId(reqBO.getId());
            uccBrandVersionPO = this.uccBrandVersionMapper.selectById(po);
            BrandAccessoryVersionPO brandAccessoryVersionPO = new BrandAccessoryVersionPO();
            brandAccessoryVersionPO.setRelId(uccBrandVersionPO.getBrandId());
            brandAccessoryVersionPO.setBrandVersion(uccBrandVersionPO.getBrandVersion());
            this.brandAccessoryVersionMapper.delete(brandAccessoryVersionPO);
            List brandAccessoryVersionBOs = reqBO.getBrandAccessoryVersionBOs();
            List brandAccessoryVersionPOS = JSON.parseArray((String)JSON.toJSONString((Object)brandAccessoryVersionBOs), BrandAccessoryVersionPO.class);
            for (BrandAccessoryVersionPO brandAccessoryVersionDO : brandAccessoryVersionPOS) {
                brandAccessoryVersionDO.setBrandVersion(uccBrandVersionPO.getBrandVersion());
                brandAccessoryVersionDO.setRelId(uccBrandVersionPO.getBrandId());
            }
            this.brandAccessoryVersionMapper.insertBatch(brandAccessoryVersionPOS);
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        return this.rspBO;
    }

    @Override
    public UccBrandAddRspBO updateBrandVersionStatus(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        UccBrandVersionPO po = new UccBrandVersionPO();
        if (ObjectUtils.isEmpty((Object)reqBO.getIds())) {
            po.setId(reqBO.getId());
            po.setStatus(reqBO.getStatus());
            po.setReason(reqBO.getReason());
            if (reqBO.getStatus().equals(2)) {
                try {
                    if (!ObjectUtils.isEmpty((Object)reqBO.getIsprofess()) && "2".equals(reqBO.getIsprofess())) {
                        po.setConfirmOperId(reqBO.getOrgId() + "");
                        po.setConfirmOperName(reqBO.getOrgName());
                    } else {
                        po.setConfirmOperId(reqBO.getUsername());
                        po.setConfirmOperName(reqBO.getName());
                    }
                    po.setConfirmTime(new Date());
                    UccBrandVersionPO uccBrandVersionPO = this.uccBrandVersionMapper.selectById(po);
                    UccBrandVersionPO queryPo = new UccBrandVersionPO();
                    queryPo.setBrandName(uccBrandVersionPO.getBrandName());
                    queryPo.setBelongOrg(uccBrandVersionPO.getBelongOrg());
                    queryPo.setBrandId(uccBrandVersionPO.getBrandId());
                    List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.verifyBrandRepetition(queryPo);
                    if (!ObjectUtils.isEmpty(uccBrandVersionPOS) && uccBrandVersionPOS.size() > 0) {
                        throw new Exception("\u8be5\u54c1\u724c\u5df2\u5b58\u5728\u6216\u7533\u8bf7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
                    }
                    UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
                    uccBrandDealPO.setBrandId(uccBrandVersionPO.getBrandId());
                    UccBrandDealPO uccBrandDeal = this.mapper.selectByOne(uccBrandDealPO);
                    log.info("^^^^^^^^^^^^^uccBrandDealuccBrandDealuccBrandDeal^^^^{}", (Object)JSON.toJSONString((Object)uccBrandDeal));
                    UccBrandDealPO brandDealPO = (UccBrandDealPO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandVersionPO), UccBrandDealPO.class);
                    brandDealPO.setConfirmOperId(po.getConfirmOperId());
                    brandDealPO.setConfirmOperName(po.getConfirmOperName());
                    brandDealPO.setConfirmTime(po.getConfirmTime());
                    if (ObjectUtils.isEmpty((Object)uccBrandDeal)) {
                        this.mapper.insert(brandDealPO);
                    } else {
                        brandDealPO.setIsChange(0);
                        this.mapper.updateBrand(brandDealPO);
                    }
                    try {
                        UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
                        uccSyncBrandToDGAtomReqBo.setBrandIds(Lists.newArrayList((Object[])new Long[]{brandDealPO.getBrandId()}));
                        this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("8888", e.getMessage());
                }
            }
            this.uccBrandVersionMapper.update(po);
        } else {
            for (Long id : reqBO.getIds()) {
                po.setId(id);
                po.setStatus(reqBO.getStatus());
                po.setReason(reqBO.getReason());
                if (reqBO.getStatus().equals(2)) {
                    try {
                        po.setConfirmTime(new Date());
                        po.setConfirmOperId(reqBO.getUsername());
                        po.setConfirmOperName(reqBO.getName());
                        UccBrandVersionPO uccBrandVersionPO = this.uccBrandVersionMapper.selectById(po);
                        UccBrandVersionPO queryPo = new UccBrandVersionPO();
                        queryPo.setBrandName(uccBrandVersionPO.getBrandName());
                        queryPo.setBelongOrg(uccBrandVersionPO.getBelongOrg());
                        queryPo.setBrandId(uccBrandVersionPO.getBrandId());
                        List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.verifyBrandRepetition(queryPo);
                        if (!ObjectUtils.isEmpty(uccBrandVersionPOS) && uccBrandVersionPOS.size() > 0) {
                            throw new Exception("\u8be5\u54c1\u724c\u5df2\u5b58\u5728\u6216\u7533\u8bf7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
                        }
                        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
                        uccBrandDealPO.setBrandId(uccBrandVersionPO.getBrandId());
                        UccBrandDealPO uccBrandDeal = this.mapper.selectByOne(uccBrandDealPO);
                        log.info("^^^^^^^^^^^^^uccBrandDealuccBrandDealuccBrandDeal^^^^{}", (Object)JSON.toJSONString((Object)uccBrandDeal));
                        UccBrandDealPO brandDealPO = (UccBrandDealPO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandVersionPO), UccBrandDealPO.class);
                        brandDealPO.setConfirmOperId(po.getConfirmOperId());
                        brandDealPO.setConfirmOperName(po.getConfirmOperName());
                        brandDealPO.setConfirmTime(po.getConfirmTime());
                        if (ObjectUtils.isEmpty((Object)uccBrandDeal)) {
                            this.mapper.insert(brandDealPO);
                        } else {
                            brandDealPO.setIsChange(0);
                            this.mapper.updateBrand(brandDealPO);
                        }
                        try {
                            UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
                            uccSyncBrandToDGAtomReqBo.setBrandIds(Lists.newArrayList((Object[])new Long[]{brandDealPO.getBrandId()}));
                            this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
                        }
                        catch (Exception e) {
                            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", e.getMessage());
                    }
                }
                this.uccBrandVersionMapper.update(po);
            }
        }
        return rspBO;
    }

    @Override
    public UccBrandAddRspBO addChangeBrandVersion(UccBrandAddReqBO reqBO) {
        log.info("^^^^^^^^^^^^^^^^^^^^^addChangeBrandVersionaddChangeBrandVersion^^^{}", JSON.toJSON((Object)reqBO));
        UccBrandVersionPO queryPo = new UccBrandVersionPO();
        try {
            queryPo.setBrandName(reqBO.getBrandName());
            queryPo.setBelongOrg(reqBO.getBelongOrg());
            queryPo.setBrandId(reqBO.getBrandId());
            List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.verifyBrandRepetition(queryPo);
            if (!ObjectUtils.isEmpty(uccBrandVersionPOS) && uccBrandVersionPOS.size() > 0) {
                throw new Exception("\u8be5\u54c1\u724c\u5df2\u5b58\u5728\u6216\u7533\u8bf7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
            }
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(reqBO.getBrandId());
            uccBrandDealPO.setIsChange(1);
            this.mapper.updateBrand(uccBrandDealPO);
            uccBrandDealPO = this.mapper.selectById(uccBrandDealPO);
            String version = "V";
            if (ObjectUtils.isEmpty((Object)uccBrandDealPO.getBrandVersion())) {
                version = "V1";
            } else {
                String[] vs = uccBrandDealPO.getBrandVersion().split("V");
                int i = Integer.parseInt(vs[1]) + 1;
                version = version + i;
            }
            UccBrandVersionPO brandDealPo = new UccBrandVersionPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPo);
            UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPo);
            if (brandDealPo.getBrandType() == null) {
                brandDealPo.setBrandType(1);
            }
            if (StringUtils.isEmpty((Object)brandDealPo.getBrandCode())) {
                brandDealPo.setBrandCode(brandDealPo.getBrandId().toString());
            }
            brandDealPo.setCreateOperId(uccBrandDealPO.getCreateOperId());
            brandDealPo.setCreateOperName(uccBrandDealPO.getCreateOperName());
            brandDealPo.setCreateTime(uccBrandDealPO.getCreateTime());
            if (!ObjectUtils.isEmpty((Object)reqBO.getIsprofess()) && "2".equals(reqBO.getIsprofess())) {
                brandDealPo.setUpdateOperId(reqBO.getOrgId() + "");
                brandDealPo.setUpdateOperName(reqBO.getOrgName());
            } else {
                brandDealPo.setUpdateOperId(reqBO.getUsername());
                brandDealPo.setUpdateOperName(reqBO.getName());
            }
            brandDealPo.setUpdateTime(new Date());
            brandDealPo.setBrandVersion(version);
            brandDealPo.setConfirmOperId(null);
            brandDealPo.setConfirmOperName(null);
            int result = this.uccBrandVersionMapper.insert(brandDealPo);
            if (result > 0) {
                this.rspBO.setRespCode("0000");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                List brandAccessoryVersionBOs = reqBO.getBrandAccessoryVersionBOs();
                List brandAccessoryVersionPOS = JSON.parseArray((String)JSON.toJSONString((Object)brandAccessoryVersionBOs), BrandAccessoryVersionPO.class);
                brandAccessoryVersionPOS.forEach(a -> {
                    a.setBrandVersion(brandDealPo.getBrandVersion());
                    a.setRelId(brandDealPo.getBrandId());
                });
                this.brandAccessoryVersionMapper.insertBatch(brandAccessoryVersionPOS);
            } else {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        return this.rspBO;
    }

    @Override
    public UccBrandAddRspBO updateRelCatalogBrandVendor(UccBrandAddReqBO reqBO) {
        try {
            UccRelCatalogBrandVendorPO vendorPO = (UccRelCatalogBrandVendorPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UccRelCatalogBrandVendorPO.class);
            this.uccRelCatalogBrandVendorMapper.updateById(vendorPO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new UccBrandAddRspBO();
    }

    @Override
    public UccBrandAddRspBO addBrand(UccBrandAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPo = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPo);
        UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPo);
        Long brandId = null;
        try {
            brandId = Sequence.getInstance().nextId();
            brandDealPo.setBrandId(brandId);
            if (brandDealPo.getBrandType() == null) {
                brandDealPo.setBrandType(1);
            }
            if (StringUtils.isEmpty((Object)brandDealPo.getBrandCode())) {
                brandDealPo.setBrandCode(brandDealPo.getBrandId().toString());
            }
            brandDealPo.setCreateOperId(reqBO.getUsername());
            brandDealPo.setCreateOperName(reqBO.getName());
            int result = this.mapper.addBrand(brandDealPo);
            if (result > 0) {
                this.rspBO.setRespCode("0000");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                this.rspBO.setBrandId(brandId);
            } else {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        try {
            UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
            uccSyncBrandToDGAtomReqBo.setBrandIds(Lists.newArrayList((Object[])new Long[]{brandId}));
            this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return this.rspBO;
    }

    public boolean judgeVersion(UccBrandAddReqBO reqBO) {
        Date expTime;
        if (CheckUtil.isBlank((String)reqBO.getBrandName())) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CheckUtil.isBlank((String)reqBO.getBelongOrg())) {
            this.rspBO.setRespDesc("\u65b0\u589e\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UccBrandVersionPO queryPo = new UccBrandVersionPO();
        queryPo.setBrandName(reqBO.getBrandName());
        queryPo.setBelongOrg(reqBO.getBelongOrg());
        List<UccBrandVersionPO> uccBrandVersionPOS = this.uccBrandVersionMapper.verifyBrandRepetition(queryPo);
        if (!ObjectUtils.isEmpty(uccBrandVersionPOS) && uccBrandVersionPOS.size() > 0) {
            this.rspBO.setRespDesc("\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u54c1\u724c\u540d\u79f0\u3001\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u7684\u6709\u6548\u54c1\u724c\u4e86\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = dateFormat.parse(reqBO.getExpTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (expTime.getTime() < new Date(System.currentTimeMillis()).getTime()) {
                this.rspBO.setRespDesc("\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                return false;
            }
        }
        if (reqBO.getBrandStatus() != null) {
            Map<String, String> map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime()) && !StringUtils.isEmpty((Object)reqBO.getEffTime())) {
            SimpleDateFormat str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        return true;
    }

    public boolean judge(UccBrandAddReqBO reqBO) {
        Date expTime;
        if (CheckUtil.isBlank((String)reqBO.getBrandName())) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CheckUtil.isBlank((String)reqBO.getBelongOrg())) {
            this.rspBO.setRespDesc("\u65b0\u589e\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UccMallBrandDetailInfoGroupListAbilityPO queryPo = new UccMallBrandDetailInfoGroupListAbilityPO();
        queryPo.setMallBrandName(reqBO.getBrandName());
        queryPo.setBelongOrg(reqBO.getBelongOrg());
        List<UccMallBrandDetailInfoGroupListAbilityPO> mallBrandDetailGroupListByParam = this.uccBrandExtMapper.getMallBrandDetailGroupListByParam(queryPo);
        if (mallBrandDetailGroupListByParam.size() > 0) {
            this.rspBO.setRespDesc("\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u54c1\u724c\u540d\u79f0\u3001\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u7684\u6709\u6548\u54c1\u724c\u4e86\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = dateFormat.parse(reqBO.getExpTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (expTime.getTime() < new Date(System.currentTimeMillis()).getTime()) {
                this.rspBO.setRespDesc("\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                return false;
            }
        }
        if (reqBO.getBrandStatus() != null) {
            Map<String, String> map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime()) && !StringUtils.isEmpty((Object)reqBO.getEffTime())) {
            SimpleDateFormat str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        return true;
    }

    public static void transStringToDate(UccBrandAddReqBO reqBO, UccBrandDealPO brandDealPo) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        try {
            Date effTime1 = DateUtils.strToDate(effTime);
            Date expTime1 = DateUtils.strToDate(expTime);
            brandDealPo.setEffTime(effTime1);
            brandDealPo.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public static void transStringToDate(UccBrandAddReqBO reqBO, UccBrandVersionPO brandDealPo) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        try {
            Date effTime1 = DateUtils.strToDate(effTime);
            Date expTime1 = DateUtils.strToDate(expTime);
            brandDealPo.setEffTime(effTime1);
            brandDealPo.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Autowired
    public void setMapper(UccBrandDealMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setUccBrandExtMapper(UccBrandExtMapper uccBrandExtMapper) {
        this.uccBrandExtMapper = uccBrandExtMapper;
    }

    @Autowired
    public void setUccDictionaryAtomService(UccBaseDictionaryAtomService uccDictionaryAtomService) {
        this.uccDictionaryAtomService = uccDictionaryAtomService;
    }
}

