/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.busi.api.updateBranNameService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class updateBranNameServiceImpl
implements updateBranNameService {
    private static final Logger log = LoggerFactory.getLogger(updateBranNameServiceImpl.class);
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public void updateBranName(UccBrandDealPO brandDealPO) {
        if (!ObjectUtils.isEmpty((Object)brandDealPO) && null != brandDealPO.getBrandId()) {
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(brandDealPO.getBrandId());
            List<UccMallBrandRelPO> brandList = this.uccMallBrandRelMapper.getBrandList(brandIds);
            List<Long> brandIdList = brandList.stream().map(UccMallBrandRelPO::getBrandId).collect(Collectors.toList());
            List<Long> skuIdList = this.uccSkuMapper.qeryByBrandIds(brandIdList);
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIdList);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
    }
}

