/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuPicBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuPriceBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuReqBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuRspBo;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuSpecBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccPushLogPO;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDataGovernPushSkuServiceImpl
implements UccDataGovernPushSkuService {
    private static final Logger log = LoggerFactory.getLogger(UccDataGovernPushSkuServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Value(value="${DATA_GOVERN_SKU_PUSH_URL:}")
    private String skuPushUrl;
    @Value(value="${DATA_GOVERN_SKU_PRICE_PUSH_URL:}")
    private String skuPricePushUrl;
    @Value(value="${DATA_GOVERN_SKU_PUSH_URL_2.0:}")
    private String newSkuPushUrl;
    @Value(value="${DATA_GOVERN_SKU_PRICE_PUSH_URL_2.0:}")
    private String newSkuPricePushUrl;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccPushLogMapper uccPushLogMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Value(value="${ucc.push.new.data:false}")
    private Boolean newData;

    @Override
    public UccDataGovernPushSkuRspBo dealDataGovernPushSku(UccDataGovernPushSkuReqBo reqBo) {
        List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
        UccDataGovernPushSkuRspBo rspBo = new UccDataGovernPushSkuRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBo.getSkuIds()) || reqBo.getType() == null) {
            return rspBo;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            return rspBo;
        }
        if (this.newData.booleanValue()) {
            rspBo = reqBo.getType() == 1 ? this.pushSku(reqBo, uccSkuPos) : this.pushSkuPrice(reqBo, uccSkuPos);
            if (reqBo.getType() == 1 && reqBo.isDownSkuFlag()) {
                Map<Long, List<UccSkuPo>> skuMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getSupplierShopId()));
                for (Map.Entry<Long, List<UccSkuPo>> each : skuMap.entrySet()) {
                    List<Long> skuIds = each.getValue().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                    this.updateSkuStatus(16, null, null, skuIds, each.getKey());
                }
            }
            return rspBo;
        }
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        Map<Object, Object> skuPirceMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            skuPirceMap = uccSkuPricePos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (first, second) -> first));
        }
        Map<Object, Object> materialMap = new HashMap();
        List<Long> materialIds = uccSkuPos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterialId())).map(a -> Long.valueOf(a.getMaterialId())).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds))) {
            materialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(a -> a.getMaterialId(), b -> b, (first, second) -> first));
        }
        List<Long> typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getListByType(typeIds);
        Map<Object, Object> catalogMap = new HashMap();
        Map<Object, Object> codeAndName = new HashMap();
        if (!CollectionUtils.isEmpty(uccEMdmCatalogPOS)) {
            catalogMap = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCommodityTypeId(), b -> b, (first, second) -> first));
            codeAndName = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCatalogCode(), b -> b.getCatalogName(), (first, second) -> first));
        }
        Map<Object, Object> skuSpecMap = new HashMap();
        List<UccSkuSpecPo> uccSkuSpecPos = this.uccSkuSpecMapper.qryBatchBySkus(reqBo.getSkuIds());
        if (!CollectionUtils.isEmpty(uccSkuSpecPos)) {
            skuSpecMap = uccSkuSpecPos.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
        }
        ArrayList<UccDataGovernPushSkuBo> skuBos = new ArrayList<UccDataGovernPushSkuBo>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccSkuPricePo uccSkuPricePo;
            UccEMdmCatalogPO uccEMdmCatalogPO;
            UccDataGovernPushSkuBo uccDataGovernPushSkuBo = new UccDataGovernPushSkuBo();
            BeanUtils.copyProperties((Object)uccSkuPo, (Object)uccDataGovernPushSkuBo);
            uccDataGovernPushSkuBo.setShopId(uccSkuPo.getSupplierShopId().toString());
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMaterialId())) {
                uccDataGovernPushSkuBo.setMaterialCode(((UccEMdmMaterialPO)materialMap.get(Long.valueOf(uccSkuPo.getMaterialId()))).getMaterialCode());
            }
            if ((uccEMdmCatalogPO = (UccEMdmCatalogPO)catalogMap.get(uccSkuPo.getCommodityTypeId())) != null) {
                uccDataGovernPushSkuBo.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
                uccDataGovernPushSkuBo.setCategoryName(uccEMdmCatalogPO.getCatalogName());
            }
            if ((uccSkuPricePo = (UccSkuPricePo)skuPirceMap.get(uccSkuPo.getSkuId())) != null) {
                uccDataGovernPushSkuBo.setSalesPrice(uccSkuPricePo.getSalePrice());
                uccDataGovernPushSkuBo.setMarketPrice(uccSkuPricePo.getMarketPrice());
                uccDataGovernPushSkuBo.setPrice(uccSkuPricePo.getAgreementPrice());
                if (uccSkuPricePo.getUpdateTime() != null) {
                    uccDataGovernPushSkuBo.setChangeTime(DateUtils.dateToStr(uccSkuPricePo.getUpdateTime()));
                }
            }
            ArrayList<UccDataGovernPushSkuSpecBo> specs = new ArrayList<UccDataGovernPushSkuSpecBo>();
            List skuSpecPos = (List)skuSpecMap.get(uccSkuPo.getSkuId());
            if (!CollectionUtils.isEmpty((Collection)skuSpecPos)) {
                ArrayList<String> propNames = new ArrayList<String>();
                for (UccSkuSpecPo skuSpecPo : skuSpecPos) {
                    UccDataGovernPushSkuSpecBo uccDataGovernPushSkuSpecBo = new UccDataGovernPushSkuSpecBo();
                    uccDataGovernPushSkuSpecBo.setPropName(skuSpecPo.getPropName());
                    uccDataGovernPushSkuSpecBo.setPropValue(skuSpecPo.getPropValue());
                    if (!propNames.contains(skuSpecPo.getPropName())) {
                        specs.add(uccDataGovernPushSkuSpecBo);
                    }
                    propNames.add(skuSpecPo.getPropName());
                }
            }
            uccDataGovernPushSkuBo.setSpecs(specs);
            skuBos.add(uccDataGovernPushSkuBo);
        }
        Map<String, List<UccDataGovernPushSkuBo>> reqData = skuBos.stream().collect(Collectors.groupingBy(a -> a.getCategoryCode()));
        String url = "";
        try {
            ArrayList<UccPushLogPO> uccPushLogPOS = new ArrayList<UccPushLogPO>();
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5165\u53c2\u65e5\u5fd7=====================" + reqBo);
            for (Map.Entry<String, List<UccDataGovernPushSkuBo>> entry : reqData.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("categoryCode", (Object)entry.getKey());
                jsonObject.put("categoryName", codeAndName.get(entry.getKey()));
                jsonObject.put("skuInfos", entry.getValue());
                JSONObject data = new JSONObject();
                data.put("data", (Object)jsonObject);
                data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                String reqStr = data.toJSONString();
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2\uff1a" + reqStr);
                UccPushLogPO uccPushLogPO = new UccPushLogPO();
                uccPushLogPO.setId(Sequence.getInstance().nextId());
                uccPushLogPO.setCreateTime(new Date());
                if (reqBo.getType() != null) {
                    if (reqBo.getType() == 1) {
                        url = this.skuPushUrl;
                        uccPushLogPO.setType(1);
                    } else {
                        url = this.skuPricePushUrl;
                        uccPushLogPO.setType(2);
                    }
                }
                uccPushLogPO.setReqJson(reqStr);
                try {
                    HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
                    if (httpRetBean.getStatus() != 200) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
                    }
                    String returnString = httpRetBean.getStr();
                    if (StringUtils.isEmpty((Object)returnString)) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                    }
                    JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                    if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                        uccPushLogPO.setStatus(0);
                    } else {
                        uccPushLogPO.setStatus(1);
                    }
                    uccPushLogPO.setRspJson(returnString);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    uccPushLogPO.setStatus(0);
                    uccPushLogPO.setRspJson(e.getMessage());
                }
                List skuIdList = entry.getValue().stream().filter(a -> !StringUtils.isEmpty(each.getValue())).map(UccDataGovernPushSkuBo::getSkuId).distinct().collect(Collectors.toList());
                uccPushLogPO.setSkuId(skuIdList.stream().map(Object::toString).collect(Collectors.joining(",")));
                if (reqBo.getNewType() != null && 2 == reqBo.getNewType()) {
                    uccPushLogPO.setNewType(2);
                } else {
                    uccPushLogPO.setNewType(1);
                }
                uccPushLogPOS.add(uccPushLogPO);
            }
            if (!CollectionUtils.isEmpty(uccPushLogPOS)) {
                this.uccPushLogMapper.insertBatch(uccPushLogPOS);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (reqBo.getType() == 1 && reqBo.isDownSkuFlag()) {
            Map<Long, List<UccSkuPo>> skuMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getSupplierShopId()));
            for (Map.Entry<Object, List<Serializable>> entry : skuMap.entrySet()) {
                List<Long> skuIds = entry.getValue().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                this.updateSkuStatus(16, null, null, skuIds, (Long)entry.getKey());
            }
        }
        return rspBo;
    }

    private UccDataGovernPushSkuRspBo pushSku(UccDataGovernPushSkuReqBo reqBo, List<UccSkuPo> uccSkuPos) {
        List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
        UccDataGovernPushSkuRspBo rspBo = new UccDataGovernPushSkuRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UccSkuPicPo picPo = new UccSkuPicPo();
        picPo.setSkuIds(reqBo.getSkuIds());
        List<UccSkuPicPo> skuImages = this.uccSkuPicMapper.qeurySkuPic(picPo);
        Map<Object, Object> skuImageMap = new HashMap();
        if (!CollectionUtils.isEmpty(skuImages)) {
            skuImageMap = skuImages.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        }
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        Map<Object, Object> skuPirceMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            skuPirceMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, b -> b, (first, second) -> first));
        }
        Map<Object, Object> materialMap = new HashMap();
        List<Long> materialIds = uccSkuPos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterialId())).map(a -> Long.valueOf(a.getMaterialId())).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds))) {
            materialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialId, b -> b, (first, second) -> first));
        }
        List<Long> typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getListByType(typeIds);
        Map<Object, Object> catalogMap = new HashMap();
        Map<Object, Object> codeAndName = new HashMap();
        if (!CollectionUtils.isEmpty(uccEMdmCatalogPOS)) {
            catalogMap = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCommodityTypeId, b -> b, (first, second) -> first));
            codeAndName = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, UccEMdmCatalogPO::getCatalogName, (first, second) -> first));
        }
        Map<Object, Object> skuSpecMap = new HashMap();
        List<UccSkuSpecPo> uccSkuSpecPos = this.uccSkuSpecMapper.qryBatchBySkus(reqBo.getSkuIds());
        if (!CollectionUtils.isEmpty(uccSkuSpecPos)) {
            skuSpecMap = uccSkuSpecPos.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
        }
        ArrayList<UccDataGovernPushSkuBo> skuBos = new ArrayList<UccDataGovernPushSkuBo>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccSkuPricePo uccSkuPricePo;
            UccEMdmCatalogPO uccEMdmCatalogPO;
            UccDataGovernPushSkuBo uccDataGovernPushSkuBo = new UccDataGovernPushSkuBo();
            BeanUtils.copyProperties((Object)uccSkuPo, (Object)uccDataGovernPushSkuBo);
            uccDataGovernPushSkuBo.setShopId(uccSkuPo.getSupplierShopId().toString());
            uccDataGovernPushSkuBo.setSkuStatus(String.valueOf(uccSkuPo.getSkuStatus()));
            uccDataGovernPushSkuBo.setSupplierShopId(uccSkuPo.getSupplierShopId().toString());
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMaterialId())) {
                uccDataGovernPushSkuBo.setMaterialCode(((UccEMdmMaterialPO)materialMap.get(Long.valueOf(uccSkuPo.getMaterialId()))).getMaterialCode());
            }
            if ((uccEMdmCatalogPO = (UccEMdmCatalogPO)catalogMap.get(uccSkuPo.getCommodityTypeId())) != null) {
                uccDataGovernPushSkuBo.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
                uccDataGovernPushSkuBo.setCategoryName(uccEMdmCatalogPO.getCatalogName());
            }
            if ((uccSkuPricePo = (UccSkuPricePo)skuPirceMap.get(uccSkuPo.getSkuId())) != null) {
                uccDataGovernPushSkuBo.setSalesPrice(uccSkuPricePo.getSalePrice());
                uccDataGovernPushSkuBo.setMarketPrice(uccSkuPricePo.getMarketPrice());
                uccDataGovernPushSkuBo.setPrice(uccSkuPricePo.getAgreementPrice());
                uccDataGovernPushSkuBo.setPurchasePrice(uccSkuPricePo.getAgreementPrice());
                uccDataGovernPushSkuBo.setOrderPrice(uccSkuPricePo.getSalePrice());
                uccDataGovernPushSkuBo.setStrikePrice(uccSkuPricePo.getSalePrice());
                if (uccSkuPricePo.getUpdateTime() != null) {
                    uccDataGovernPushSkuBo.setChangeTime(DateUtils.dateToStr(uccSkuPricePo.getUpdateTime()));
                }
            }
            ArrayList<UccDataGovernPushSkuSpecBo> specs = new ArrayList<UccDataGovernPushSkuSpecBo>();
            List skuSpecPos = (List)skuSpecMap.get(uccSkuPo.getSkuId());
            if (!CollectionUtils.isEmpty((Collection)skuSpecPos)) {
                ArrayList<String> propNames = new ArrayList<String>();
                for (UccSkuSpecPo skuSpecPo : skuSpecPos) {
                    UccDataGovernPushSkuSpecBo uccDataGovernPushSkuSpecBo = new UccDataGovernPushSkuSpecBo();
                    uccDataGovernPushSkuSpecBo.setPropName(skuSpecPo.getPropName());
                    uccDataGovernPushSkuSpecBo.setPropValue(skuSpecPo.getPropValue());
                    if (!propNames.contains(skuSpecPo.getPropName())) {
                        specs.add(uccDataGovernPushSkuSpecBo);
                    }
                    propNames.add(skuSpecPo.getPropName());
                }
            }
            uccDataGovernPushSkuBo.setSpecs(specs);
            ArrayList<UccDataGovernPushSkuPicBo> images = new ArrayList<UccDataGovernPushSkuPicBo>();
            List skuImage = (List)skuImageMap.get(uccSkuPo.getSkuId());
            if (!CollectionUtils.isEmpty((Collection)skuImage)) {
                for (UccSkuPicPo skuSpecPo : skuImage) {
                    UccDataGovernPushSkuPicBo uccDataGovernPushSkuSpecBo = new UccDataGovernPushSkuPicBo();
                    BeanUtils.copyProperties((Object)skuSpecPo, (Object)uccDataGovernPushSkuSpecBo);
                    images.add(uccDataGovernPushSkuSpecBo);
                }
                uccDataGovernPushSkuBo.setSkuImages(images);
            }
            skuBos.add(uccDataGovernPushSkuBo);
        }
        Map<String, List<UccDataGovernPushSkuBo>> reqData = skuBos.stream().collect(Collectors.groupingBy(a -> a.getCategoryCode()));
        try {
            ArrayList<UccPushLogPO> uccPushLogPOS = new ArrayList<UccPushLogPO>();
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5165\u53c2\u65e5\u5fd7=====================" + reqBo);
            for (Map.Entry<String, List<UccDataGovernPushSkuBo>> each : reqData.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("categoryCode", (Object)each.getKey());
                jsonObject.put("categoryName", codeAndName.get(each.getKey()));
                jsonObject.put("skuInfos", each.getValue());
                JSONObject data = new JSONObject();
                data.put("data", (Object)jsonObject);
                data.put("poolName", (Object)"\u4e2d\u7164\u5546\u54c1\u6c60");
                data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                String reqStr = data.toJSONString();
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2\uff1a" + reqStr);
                List<Long> skuIdList = each.getValue().stream().filter(a -> !StringUtils.isEmpty(each.getValue())).map(UccDataGovernPushSkuBo::getSkuId).distinct().collect(Collectors.toList());
                this.push(reqBo, reqStr, uccPushLogPOS, skuIdList);
            }
            if (!CollectionUtils.isEmpty(uccPushLogPOS)) {
                this.uccPushLogMapper.insertBatch(uccPushLogPOS);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rspBo;
    }

    private UccDataGovernPushSkuRspBo pushSkuPrice(UccDataGovernPushSkuReqBo reqBo, List<UccSkuPo> uccSkuPos) {
        UccDataGovernPushSkuRspBo rspBo = new UccDataGovernPushSkuRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        List<Long> typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getListByType(typeIds);
        HashMap<Long, UccEMdmCatalogPO> catalogMap = new HashMap();
        Map<Object, Object> codeAndName = new HashMap();
        if (!CollectionUtils.isEmpty(uccEMdmCatalogPOS)) {
            catalogMap = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCommodityTypeId, b -> b, (first, second) -> first));
            codeAndName = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, UccEMdmCatalogPO::getCatalogName, (first, second) -> first));
        }
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        Map<Object, Object> skuPirceMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            skuPirceMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, b -> b, (first, second) -> first));
        }
        ArrayList<UccDataGovernPushSkuPriceBO> skuBos = new ArrayList<UccDataGovernPushSkuPriceBO>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccSkuPricePo uccSkuPricePo = (UccSkuPricePo)skuPirceMap.get(uccSkuPo.getSkuId());
            skuBos.add(this.buildPrice(uccSkuPo, catalogMap, "market", uccSkuPricePo.getMarketPrice()));
            skuBos.add(this.buildPrice(uccSkuPo, catalogMap, "sales", uccSkuPricePo.getSalePrice()));
            skuBos.add(this.buildPrice(uccSkuPo, catalogMap, "strike", uccSkuPricePo.getSalePrice()));
            skuBos.add(this.buildPrice(uccSkuPo, catalogMap, "order", uccSkuPricePo.getSalePrice()));
            skuBos.add(this.buildPrice(uccSkuPo, catalogMap, "purchase", uccSkuPricePo.getAgreementPrice()));
        }
        Map<String, List<UccDataGovernPushSkuPriceBO>> reqData = skuBos.stream().collect(Collectors.groupingBy(UccDataGovernPushSkuPriceBO::getCategoryCode));
        try {
            ArrayList<UccPushLogPO> uccPushLogPOS = new ArrayList<UccPushLogPO>();
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5165\u53c2\u65e5\u5fd7=====================" + reqBo);
            for (Map.Entry<String, List<UccDataGovernPushSkuPriceBO>> each : reqData.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("categoryCode", (Object)each.getKey());
                jsonObject.put("categoryName", codeAndName.get(each.getKey()));
                jsonObject.put("skuPricelist", each.getValue());
                JSONObject data = new JSONObject();
                data.put("data", (Object)jsonObject);
                data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                data.put("poolName", (Object)"\u4e2d\u7164\u5546\u54c1\u6c60");
                String reqStr = data.toJSONString();
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2\uff1a" + reqStr);
                List<Long> skuIdList = each.getValue().stream().filter(a -> !StringUtils.isEmpty(each.getValue())).map(UccDataGovernPushSkuPriceBO::getSkuId).distinct().collect(Collectors.toList());
                this.push(reqBo, reqStr, uccPushLogPOS, skuIdList);
            }
            if (!CollectionUtils.isEmpty(uccPushLogPOS)) {
                this.uccPushLogMapper.insertBatch(uccPushLogPOS);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rspBo;
    }

    private UccDataGovernPushSkuPriceBO buildPrice(UccSkuPo uccSkuPo, Map<Long, UccEMdmCatalogPO> catalogMap, String key, Long price) {
        UccDataGovernPushSkuPriceBO priceBO = new UccDataGovernPushSkuPriceBO();
        priceBO.setSkuId(uccSkuPo.getSkuId());
        priceBO.setExtSkuId(uccSkuPo.getExtSkuId());
        priceBO.setChangeTime(com.ohaotian.plugin.common.util.DateUtils.dateToStrLong((Date)new Date()));
        UccEMdmCatalogPO uccEMdmCatalogPO = catalogMap.get(uccSkuPo.getCommodityTypeId());
        if (uccEMdmCatalogPO != null) {
            priceBO.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
            priceBO.setCategoryName(uccEMdmCatalogPO.getCatalogName());
        }
        priceBO.setPriceType(key);
        priceBO.setPriceValue(price);
        return priceBO;
    }

    private void push(UccDataGovernPushSkuReqBo reqBo, String reqStr, List<UccPushLogPO> uccPushLogPOS, List<Long> skuIdList) {
        UccPushLogPO uccPushLogPO = new UccPushLogPO();
        uccPushLogPO.setId(Sequence.getInstance().nextId());
        uccPushLogPO.setCreateTime(new Date());
        String url = "";
        if (reqBo.getType() != null) {
            if (reqBo.getType() == 1) {
                url = this.newSkuPushUrl;
                uccPushLogPO.setType(1);
            } else {
                url = this.newSkuPricePushUrl;
                uccPushLogPO.setType(2);
            }
        }
        uccPushLogPO.setReqJson(reqStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                uccPushLogPO.setStatus(0);
            } else {
                uccPushLogPO.setStatus(1);
            }
            uccPushLogPO.setRspJson(returnString);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            uccPushLogPO.setStatus(0);
            uccPushLogPO.setRspJson(e.getMessage());
        }
        uccPushLogPO.setSkuId(skuIdList.stream().map(Object::toString).collect(Collectors.joining(",")));
        if (reqBo.getNewType() != null && 2 == reqBo.getNewType()) {
            uccPushLogPO.setNewType(2);
        } else {
            uccPushLogPO.setNewType(1);
        }
        uccPushLogPOS.add(uccPushLogPO);
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

