/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.SkuSourceEnum;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccStandardComInfoMapper;
import com.tydic.commodity.dao.UccStandardComPropMapper;
import com.tydic.commodity.po.UccCatalogLevelPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccStandardComInfoForEsPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SyncSceneStandardCommodityToEsAtomServiceImpl
implements SyncSceneStandardCommodityToEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SyncSceneStandardCommodityToEsAtomServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccStandardComInfoMapper uccStandardComInfoMapper;
    @Autowired
    private UccStandardComPropMapper uccStandardComPropMapper;
    @Value(value="${standardSupplierId:888888}")
    private String standardSupplierId;
    @Value(value="#{'${standard.channelIds:10004}'.split(',')}")
    private String[] channelIds;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneStandardCommodityToEsReqBO syncReqBO) {
        if (UccConstants.StandardSyncEsType.add.equals(syncReqBO.getSyncType())) {
            this.addSyncToEs(syncReqBO);
        } else if (!UccConstants.StandardSyncEsType.update.equals(syncReqBO.getSyncType())) {
            if (UccConstants.StandardSyncEsType.delete.equals(syncReqBO.getSyncType())) {
                this.deleteCommodityInfoToEs(syncReqBO.getStandardIdLList());
            } else {
                log.error("\u672a\u77e5\u7684\u540c\u6b65\u7c7b\u578b" + JSON.toJSONString((Object)((Object)syncReqBO)));
            }
        }
        return null;
    }

    private void addSyncToEs(SyncSceneStandardCommodityToEsReqBO syncReqBO) {
        List<UccStandardComInfoForEsPO> standardComInfoPOList;
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        HashMap<Long, List<UccSkuPo>> skuMap = new HashMap<Long, List<UccSkuPo>>();
        if (!ObjectUtils.isEmpty((Object)syncReqBO.getSyncScene()) && (UccConstants.StandardSyncEsScene.Sku.equals(syncReqBO.getSyncScene()) || UccConstants.StandardSyncEsScene.Spu.equals(syncReqBO.getSyncScene()))) {
            List<Long> standardIds = this.uccStandardComInfoMapper.getStandardIdsBySku(syncReqBO.getSkuIds(), syncReqBO.getCommodityIds());
            if (CollectionUtils.isEmpty(standardIds)) {
                log.error("\u672a\u67e5\u8be2\u5230\u71ac\u6807\u54c1\u4fe1\u606f" + JSON.toJSONString((Object)((Object)syncReqBO)));
                return;
            }
            syncReqBO.setStandardIdLList(standardIds);
        }
        if (CollectionUtils.isEmpty(standardComInfoPOList = this.uccStandardComInfoMapper.getListBySync(syncReqBO.getStandardIdLList(), syncReqBO.getStandardCodeList(), syncReqBO.getStandardId(), syncReqBO.getStandardCode()))) {
            log.error("\u672a\u67e5\u8be2\u5230\u6807\u54c1\u4fe1\u606f!" + JSON.toJSONString((Object)((Object)syncReqBO)));
            return;
        }
        this.assemblyEsStandardInfos(standardComInfoPOList, skuMap, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(syncReqBO, esStorageSpuInfoBOS, standardComInfoPOList);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private void assemblyEsStandardInfos(List<UccStandardComInfoForEsPO> standardComInfoPOList, Map<Long, List<UccSkuPo>> skuMap, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<Long> standardIds = standardComInfoPOList.stream().map(UccStandardComInfoForEsPO::getStandardComId).collect(Collectors.toList());
        List<UccSkuPo> uccSkuPoList = this.uccStandardComInfoMapper.getSkuInfoByStandardIds(standardIds);
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            skuMap = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getStandardComId));
        }
        for (UccStandardComInfoForEsPO comInfoPO : standardComInfoPOList) {
            boolean hideFlag;
            List<Object> uccSkuPos = new ArrayList();
            if (skuMap.containsKey(comInfoPO.getStandardComId())) {
                uccSkuPos = skuMap.get(comInfoPO.getStandardComId());
            }
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            List<String> list = Arrays.asList(this.channelIds);
            esStorageSpuInfoBO.setChannel_id(list.stream().map(Long::parseLong).collect(Collectors.toList()));
            esStorageSpuInfoBO.setCommodity_id(comInfoPO.getStandardComId());
            esStorageSpuInfoBO.setSku_id(comInfoPO.getStandardComId());
            esStorageSpuInfoBO.setSku_source(SkuSourceEnum.SD_SKU_SOURCE.getSource());
            esStorageSpuInfoBO.setBrandName(comInfoPO.getBrandName());
            esStorageSpuInfoBO.setMeasure(comInfoPO.getMeasureName());
            esStorageSpuInfoBO.setMeasure_name(comInfoPO.getMeasureName());
            esStorageSpuInfoBO.setBrand_name(comInfoPO.getBrandName());
            esStorageSpuInfoBO.setMaterial_name(comInfoPO.getMaterialName());
            esStorageSpuInfoBO.setMaterial_code(comInfoPO.getMaterialCode());
            esStorageSpuInfoBO.setL4mg_category_name(comInfoPO.getCatalogName());
            esStorageSpuInfoBO.setL4mg_category_id(comInfoPO.getCatalogId());
            esStorageSpuInfoBO.setSku_name(comInfoPO.getStandardComName());
            esStorageSpuInfoBO.setSku_code(comInfoPO.getStandardComCode());
            esStorageSpuInfoBO.setExt_standard_com_id(comInfoPO.getExtStandardComId());
            esStorageSpuInfoBO.setStandard_com_name(comInfoPO.getStandardComName());
            esStorageSpuInfoBO.setStandard_com_code(comInfoPO.getStandardComCode());
            esStorageSpuInfoBO.setHide(UccConstants.Hide.yes);
            esStorageSpuInfoBO.setSku_status(UccConstants.StandardStatus.OFF_SHELVE_STATE);
            esStorageSpuInfoBO.setSold_number(0L);
            esStorageSpuInfoBO.setSale_price(new Double(1.0));
            esStorageSpuInfoBO.setDiscounts(new Double(1.0));
            esStorageSpuInfoBO.setSalePrice(new BigDecimal(0));
            esStorageSpuInfoBO.setMarket_price(new Double(0.0));
            esStorageSpuInfoBO.setAgreement_price(new Double(0.0));
            if (!CollectionUtils.isEmpty(uccSkuPos)) {
                esStorageSpuInfoBO.setSupplier_id(((UccSkuPo)uccSkuPos.get(0)).getSupplierShopId());
                esStorageSpuInfoBO.setShop_name(((UccSkuPo)uccSkuPos.get(0)).getShopName());
            }
            if (!CollectionUtils.isEmpty(uccSkuPos) && !(hideFlag = uccSkuPos.stream().allMatch(e -> Objects.equals(e.getHide(), UccConstants.Hide.yes)))) {
                esStorageSpuInfoBO.setHide(UccConstants.Hide.no);
                List collect = uccSkuPos.stream().filter(e -> Objects.equals(e.getSkuStatus(), UccConstants.StandardStatus.ON_SHELVE_STATE)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    esStorageSpuInfoBO.setSku_status(UccConstants.StandardStatus.ON_SHELVE_STATE);
                }
            }
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = esStorageSpuInfoBO.getScene_id() == null ? String.valueOf(esStorageSpuInfoBO.getSku_id()) : esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            String SceneId = Objects.nonNull(esStorageSpuInfoBO.getScene_id()) ? esStorageSpuInfoBO.getScene_id() + "" : "";
            log.error("\u5546\u54c1\u4fe1\u606f[" + SceneId + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void updateCommodityInfoToEs(List<EsStorageSpuInfoBO> updateInfos) {
        try {
            for (EsStorageSpuInfoBO updateInfo : updateInfos) {
                JSONObject object = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)updateInfo), JSONObject.class);
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), updateInfo.getSku_id().toString(), object);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void deleteCommodityInfoToEs(List<Long> deleteIds) {
        for (Long each : deleteIds) {
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("sku_id", (Object)String.valueOf(each));
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("term", (Object)delConditionOrderJson);
            JSONObject termAfsJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (deleteResult.booleanValue()) continue;
            log.error("\u5355\u54c1\u4fe1\u606f[" + each + "]\u5220\u9664\u5931\u8d25!");
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneStandardCommodityToEsReqBO reqBO, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<UccStandardComInfoForEsPO> commodityForEsBOS) {
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (UccStandardComInfoForEsPO each : commodityForEsBOS) {
            if (ObjectUtils.isEmpty((Object)each.getGuideCatalogId())) continue;
            guiCataLog.add(each.getGuideCatalogId());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<Object> catalogLevelPos = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(guiCataLog)) {
            catalogLevelPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (CollectionUtils.isEmpty(catalogLevelPos) || CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_id())) continue;
            for (UccCatalogLevelPo uccCatalogLevelPo : catalogLevelPos) {
                for (String l3_category_id : esStorageSpuInfoBO.getL3_category_id()) {
                    if (!uccCatalogLevelPo.getL3GuideCatalogId().equals(Long.valueOf(l3_category_id))) continue;
                    if (uccCatalogLevelPo.getL1GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_id())) {
                            esStorageSpuInfoBO.setL1_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1GuideCatalogId().toString()}));
                        } else if (!esStorageSpuInfoBO.getL1_category_id().contains(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()))) {
                            esStorageSpuInfoBO.getL1_category_id().add(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()));
                        }
                    }
                    if (uccCatalogLevelPo.getL2GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_id())) {
                            esStorageSpuInfoBO.setL2_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2GuideCatalogId().toString()}));
                        } else if (!esStorageSpuInfoBO.getL2_category_id().contains(String.valueOf(uccCatalogLevelPo.getL2GuideCatalogId()))) {
                            esStorageSpuInfoBO.getL2_category_id().add(uccCatalogLevelPo.getL2GuideCatalogId().toString());
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL1CatalogName())) {
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_name())) {
                            esStorageSpuInfoBO.setL1_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1CatalogName()}));
                        } else if (!esStorageSpuInfoBO.getL1_category_name().contains(uccCatalogLevelPo.getL1CatalogName())) {
                            esStorageSpuInfoBO.getL1_category_name().add(uccCatalogLevelPo.getL1CatalogName());
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL2CatalogName())) {
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_name())) {
                            esStorageSpuInfoBO.setL2_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2CatalogName()}));
                        } else if (!esStorageSpuInfoBO.getL2_category_name().contains(uccCatalogLevelPo.getL2CatalogName())) {
                            esStorageSpuInfoBO.getL2_category_name().add(uccCatalogLevelPo.getL2CatalogName());
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL3CatalogName())) {
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_name())) {
                            esStorageSpuInfoBO.setL3_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL3CatalogName()}));
                        } else if (!esStorageSpuInfoBO.getL3_category_name().contains(uccCatalogLevelPo.getL3CatalogName())) {
                            esStorageSpuInfoBO.getL3_category_name().add(uccCatalogLevelPo.getL3CatalogName());
                        }
                    }
                    if (uccCatalogLevelPo.getChannelId() == null) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                        esStorageSpuInfoBO.setChannel_id(Lists.newArrayList((Object[])new Long[]{uccCatalogLevelPo.getChannelId()}));
                        esStorageSpuInfoBO.setChannel_Name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getChannelName()}));
                        continue;
                    }
                    if (!esStorageSpuInfoBO.getChannel_id().contains(uccCatalogLevelPo.getChannelId())) {
                        esStorageSpuInfoBO.getChannel_id().add(uccCatalogLevelPo.getChannelId());
                    }
                    if (esStorageSpuInfoBO.getChannel_Name().contains(uccCatalogLevelPo.getChannelName())) continue;
                    esStorageSpuInfoBO.getChannel_Name().add(uccCatalogLevelPo.getChannelName());
                }
            }
        }
    }
}

