/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccBrandSyncEgBo;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomRspBo;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccPushLogPO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSyncBrandToDGAtomServiceImpl
implements UccSyncBrandToDGAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncBrandToDGAtomServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Value(value="${SYNC_BRAND_TO_DG_URL:http://172.16.11.134:8097/iioproxy/iio/dataExchange/commodity/brandApply/1}")
    private String syncBrandToDgUrl;
    @Autowired
    private UccPushLogMapper uccPushLogMapper;

    @Override
    public UccSyncBrandToDGAtomRspBo dealSyncBrandToDG(UccSyncBrandToDGAtomReqBo reqBo) {
        UccSyncBrandToDGAtomRspBo rspBo = new UccSyncBrandToDGAtomRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBo.getBrandIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5546\u57ce\u54c1\u724cID");
            return rspBo;
        }
        List<UccBrandDealPO> uccBrandDealPOS = this.uccBrandDealMapper.getBrandSyncDGInfo(reqBo.getBrandIds());
        if (!CollectionUtils.isEmpty(uccBrandDealPOS)) {
            ArrayList brands = new ArrayList();
            Map<Long, List<UccBrandDealPO>> brandMap = uccBrandDealPOS.stream().collect(Collectors.groupingBy(a -> a.getBrandId()));
            brandMap.forEach((key, value) -> {
                UccBrandSyncEgBo uccBrandSyncEgAbility = new UccBrandSyncEgBo();
                uccBrandSyncEgAbility.setBrandId(((UccBrandDealPO)value.get(0)).getBrandCode());
                uccBrandSyncEgAbility.setBrandName(((UccBrandDealPO)value.get(0)).getBrandName());
                uccBrandSyncEgAbility.setLogoPath(((UccBrandDealPO)value.get(0)).getBrandLogo());
                uccBrandSyncEgAbility.setProviderInfo(((UccBrandDealPO)value.get(0)).getBelongOrg());
                uccBrandSyncEgAbility.setIsValid(((UccBrandDealPO)value.get(0)).getBrandStatus() != null && ((UccBrandDealPO)value.get(0)).getBrandStatus() == 1 ? "1" : "0");
                List extBrandNames = value.stream().filter(a -> !StringUtils.isEmpty((Object)a.getExtBrandName())).map(a -> a.getExtBrandName()).distinct().collect(Collectors.toList());
                uccBrandSyncEgAbility.setBrandNameExt(String.join((CharSequence)",", extBrandNames));
                brands.add(uccBrandSyncEgAbility);
            });
            if (!CollectionUtils.isEmpty(brands)) {
                UccPushLogPO uccPushLogPO = new UccPushLogPO();
                uccPushLogPO.setId(Sequence.getInstance().nextId());
                uccPushLogPO.setCreateTime(new Date());
                uccPushLogPO.setType(3);
                try {
                    JSONObject brandsJson = new JSONObject();
                    brandsJson.put("brands", brands);
                    JSONObject data = new JSONObject();
                    data.put("data", (Object)brandsJson);
                    data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                    String reqStr = JSONObject.toJSONString((Object)data);
                    log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2\uff1a" + reqStr);
                    uccPushLogPO.setReqJson(reqStr);
                    HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.syncBrandToDgUrl), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
                    if (httpRetBean.getStatus() != 200) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
                    }
                    String returnString = httpRetBean.getStr();
                    if (StringUtils.isEmpty((Object)returnString)) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                    }
                    JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                    if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                        uccPushLogPO.setStatus(0);
                    } else {
                        uccPushLogPO.setStatus(1);
                    }
                    uccPushLogPO.setRspJson(returnString);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    uccPushLogPO.setStatus(0);
                    uccPushLogPO.setRspJson(e.getMessage());
                }
                List brandList = brands.stream().filter(a -> !StringUtils.isEmpty((Object)brands)).map(UccBrandSyncEgBo::getBrandId).distinct().collect(Collectors.toList());
                uccPushLogPO.setBrandId(String.join((CharSequence)",", brandList));
                uccPushLogPO.setNewType(1);
                this.uccPushLogMapper.insert(uccPushLogPO);
            }
        }
        return rspBo;
    }
}

