/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.busibase.atom.api.CommodityDealWaitParamsAtomService;
import com.tydic.commodity.busibase.atom.bo.UccWaitDoneOtherInfoAtomBo;
import com.tydic.commodity.common.ability.api.UccSpuDetailSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoWaitAbilityReqBO;
import com.tydic.todo.ability.api.TodoAuditWaitDoneQueryConfigInfoAbilityService;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoReqBo;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoRspBo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CommodityDealWaitParamsAtomServiceImpl
implements CommodityDealWaitParamsAtomService {
    private static final Logger log = LoggerFactory.getLogger(CommodityDealWaitParamsAtomServiceImpl.class);
    public static final Integer REJECT_CODE = 1;
    public static final String REJECT_DESCRIPTION = "\u5ba1\u6279\u9a73\u56de";
    public static final String AGREE_CODE = "1";
    public static final String AGREE_DESCRIPTION = "\u5ba1\u6279\u901a\u8fc7";
    @Autowired
    private TodoAuditWaitDoneQueryConfigInfoAbilityService queryConfigInfoAbilityService;
    @Autowired
    private UccSpuDetailSkuListQryAbilityService uccSpuDetailSkuListQryAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public void uccDealTodoAddWaitParams(TodoWaitAbilityReqBO todoAddWait) {
        log.error("\u5f00\u59cb\u5904\u7406\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoAddWait));
        if (StringUtils.isEmpty((Object)todoAddWait.getBusiCode()) || CollectionUtils.isEmpty(todoAddWait.getWaitDoneList()) || todoAddWait.getWaitDoneList().get(0).getObjId() == null) {
            return;
        }
        for (TodoAddWaitDoneAbilityReqBO waitDoneAbility : todoAddWait.getWaitDoneList()) {
            log.error("\u5f53\u524d\u5f97\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneAbility));
            TodoAuditWaitDoneQueryConfigInfoReqBo queryConfigInfoReqBo = new TodoAuditWaitDoneQueryConfigInfoReqBo();
            queryConfigInfoReqBo.setBusiCode(todoAddWait.getBusiCode());
            queryConfigInfoReqBo.setCenter(todoAddWait.getCenterCode());
            log.error("\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)queryConfigInfoReqBo));
            TodoAuditWaitDoneQueryConfigInfoRspBo configInfo = this.queryConfigInfoAbilityService.queryAuditConfigInfo(queryConfigInfoReqBo);
            log.error("\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)configInfo));
            if (!"0000".equals(configInfo.getRespCode())) {
                log.error("\u672a\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f");
                return;
            }
            waitDoneAbility.setAuditUrl(configInfo.getAuditUrl());
            waitDoneAbility.setTitle(configInfo.getAuditMenuName() + "-" + waitDoneAbility.getObjNo());
            waitDoneAbility.setAuditLogUrl(configInfo.getAuditLogUrl());
            String busiCode = todoAddWait.getBusiCode();
            if ("2001".equals(busiCode)) {
                this.dealElectronicCommodityOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2002".equals(busiCode)) {
                this.dealElectronicCommodityOffSale(waitDoneAbility);
                continue;
            }
            if (!"2003".equals(busiCode)) continue;
            this.dealElectronicCommodityRecoverOnSale(waitDoneAbility);
        }
    }

    private void dealElectronicCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility) {
    }

    private void dealElectronicCommodityOffSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility) {
    }

    private void dealElectronicCommodityOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("dealResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        requestMapReject.put("rejectWay", 1);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode;
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }
}

