/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.busibase.atom.api.CommodityDealWaitParamsAtomService;
import com.tydic.commodity.busibase.atom.bo.UccWaitDoneOtherInfoAtomBo;
import com.tydic.commodity.common.ability.api.UccSkuManagementAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuDetailSkuListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuEditDetailSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuItemInfoBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuDetailSkuListQryBO;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoWaitAbilityReqBO;
import com.tydic.todo.ability.api.TodoAuditWaitDoneQueryConfigInfoAbilityService;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoReqBo;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoRspBo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CommodityDealWaitParamsAtomServiceImpl
implements CommodityDealWaitParamsAtomService {
    private static final Logger log = LoggerFactory.getLogger(CommodityDealWaitParamsAtomServiceImpl.class);
    public static final Integer REJECT_CODE = 1;
    public static final String REJECT_DESCRIPTION = "\u5ba1\u6279\u9a73\u56de";
    public static final Integer AGREE_CODE = 0;
    public static final String AGREE_DESCRIPTION = "\u5ba1\u6279\u901a\u8fc7";
    @Autowired
    private TodoAuditWaitDoneQueryConfigInfoAbilityService queryConfigInfoAbilityService;
    @Autowired
    private UccSpuDetailSkuListQryAbilityService uccSpuDetailSkuListQryAbilityService;
    @Autowired
    private UccSpuEditDetailSkuListQryAbilityService uccSpuEditDetailSkuListQryAbilityService;
    @Autowired
    private UccSkuManagementAbilityService uccSkuManagementAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;

    @Override
    public void uccDealTodoAddWaitParams(TodoWaitAbilityReqBO todoAddWait) {
        log.error("\u5f00\u59cb\u5904\u7406\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoAddWait));
        if (StringUtils.isEmpty((Object)todoAddWait.getBusiCode()) || CollectionUtils.isEmpty(todoAddWait.getWaitDoneList()) || todoAddWait.getWaitDoneList().get(0).getObjId() == null) {
            return;
        }
        for (TodoAddWaitDoneAbilityReqBO waitDoneAbility : todoAddWait.getWaitDoneList()) {
            log.error("\u5f53\u524d\u5f97\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneAbility));
            TodoAuditWaitDoneQueryConfigInfoReqBo queryConfigInfoReqBo = new TodoAuditWaitDoneQueryConfigInfoReqBo();
            queryConfigInfoReqBo.setBusiCode(todoAddWait.getBusiCode());
            queryConfigInfoReqBo.setCenter(todoAddWait.getCenterCode());
            log.error("\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)queryConfigInfoReqBo));
            TodoAuditWaitDoneQueryConfigInfoRspBo configInfo = this.queryConfigInfoAbilityService.queryAuditConfigInfo(queryConfigInfoReqBo);
            log.error("\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)configInfo));
            if (!"0000".equals(configInfo.getRespCode())) {
                log.error("\u672a\u67e5\u8be2\u5230\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4fe1\u606f");
                return;
            }
            waitDoneAbility.setAuditUrl(configInfo.getAuditUrl());
            waitDoneAbility.setTitle(configInfo.getAuditMenuName() + "-" + waitDoneAbility.getObjNo());
            waitDoneAbility.setAuditLogUrl(configInfo.getAuditLogUrl());
            String busiCode = todoAddWait.getBusiCode();
            if ("2001".equals(busiCode)) {
                this.dealElectronicCommodityOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2002".equals(busiCode)) {
                this.dealElectronicCommodityOffSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2003".equals(busiCode)) {
                this.dealElectronicCommodityRecoverOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2004".equals(busiCode)) {
                this.dealAgreementCommodityCompile(waitDoneAbility, configInfo);
                continue;
            }
            if ("2005".equals(busiCode)) {
                this.dealAgreementCommodityListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2006".equals(busiCode)) {
                this.dealAgreementCommodityDelist(waitDoneAbility, configInfo);
                continue;
            }
            if ("2007".equals(busiCode)) {
                this.dealAgreementCommodityRecoverOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2008".equals(busiCode)) {
                this.dealNoAgreementCommodityCompile(waitDoneAbility, configInfo);
                continue;
            }
            if ("2009".equals(busiCode)) {
                this.dealNoAgreementCommodityListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2010".equals(busiCode)) {
                this.dealNoAgreementCommodityDelist(waitDoneAbility, configInfo);
                continue;
            }
            if ("2011".equals(busiCode)) {
                this.dealNoAgreementCommodityRecoverOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2012".equals(busiCode)) {
                this.dealApplyForListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2013".equals(busiCode)) {
                this.dealEmployeeSupCommodityCompile(waitDoneAbility, configInfo);
                continue;
            }
            if ("2014".equals(busiCode)) {
                this.dealEmployeeSupCommodityListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2015".equals(busiCode)) {
                this.dealEmployeeSupCommodityDelist(waitDoneAbility, configInfo);
                continue;
            }
            if ("2016".equals(busiCode)) {
                this.dealEmployeeSupCommodityRecoverOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if ("2017".equals(busiCode)) {
                this.dealBrandListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2018".equals(busiCode)) {
                this.dealDirectCommodityListing(waitDoneAbility, configInfo);
                continue;
            }
            if ("2019".equals(busiCode)) {
                this.dealDirectCommodityRecoverOnSale(waitDoneAbility, configInfo);
                continue;
            }
            if (!"2020".equals(busiCode)) continue;
            this.dealApplyForBrand(waitDoneAbility, configInfo);
        }
    }

    private void dealApplyForBrand(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditType", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        requestMapAgree.put("type", 1);
        ArrayList<String> idListAgree = new ArrayList<String>();
        idListAgree.add(waitDoneAbility.getObjId());
        requestMapAgree.put("ids", idListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditType", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        requestMapReject.put("type", 1);
        ArrayList<String> idListReject = new ArrayList<String>();
        idListReject.add(waitDoneAbility.getObjId());
        requestMapReject.put("ids", idListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        String auditAlreadyCondition = "?id=" + waitDoneAbility.getObjId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
        String auditWaitUrl = configInfo.getAuditWaitUrl();
        String auditWaitCondition = "?pageType=1&type=1&id=" + waitDoneAbility.getObjId();
        log.error("\u5f85\u529e\u5904\u7406\u8be6\u60c5\u9875\u9762PC\u5730\u5740\uff1a{}", (Object)(auditWaitUrl + auditWaitCondition));
        waitDoneAbility.setAuditWaitUrl(auditWaitUrl + auditWaitCondition);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("applyId", waitDoneAbility.getObjId());
        requestMap.put("center", "ucc");
        requestMap.put("pageNo", 1);
        requestMap.put("pageSize", 999);
        log.error("\u5ba1\u6279\u8bb0\u5f55\u8df3\u8f6c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(requestMap));
        waitDoneAbility.setAuditLogParma(JSON.toJSONString(requestMap));
    }

    private void dealDirectCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("dealResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=51&isArg=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealDirectCommodityListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        requestMapReject.put("rejectWay", 1);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=4&isArg=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealBrandListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditType", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList<String> idListAgree = new ArrayList<String>();
        idListAgree.add(waitDoneAbility.getObjId());
        requestMapAgree.put("ids", idListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditType", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList<String> idListReject = new ArrayList<String>();
        idListReject.add(waitDoneAbility.getObjId());
        requestMapReject.put("ids", idListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        String auditAlreadyCondition = "?type=2&auditResult=2&id=" + waitDoneAbility.getObjId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
        String auditWaitUrl = configInfo.getAuditWaitUrl();
        String auditWaitCondition = "?type=1&auditResult=2&id=" + waitDoneAbility.getObjId();
        log.error("\u5f85\u529e\u5904\u7406\u8be6\u60c5\u9875\u9762PC\u5730\u5740\uff1a{}", (Object)(auditWaitUrl + auditWaitCondition));
        waitDoneAbility.setAuditWaitUrl(auditWaitUrl + auditWaitCondition);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("applyId", waitDoneAbility.getObjId());
        requestMap.put("center", "SSC");
        requestMap.put("pageNo", 1);
        requestMap.put("pageSize", 999);
        log.error("\u5ba1\u6279\u8bb0\u5f55\u8df3\u8f6c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(requestMap));
        waitDoneAbility.setAuditLogParma(JSON.toJSONString(requestMap));
    }

    private void dealEmployeeSupCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSpuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=8&objType=5&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealEmployeeSupCommodityDelist(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSpuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=6&objType=4&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealEmployeeSupCommodityListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO qryAbilityRspBO = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)qryAbilityRspBO));
        if (!"0000".equals(qryAbilityRspBO.getRespCode()) || qryAbilityRspBO.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = qryAbilityRspBO.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=4&objType=3&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealEmployeeSupCommodityCompile(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO abilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        abilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO listQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)listQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=2&isArg=true&isEditDetail=false";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealApplyForListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.applyShelvesFormMapper.getOtherInfoByApplyId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getApplyId() == null || StringUtils.isEmpty((Object)waitDoneOtherInfoAtomBo.getApplyCode())) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditType", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList<Long> applyIdsAgree = new ArrayList<Long>();
        applyIdsAgree.add(waitDoneOtherInfoAtomBo.getApplyId());
        requestMapAgree.put("applyIds", applyIdsAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditType", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList<Long> applyIdsReject = new ArrayList<Long>();
        applyIdsReject.add(waitDoneOtherInfoAtomBo.getApplyId());
        requestMapReject.put("applyIds", applyIdsReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        String auditAlreadyCondition = "?applyId=" + waitDoneOtherInfoAtomBo.getApplyId() + "&applyCode=" + waitDoneOtherInfoAtomBo.getApplyCode() + "&type=1&isDetail=2";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
        HashMap<String, Number> requestMap = new HashMap<String, Number>();
        requestMap.put("applyId", waitDoneOtherInfoAtomBo.getApplyId());
        requestMap.put("objType", 10);
        requestMap.put("pageNo", 1);
        requestMap.put("pageSize", 10);
        log.error("\u5ba1\u6279\u8bb0\u5f55\u8df3\u8f6c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(requestMap));
        waitDoneAbility.setAuditLogParma(JSON.toJSONString(requestMap));
    }

    private void dealNoAgreementCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSpuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=8&objType=5&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealNoAgreementCommodityDelist(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSpuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=6&objType=4&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealNoAgreementCommodityListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO qryAbilityRspBO = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)qryAbilityRspBO));
        if (!"0000".equals(qryAbilityRspBO.getRespCode()) || qryAbilityRspBO.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = qryAbilityRspBO.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=21&objType=0&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealNoAgreementCommodityCompile(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO abilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        abilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO listQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)listQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=31&isArg=true&isEditDetail=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealAgreementCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("dealResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=41&objType=4&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealAgreementCommodityDelist(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO skuItem = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)skuItem), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=41&objType=4&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealAgreementCommodityListing(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSkuManagementAbilityReqBO abilityReqBO = new UccSkuManagementAbilityReqBO();
        abilityReqBO.setSkuId(Long.valueOf(waitDoneAbility.getObjId()));
        abilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSkuManagementAbilityRspBO detailSkuList = this.uccSkuManagementAbilityService.getSkuManagement(abilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || detailSkuList.getSkuItem() != null) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSkuItemInfoBO listQryBO = detailSkuList.getSkuItem();
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)listQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?skuId=" + waitDoneAbility.getObjId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&isArg=true&row=" + encode + "&tabKey=21&objType=3&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId();
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealAgreementCommodityCompile(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=31&isArg=true&isEditDetail=false";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealElectronicCommodityRecoverOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("dealResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=8&isArg=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealElectronicCommodityOffSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("dealResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=6&isArg=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }

    private void dealElectronicCommodityOnSale(TodoAddWaitDoneAbilityReqBO waitDoneAbility, TodoAuditWaitDoneQueryConfigInfoRspBo configInfo) {
        UccWaitDoneOtherInfoAtomBo waitDoneOtherInfoAtomBo = this.uccSkuMapper.getSupplierShopIdBySkuId(waitDoneAbility.getObjId());
        log.error("\u67e5\u8be2\u5230\u5546\u54c1\u5176\u4ed6\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneOtherInfoAtomBo));
        log.error("\u5f53\u524d\u7684objId\u4e3a\uff1a{}", (Object)waitDoneAbility.getObjId());
        if (waitDoneOtherInfoAtomBo == null || waitDoneOtherInfoAtomBo.getSupplierShopId() == null || waitDoneOtherInfoAtomBo.getCommodityId() == null) {
            return;
        }
        HashMap<String, Object> requestMapAgree = new HashMap<String, Object>();
        requestMapAgree.put("auditResult", AGREE_CODE);
        requestMapAgree.put("auditAdvice", AGREE_DESCRIPTION);
        ArrayList batchSkuListAgree = new ArrayList();
        HashMap<String, String> batchSkuMapAgree = new HashMap<String, String>();
        batchSkuMapAgree.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapAgree.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListAgree.add(batchSkuMapAgree);
        requestMapAgree.put("batchSkuList", batchSkuListAgree);
        log.error("\u5ba1\u6279\u62d2\u7edd\u901a\u4e49\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapAgree));
        waitDoneAbility.setAuditPassParma(JSON.toJSONString(requestMapAgree));
        HashMap<String, Object> requestMapReject = new HashMap<String, Object>();
        requestMapReject.put("auditResult", REJECT_CODE);
        requestMapReject.put("auditAdvice", REJECT_DESCRIPTION);
        requestMapReject.put("rejectWay", 1);
        ArrayList batchSkuListReject = new ArrayList();
        HashMap<String, String> batchSkuMapReject = new HashMap<String, String>();
        batchSkuMapReject.put("skuId", waitDoneAbility.getObjId());
        batchSkuMapReject.put("supplierShopId", waitDoneOtherInfoAtomBo.getSupplierShopId() + "");
        batchSkuListReject.add(batchSkuMapReject);
        requestMapReject.put("batchSkuList", batchSkuListReject);
        log.error("\u5ba1\u6279\u62d2\u7edd\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(requestMapReject));
        waitDoneAbility.setAuditRejectParma(JSON.toJSONString(requestMapReject));
        String auditAlreadyUrl = configInfo.getAuditAlreadyUrl();
        UccSpuDetailSkuListQryAbilityReqBO uccSpuDetailSkuListQryAbilityReqBO = new UccSpuDetailSkuListQryAbilityReqBO();
        uccSpuDetailSkuListQryAbilityReqBO.setCommodityId(waitDoneOtherInfoAtomBo.getCommodityId());
        uccSpuDetailSkuListQryAbilityReqBO.setSupplierShopId(waitDoneOtherInfoAtomBo.getSupplierShopId());
        UccSpuDetailSkuListQryAbilityRspBO detailSkuList = this.uccSpuDetailSkuListQryAbilityService.getSpuDetailSkuList(uccSpuDetailSkuListQryAbilityReqBO);
        log.error("\u67e5\u8be2\u7684\u9700\u7ec4\u88c5\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailSkuList));
        if (!"0000".equals(detailSkuList.getRespCode()) || CollectionUtils.isEmpty((Collection)detailSkuList.getRows())) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e2d\u5fc3\u5546\u54c1\u8be6\u60c5\u5355\u54c1\u5217\u8868\u5931\u8d25");
            return;
        }
        UccSpuDetailSkuListQryBO uccSpuDetailSkuListQryBO = (UccSpuDetailSkuListQryBO)detailSkuList.getRows().get(0);
        String encode = null;
        try {
            encode = URLEncoder.encode(JSON.toJSONString((Object)uccSpuDetailSkuListQryBO), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("JSON\u8f6cencodeURI\u5931\u8d25");
        }
        String auditAlreadyCondition = "?from=ecCommodityApprovalList&commodityId=" + waitDoneOtherInfoAtomBo.getCommodityId() + "&supplierShopId=" + waitDoneOtherInfoAtomBo.getSupplierShopId() + "&row=" + encode + "&tabKey=4&isArg=true";
        log.error("\u5df2\u529ePC\u8be6\u60c5\u9875\u9762\u5730\u5740\uff1a{}", (Object)(auditAlreadyUrl + auditAlreadyCondition));
        waitDoneAbility.setAuditAlreadyUrl(auditAlreadyUrl + auditAlreadyCondition);
    }
}

