/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.tydic.commodity.base.constant.ApproveEntrustConstant;
import com.tydic.commodity.base.enumType.SkuSourceEnum;
import com.tydic.commodity.busibase.atom.api.UccConvertNoticeUrlAtomService;
import com.tydic.commodity.busibase.atom.bo.UccConvertNoticeUrlAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccConvertNoticeUrlAtomRspBO;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.dao.UccBrandVersionMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ApplyShelvesFormPO;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import com.tydic.commodity.po.UccBrandVersionPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccConvertNoticeUrlAtomServiceImpl
implements UccConvertNoticeUrlAtomService {
    @Value(value="${APPROVE_ENTRUST_NOTICE_JUMP_URL_IP:http://172.20.175.3}")
    private String approveEntrustNoticeJumpUrlIp;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private UccBrandVersionMapper uccBrandVersionMapper;
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;

    @Override
    public UccConvertNoticeUrlAtomRspBO convertNoticeUrl(UccConvertNoticeUrlAtomReqBO reqBO) {
        UccConvertNoticeUrlAtomRspBO rspBO = new UccConvertNoticeUrlAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        HashMap<Long, String> objIdMap = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(reqBO.getObjIds()) && reqBO.getObjType() != null) {
            if (ApproveEntrustConstant.ApproveEntrustType.SKU.equals(reqBO.getObjType())) {
                Object commodityPos;
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getObjIds());
                if (CollectionUtils.isEmpty(uccSkuPos)) {
                    return rspBO;
                }
                Set commodityIdSet = uccSkuPos.stream().filter(e -> e.getCommodityId() != null).map(UccSkuPo::getCommodityId).collect(Collectors.toSet());
                Map<Object, Object> commodityIdMap = new HashMap();
                if (!CollectionUtils.isEmpty(commodityIdSet) && !CollectionUtils.isEmpty((Collection)(commodityPos = this.uccCommodityMapper.qeryBatchCommdity(new ArrayList<Long>(commodityIdSet))))) {
                    commodityIdMap = commodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, o -> o));
                }
                for (UccSkuPo po : uccSkuPos) {
                    String url = this.approveEntrustNoticeJumpUrlIp;
                    Integer isSupermarketStaff = null;
                    if (commodityIdMap.containsKey(po.getCommodityId())) {
                        isSupermarketStaff = ((UccCommodityPo)commodityIdMap.get(po.getCommodityId())).getIsSupermarketStaff();
                    }
                    if (SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource().equals(po.getSkuSource())) {
                        url = isSupermarketStaff != null && isSupermarketStaff == 1 ? url + "/#/index/userEcCommodityItemDetail?skuId=" + po.getSkuId() + "&supplierShopId=" + po.getSupplierShopId() + "&tabKey=6" : url + "/#/index/ecCommodityItemDetail?skuId=" + po.getSkuId() + "&supplierShopId=" + po.getSupplierShopId() + "&from=ecCommodityApprovalList";
                    }
                    if (SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource().equals(po.getSkuSource())) {
                        url = isSupermarketStaff != null && isSupermarketStaff == 1 ? url + "/#/index/userSkuDetail?isEditDetail=false&skuId=" + po.getSkuId() + "&tabKey=2&isArg=false&objType=3&supplierShopId=" + po.getSupplierShopId() : url + "/#/index/unagrSkuDetail?isEditDetail=false&skuId=" + po.getSkuId() + "&tabKey=2&isArg=false&objType=3&supplierShopId=" + po.getSupplierShopId();
                    }
                    if (SkuSourceEnum.AGREEMENT_SOURCE.getSource().equals(po.getSkuSource())) {
                        url = isSupermarketStaff != null && isSupermarketStaff == 1 ? url + "/#/index/userSkuDetail?isEditDetail=false&skuId=" + po.getSkuId() + "&tabKey=2&isArg=false&objType=3&supplierShopId=" + po.getSupplierShopId() : url + "/#/index/agrSkuDetail?isEditDetail=false&skuId=" + po.getSkuId() + "&tabKey=2&isArg=false&objType=3&supplierShopId=" + po.getSupplierShopId();
                    }
                    objIdMap.put(po.getSkuId(), url);
                }
            } else if (ApproveEntrustConstant.ApproveEntrustType.COMMODITY.equals(reqBO.getObjType())) {
                List<UccCommodityPo> commodityPos = this.uccCommodityMapper.qeryBatchCommdity(reqBO.getObjIds());
                if (CollectionUtils.isEmpty(commodityPos)) {
                    return rspBO;
                }
                for (UccCommodityPo po : commodityPos) {
                    String url = "";
                    Integer isSupermarketStaff = po.getIsSupermarketStaff();
                    if (SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource().equals(po.getCommoditySource()) && (isSupermarketStaff == null || isSupermarketStaff != 1)) {
                        url = url + "/#/index/unagrCommodityDetail?isEditDetail=false&commodityId=" + po.getCommodityId() + "&supplierShopId=" + po.getSupplierShopId() + "&objType=2";
                    }
                    if (SkuSourceEnum.AGREEMENT_SOURCE.getSource().equals(po.getCommoditySource())) {
                        url = isSupermarketStaff != null && isSupermarketStaff == 1 ? url + "/#/index/userCommodityDetail?isEditDetail=false&commodityId=" + po.getCommodityId() + "&supplierShopId=" + po.getSupplierShopId() + "&objType=2" : url + "/#/index/agrCommodityDetail?isEditDetail=false&commodityId=" + po.getCommodityId() + "&supplierShopId=" + po.getSupplierShopId() + "&objType=2";
                    }
                    if (StringUtils.isEmpty((Object)url)) continue;
                    objIdMap.put(po.getCommodityId(), this.approveEntrustNoticeJumpUrlIp + url);
                }
            } else if (ApproveEntrustConstant.ApproveEntrustType.MODIFY_APPLY_SHELVES.equals(reqBO.getObjType())) {
                ApplyShelvesFormPO searchPO = new ApplyShelvesFormPO();
                searchPO.setApplyIds(reqBO.getObjIds());
                List<ApplyShelvesFormPO> applyShelvesFormPOS = this.applyShelvesFormMapper.getList(searchPO);
                if (CollectionUtils.isEmpty(applyShelvesFormPOS)) {
                    return rspBO;
                }
                for (ApplyShelvesFormPO po : applyShelvesFormPOS) {
                    String url = "";
                    url = url + this.approveEntrustNoticeJumpUrlIp + "/#/index/purApproveDetail?applyId=" + po.getApplyId() + "&applyCode=" + po.getApplyCode() + "&type=1&isDetail=2";
                    objIdMap.put(po.getApplyId(), url);
                }
            } else if (ApproveEntrustConstant.ApproveEntrustType.CREATE_BRAND_APPLY.equals(reqBO.getObjType())) {
                BrandApplyPO selectApply = new BrandApplyPO();
                selectApply.setIds(reqBO.getObjIds());
                List<BrandApplyPO> list = this.brandApplyMapper.getList(selectApply);
                if (CollectionUtils.isEmpty(list)) {
                    return rspBO;
                }
                for (BrandApplyPO po : list) {
                    String url = "";
                    url = url + this.approveEntrustNoticeJumpUrlIp + "/#/index/brandApplicationApproveDetail?type=2&auditResult=0&id=" + po.getId();
                    objIdMap.put(po.getId(), url);
                }
            } else if (ApproveEntrustConstant.ApproveEntrustType.BRAND_VERSION_STATUS.equals(reqBO.getObjType())) {
                UccBrandVersionPO brandApplyPO = new UccBrandVersionPO();
                brandApplyPO.setIds(reqBO.getObjIds());
                List<UccBrandVersionPO> brandApplyPOS = this.uccBrandVersionMapper.selectAll(brandApplyPO);
                if (CollectionUtils.isEmpty(brandApplyPOS)) {
                    return rspBO;
                }
                for (UccBrandVersionPO po : brandApplyPOS) {
                    String url = "";
                    url = !StringUtils.isEmpty((Object)po.getChangeCode()) ? url + this.approveEntrustNoticeJumpUrlIp + "/#/index/brandChangeDetail?id=" + po.getId() : url + this.approveEntrustNoticeJumpUrlIp + "/#/index/brandCreateDetail?id=" + po.getId();
                    objIdMap.put(po.getId(), url);
                }
            } else if (ApproveEntrustConstant.ApproveEntrustType.BRAND_REL.equals(reqBO.getObjType())) {
                UccBrandRelApprovePO uccBrandRelApprovePo = new UccBrandRelApprovePO();
                uccBrandRelApprovePo.setApproveIds(reqBO.getObjIds());
                List<UccBrandRelApprovePO> uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getList(uccBrandRelApprovePo);
                if (CollectionUtils.isEmpty(uccBrandRelApprovePos)) {
                    return rspBO;
                }
                for (UccBrandRelApprovePO po : uccBrandRelApprovePos) {
                    String url = "";
                    url = url + this.approveEntrustNoticeJumpUrlIp + "/#/index/brandRelationApprovalDetail?approveId=" + po.getApproveId() + "&type=1";
                    objIdMap.put(po.getApproveId(), url);
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5ba1\u6279\u5bf9\u8c61\u679a\u4e3e\u503c\u4e0d\u5bf9");
            }
        }
        return rspBO;
    }
}

