/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementScopeBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.SkuExtEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateCompareAbilityService;
import com.tydic.commodity.busibase.atom.bo.CommodityCategoryForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommodityForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommoditySpecForEsBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuAttrInfoBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.JudgeSkuEsBo;
import com.tydic.commodity.busibase.atom.bo.SkuForEsBO;
import com.tydic.commodity.busibase.atom.bo.UccPoolsLableBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsReqBO;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.common.ability.api.SyncSceneStandardCommodityToEsAbilityService;
import com.tydic.commodity.common.ability.api.UccStandardComInfoAddAbilityService;
import com.tydic.commodity.common.ability.bo.SyncSceneStandardCommodityToEsAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccCollectMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccPriceAnomalyItemMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorPoolMapper;
import com.tydic.commodity.dao.UccRelCatalogVendorDiscountMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuExtMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirLogMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.dao.WelfareActiveSkuMapper;
import com.tydic.commodity.po.CommodityForEsPO;
import com.tydic.commodity.po.CommoditySpecForEsPO;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuForEsPO;
import com.tydic.commodity.po.SkuSurPassVptPo;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCatalogLevelPo;
import com.tydic.commodity.po.UccChannelDealPO;
import com.tydic.commodity.po.UccCollectPO;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccPriceAnomalyItemPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPoolPO;
import com.tydic.commodity.po.UccRelChannelPoolPo;
import com.tydic.commodity.po.UccRelCommodityLabelPoolPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import com.tydic.commodity.po.UccSkuExtPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuShelvesPo;
import com.tydic.commodity.po.UocSpuApproverPO;
import com.tydic.commodity.po.WelfareActiveSkuPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="syncSceneCommodityToEsAtomService")
public class SyncSceneCommodityToEsAtomServiceImpl
implements SyncSceneCommodityToEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    @Autowired
    private SyncSceneStandardCommodityToEsAbilityService syncSceneStandardCommodityToEsAbilityService;
    @Autowired
    private UccStandardComInfoAddAbilityService uccStandardComInfoAddAbilityService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper cnncRelCommodityLaberPoolMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccSkuPutCirLogMapper uccSkuPutCirLogMapper;
    @Autowired
    private WelfareActiveSkuMapper welfareActiveSkuMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccRelCatalogVendorDiscountMapper uccRelCatalogVendorDiscountMapper;
    @Autowired
    private UccRelCatalogBrandVendorPoolMapper uccRelCatalogBrandVendorPoolMapper;
    @Value(value="${discount_digit:4}")
    private String digit;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuExtMapper uccSkuExtMapper;
    @Autowired
    private UccCollectMapper uccCollectMapper;
    @Autowired
    private SkuDataGovernMapper skuDataGovernMapper;
    @Resource(name="syncSearchProvider")
    private ProxyMessageProducer syncSearchProvider;
    @Value(value="${UCC_GOODS_CHANGE_SYNC_SE_TOPIC:UCC_GOODS_CHANGE_SYNC_SE_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${UCC_GOODS_CHANGE_SYNC_SE_TAG:UCC_GOODS_CHANGE_SYNC_SE_TAG}")
    private String uccSyncTag;
    @Value(value="${channel_id}")
    private String channelId;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Value(value="${search.new.flag:false}")
    private boolean newSearchFlag;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private String snIdFl;
    @Autowired
    private UccDataGovernPushSkuStateCompareAbilityService uccDataGovernPushSkuStateCompareAbilityService;
    @Autowired
    private UccPriceAnomalyItemMapper uccPriceAnomalyItemMapper;
    @Autowired
    private SkuDataGovernPriceMapper skuDataGovernPriceMapper;

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        if (syncSceneCommodityToEsReqBO.getSupplierId() == null && syncSceneCommodityToEsReqBO.getRootOrgIdIn() != null) {
            syncSceneCommodityToEsReqBO.setSupplierId(syncSceneCommodityToEsReqBO.getRootOrgIdIn());
        }
        if (ModelRuleConstant.STANDARD.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            try {
                SyncSceneStandardCommodityToEsAbilityReqBO abilityReqBO = new SyncSceneStandardCommodityToEsAbilityReqBO();
                abilityReqBO.setSyncScene(syncSceneCommodityToEsReqBO.getSyncType());
                abilityReqBO.setCommodityIds(syncSceneCommodityToEsReqBO.getCommodityIds());
                abilityReqBO.setSkuIds(syncSceneCommodityToEsReqBO.getSkuIds());
                abilityReqBO.setSyncType(Integer.valueOf(1));
                this.syncSceneStandardCommodityToEsAbilityService.syncSceneCommodityToEs(abilityReqBO);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            return rspBO;
        }
        if (ModelRuleConstant.STANDARD_ADD.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            try {
                UccStandardComInfoAddAbilityReqBO addAbilityReqBO = (UccStandardComInfoAddAbilityReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO), UccStandardComInfoAddAbilityReqBO.class);
                UccStandardComInfoAddAbilityRspBO standardAddRspBO = this.uccStandardComInfoAddAbilityService.dealStandardComInfoAdd(addAbilityReqBO);
                if ("0000".equals(standardAddRspBO.getRespCode())) {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO1 = new SyncSceneCommodityToEsReqBO();
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(addAbilityReqBO.getSkuId());
                    if (!CollectionUtils.isEmpty((Collection)standardAddRspBO.getSyncSkuIds())) {
                        skuIds.addAll(standardAddRspBO.getSyncSkuIds());
                    }
                    syncSceneCommodityToEsReqBO1.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBO1.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBO1.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO1.setSingleType(0);
                    this.syncCommodityToEs(syncSceneCommodityToEsReqBO1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
            return rspBO;
        }
        this.validateReqParams(syncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.UPDATE_SURPASS.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateSurPassVptToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.UPDATE_BRAND_VERIFY.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateBrandVerifyToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.UPDATE_DISCOUNT_LIMIT.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.checkDiscountLimitValue(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.DATA_GOVERN_SYNC.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncDataGovernToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.CATALOG_DATA_GOVERN_FLAGSYNC.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCatalogDataGovernFlagToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.UPDATE_BRAND.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateBrandName(syncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + syncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        this.syncSearch(syncSceneCommodityToEsReqBO);
        return rspBO;
    }

    private JudgeSkuEsBo isOverJudge(Long skuId) {
        JudgeSkuEsBo judgeSkuEsBo = new JudgeSkuEsBo();
        SkuDataGovernPricePO skuDataGovernPricePo = new SkuDataGovernPricePO();
        skuDataGovernPricePo.setSkuId(skuId);
        SkuDataGovernPricePO modelBy = this.skuDataGovernPriceMapper.getModelBy(skuDataGovernPricePo);
        if (modelBy == null) {
            judgeSkuEsBo.setIsSync(false);
            return judgeSkuEsBo;
        }
        BeanUtils.copyProperties((Object)modelBy, (Object)judgeSkuEsBo);
        UccPriceAnomalyItemPO uccPriceAnomalyItemPo = new UccPriceAnomalyItemPO();
        uccPriceAnomalyItemPo.setIsDeleted(UccConstants.DelTag.NOT_DEL.toString());
        uccPriceAnomalyItemPo.setSkuId(skuId);
        UccSkuPo uccSkuPo = this.uccSkuMapper.qryBySkuId(skuId);
        if (SkuStatusEnum.PENDING_SHELF_STATUS.getStatus().equals(uccSkuPo.getSkuStatus())) {
            uccPriceAnomalyItemPo.setTriggerType(UccConstants.TriggerType.THRESHOLD);
        } else {
            uccPriceAnomalyItemPo.setTriggerType(UccConstants.TriggerType.EARLY_WARNING_OR_AUTOMATIC_REMOVAL);
        }
        List<UccPriceAnomalyItemPO> list = this.uccPriceAnomalyItemMapper.getList(uccPriceAnomalyItemPo);
        if (CollectionUtils.isEmpty(list)) {
            judgeSkuEsBo.setSurpassVptStr("\u5426");
            judgeSkuEsBo.setSurpassVpt(UccConstants.IsAbnormalOverDesc.NO);
            judgeSkuEsBo.setAbnormalFloatingRateDesc(null);
            judgeSkuEsBo.setAbnormalPriceStatusDesc(null);
            return judgeSkuEsBo;
        }
        judgeSkuEsBo.setSurpassVptStr("\u662f");
        judgeSkuEsBo.setSurpassVpt(UccConstants.IsAbnormalOverDesc.YES);
        StringBuilder stringBuilderByPriceStatus = new StringBuilder();
        StringBuilder stringBuilderByFloatingRate = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            UccPriceAnomalyItemPO model = list.get(i);
            if (model.getChangePriceType() == null || model.getFloatingRate() == null) continue;
            if (i == list.size() - 1) {
                stringBuilderByPriceStatus.append(model.getChangePriceType());
                stringBuilderByFloatingRate.append(model.getFloatingRate()).append("%");
                continue;
            }
            stringBuilderByPriceStatus.append(model.getChangePriceType()).append("\uff0c");
            stringBuilderByFloatingRate.append(model.getFloatingRate()).append("%").append("\uff0c");
        }
        judgeSkuEsBo.setAbnormalPriceStatusDesc(stringBuilderByPriceStatus.toString());
        judgeSkuEsBo.setAbnormalFloatingRateDesc(stringBuilderByFloatingRate.toString());
        return judgeSkuEsBo;
    }

    private void updateBrandName(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        if (CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getBrandIds())) {
            return;
        }
        List brandIds = syncSceneCommodityToEsReqBO.getBrandIds();
        List<UccMallBrandRelPO> brandList = this.uccMallBrandRelMapper.getBrandList(brandIds);
        for (UccMallBrandRelPO each : brandList) {
            try {
                JSONObject object = new JSONObject();
                object.put("brand_name", (Object)each.getMallBrandName());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getMallBrandId().toString(), object);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    private void syncSearch(SyncSceneCommodityToEsReqBO reqBO) {
        if (this.newSearchFlag) {
            SyncSceneCommodityToEsReqBO sync = new SyncSceneCommodityToEsReqBO();
            if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(reqBO.getOperType())) {
                sync.setOperType(Integer.valueOf(0));
            } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(reqBO.getOperType())) {
                sync.setOperType(Integer.valueOf(1));
            } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(reqBO.getOperType())) {
                sync.setOperType(Integer.valueOf(0));
            } else {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                sync.setSkuIds(reqBO.getSkuIds());
                sync.setSyncType(Integer.valueOf(4));
            } else if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
                sync.setCommodityIds(reqBO.getCommodityIds());
                sync.setSyncType(Integer.valueOf(0));
            } else {
                return;
            }
            this.syncSearchProvider.send(new ProxyMessage(this.uccSyncTopic, this.uccSyncTag, JSONObject.toJSONString((Object)sync)));
        }
    }

    private void syncCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("ES \u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a \u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f->{}" + JSONObject.toJSONString((Object)reqBO));
            return;
        }
        List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, esStorageSpuInfoBOS, commodityForEsBOS);
        this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.dealChannel(esStorageSpuInfoBOS);
        this.dealLable(esStorageSpuInfoBOS);
        this.applrovalCommodityToEs(esStorageSpuInfoBOS);
        this.syncActiveToSkuEs(esStorageSpuInfoBOS);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            this.syncSkuExtToSku(reqBO.getSkuIds(), esStorageSpuInfoBOS);
        }
        this.syncSkuCollectNumAndPageViews(esStorageSpuInfoBOS);
        this.syncSkuAgreemeScopeList(esStorageSpuInfoBOS);
        esStorageSpuInfoBOS.forEach(o -> {
            JudgeSkuEsBo overJudge = this.isOverJudge(o.getSku_id());
            if (overJudge.getIsSync().booleanValue()) {
                BeanUtils.copyProperties((Object)overJudge, (Object)o);
            }
        });
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private void syncSkuAgreemeScopeList(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (esStorageSpuInfoBO.getChannel_id() != null && esStorageSpuInfoBO.getChannel_id().size() > 0 && esStorageSpuInfoBO.getChannel_id().contains(Long.valueOf(this.channelId))) {
                if (esStorageSpuInfoBO.getAgreement_id() == null) {
                    LOGGER.debug("\u5546\u54c1\u4e0d\u662f\u534f\u8bae\u5546\u54c1");
                    esStorageSpuInfoBO.setAgreementScopeList(Collections.singletonList(1L));
                } else {
                    LOGGER.debug("\u662f\u534f\u8bae\u5546\u54c1\uff1a" + esStorageSpuInfoBO.getAgreement_id());
                    AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
                    agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(esStorageSpuInfoBO.getAgreement_id());
                    AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
                    LOGGER.debug("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u8fd4\u56de\u53c2\u6570\uff1a" + JSON.toJSONString((Object)agrQryAgreementSubjectDetailsAbilityRspBO));
                    if (!"0000".equals(agrQryAgreementSubjectDetailsAbilityRspBO.getRespCode())) {
                        esStorageSpuInfoBO.setAgreementScopeList(Collections.singletonList(1L));
                    } else if (agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO() != null) {
                        LOGGER.debug("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u8fd4\u56de\u53c2\u6570BO\uff1a" + JSON.toJSONString((Object)agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO()));
                        List scopeBOLis = agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getAgrAgreementScopeBOs();
                        if (CollectionUtils.isEmpty((Collection)scopeBOLis)) {
                            esStorageSpuInfoBO.setAgreementScopeList(Collections.singletonList(1L));
                        } else {
                            ArrayList<Long> agrScopeList = new ArrayList<Long>();
                            for (AgrAgreementScopeBO scopeBOLi : scopeBOLis) {
                                if (scopeBOLi.getScopeType() != null && "1".equals(scopeBOLi.getScopeType().toString())) {
                                    agrScopeList.add(scopeBOLi.getScopeCode());
                                    continue;
                                }
                                esStorageSpuInfoBO.setAgreementScopeList(Collections.singletonList(1L));
                            }
                            if (agrScopeList.size() > 0) {
                                esStorageSpuInfoBO.setAgreementScopeList(agrScopeList);
                            }
                        }
                        if (null != agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getCloudWarehouseFlag() && agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getCloudWarehouseFlag().equals(1)) {
                            esStorageSpuInfoBO.setCloudWarehouseFlag(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getCloudWarehouseFlag());
                        }
                    } else {
                        esStorageSpuInfoBO.setAgreementScopeList(Collections.singletonList(1L));
                    }
                }
            }
            LOGGER.debug("\u5546\u54c1\u6700\u7ec8\u6570\u636e\u4e3a:" + JSON.toJSONString((Object)esStorageSpuInfoBO));
        }
    }

    private void syncSkuCollectNumAndPageViews(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        List<Long> skuIds = esStorageSpuInfoBOS.stream().map(a -> a.getSku_id()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        Map<Object, Object> collect = new HashMap();
        UccCollectPO qryCollect = new UccCollectPO();
        qryCollect.setSkuIds(skuIds);
        List<UccCollectPO> list = this.uccCollectMapper.getList(qryCollect);
        if (!CollectionUtils.isEmpty(list)) {
            collect = list.stream().collect(Collectors.toMap(e -> e.getSkuId(), e -> e, (k, v) -> k));
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            UccCollectPO po = (UccCollectPO)collect.get(esStorageSpuInfoBO.getSku_id());
            if (po != null) {
                esStorageSpuInfoBO.setCollectNum(po.getCollectNum());
                esStorageSpuInfoBO.setPageViews(po.getLookNum());
                continue;
            }
            esStorageSpuInfoBO.setCollectNum(0);
            esStorageSpuInfoBO.setPageViews(0);
        }
    }

    private void syncSkuExtToSku(List<Long> skuIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        try {
            List<UccSkuExtPo> rejectedToSupplierRemarks = this.uccSkuExtMapper.qeruySkuExtBySkuIds(skuIds, SkuExtEnum.REJECTED_TO_SUPPLIER_REMARKS.getCode());
            List<UccSkuExtPo> onTheShelfRemarks = this.uccSkuExtMapper.selectByskuIds(skuIds);
            Map<Long, String> rejected = rejectedToSupplierRemarks.stream().collect(Collectors.toMap(UccSkuExtPo::getSkuId, UccSkuExtPo::getValue, (k, v) -> k));
            Map<Long, String> onTheShelf = onTheShelfRemarks.stream().collect(Collectors.toMap(UccSkuExtPo::getSkuId, UccSkuExtPo::getValue, (k, v) -> k));
            if (CollectionUtils.isEmpty(rejected) && CollectionUtils.isEmpty(onTheShelf)) {
                return;
            }
            for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
                esStorageSpuInfoBO.setRejected_to_supplier_remarks(rejected.get(esStorageSpuInfoBO.getSku_id()));
                esStorageSpuInfoBO.setOn_the_shelf_remarks(onTheShelf.get(esStorageSpuInfoBO.getSku_id()));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u4fe1\u606f {}", (Object)e.getMessage());
        }
    }

    private void deleteCommodityInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        this.deleteSpuInfoFromEs(reqBO);
    }

    private void updateCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSingleType() == 0) {
            List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
            if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
                LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
                return;
            }
            List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
            SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
            searchEsReqBO.setCommdIds(commodityIds);
            searchEsReqBO.setSceneId(reqBO.getSceneId());
            searchEsReqBO.setPageNo(1);
            searchEsReqBO.setPageSize(commodityIds.size());
            SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
            List<Long> esExistCommodityIds = null;
            if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
                List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
                esExistCommodityIds = commodityRspBos.stream().map(CommodityRspBo::getCommodity_id).collect(Collectors.toList());
            }
            if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
                return;
            }
            ArrayList<CommodityForEsBO> newCommodityForEsBOS = new ArrayList<CommodityForEsBO>();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                if (!esExistCommodityIds.contains(commodityForEsBO.getCommodityId())) continue;
                newCommodityForEsBOS.add(commodityForEsBO);
            }
            ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
            this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS);
            this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS, newCommodityForEsBOS);
            this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
            this.dealChannel(esStorageSpuInfoBOS);
            this.syncActiveToSkuEs(esStorageSpuInfoBOS);
            this.dealLable(esStorageSpuInfoBOS);
            this.applrovalCommodityToEs(esStorageSpuInfoBOS);
            this.syncSkuExtToSku(reqBO.getSkuIds(), esStorageSpuInfoBOS);
            this.syncSkuCollectNumAndPageViews(esStorageSpuInfoBOS);
            this.syncSkuAgreemeScopeList(esStorageSpuInfoBOS);
            esStorageSpuInfoBOS.forEach(o -> {
                JudgeSkuEsBo overJudge = this.isOverJudge(o.getSku_id());
                if (overJudge.getIsSync().booleanValue()) {
                    BeanUtils.copyProperties((Object)overJudge, (Object)o);
                }
            });
            this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
        } else {
            this.searchSku(reqBO);
            if (reqBO.getSingleType() != 1) {
                if (reqBO.getSingleType() == 2) {
                    List<UccSkuPo> poList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
                    ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
                    Map<Object, Object> skuShelvesMap = new HashMap();
                    Map<Object, Object> skuExtMap = new HashMap();
                    if (!CollectionUtils.isEmpty(poList)) {
                        List<Long> skuIds = poList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                        List<UccSkuShelvesPo> uccSkuShelvesPos = this.uccSkuPutCirLogMapper.getSkuShelves(skuIds);
                        skuShelvesMap = uccSkuShelvesPos.stream().collect(Collectors.groupingBy(UccSkuShelvesPo::getSkuId));
                        List<UccSkuExtPo> uccSkuExtPos = this.uccSkuExtMapper.selectByskuIds(skuIds);
                        skuExtMap = uccSkuExtPos.stream().collect(Collectors.groupingBy(UccSkuExtPo::getSkuId));
                    }
                    EsStorageSpuInfoBO bo = null;
                    ArrayList<Long> commds = new ArrayList<Long>();
                    for (UccSkuPo each : poList) {
                        bo = new EsStorageSpuInfoBO();
                        bo.setOnShelveWay(each.getOnShelveWay());
                        bo.setHide(each.getHide());
                        bo.setSku_id(each.getSkuId());
                        bo.setSku_status(each.getSkuStatus());
                        if (!CollectionUtils.isEmpty((Collection)((Collection)skuShelvesMap.get(bo.getSku_id())))) {
                            bo.setUp_count(((UccSkuShelvesPo)((List)skuShelvesMap.get(bo.getSku_id())).get(0)).getUpCount());
                        } else {
                            bo.setUp_count(0);
                        }
                        bo.setCommodity_id(each.getCommodityId());
                        if (each.getCreateTime() != null) {
                            bo.setCreate_time(each.getCreateTime().getTime());
                        }
                        if (each.getOnShelveTime() != null) {
                            bo.setUp_time(each.getOnShelveTime().getTime());
                        }
                        if (each.getOnShelveTime() != null) {
                            bo.setOn_shelve_time(each.getOnShelveTime().getTime());
                        }
                        bo.setSku_approval_status(each.getApprovalStatus());
                        if (!CollectionUtils.isEmpty((Collection)((Collection)skuExtMap.get(bo.getSku_id())))) {
                            bo.setOn_the_shelf_remarks(((UccSkuExtPo)((List)skuExtMap.get(bo.getSku_id())).get(0)).getValue());
                        }
                        commds.add(each.getCommodityId());
                        esStorageSpuInfoBOS.add(bo);
                    }
                    List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.queryByCommodityIdLists(commds);
                    if (!CollectionUtils.isEmpty(commodityPoList)) {
                        Map<Long, List<UccCommodityPo>> mapSpu = commodityPoList.stream().collect(Collectors.groupingBy(UccCommodityPo::getCommodityId));
                        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
                            if (!mapSpu.containsKey(esStorageSpuInfoBO.getCommodity_id())) continue;
                            esStorageSpuInfoBO.setCommodity_status(((UccCommodityPo)((List)mapSpu.get(esStorageSpuInfoBO.getCommodity_id())).get(0)).getCommodityStatus());
                            esStorageSpuInfoBO.setSpu_approval_status(((UccCommodityPo)((List)mapSpu.get(esStorageSpuInfoBO.getCommodity_id())).get(0)).getApprovalStatus());
                        }
                    }
                    this.applrovalCommodityToEs(esStorageSpuInfoBOS);
                    this.dealPush(poList);
                    esStorageSpuInfoBOS.forEach(o -> {
                        JudgeSkuEsBo overJudge = this.isOverJudge(o.getSku_id());
                        if (overJudge.getIsSync().booleanValue()) {
                            BeanUtils.copyProperties((Object)overJudge, (Object)o);
                        }
                    });
                    if (!CollectionUtils.isEmpty(poList)) {
                        for (EsStorageSpuInfoBO each : esStorageSpuInfoBOS) {
                            JSONObject object = new JSONObject();
                            object.put("sku_status", (Object)each.getSku_status());
                            object.put("audit_time", (Object)each.getAudit_time());
                            object.put("on_shelve_time", (Object)each.getOn_shelve_time());
                            object.put("up_time", (Object)each.getUp_time());
                            object.put("operIds", each.getOperIds());
                            object.put("create_time", (Object)each.getCreate_time());
                            object.put("sku_approval_status", (Object)each.getSku_approval_status());
                            object.put("spu_approval_status", (Object)each.getSpu_approval_status());
                            object.put("commodity_status", (Object)each.getCommodity_status());
                            object.put("onShelveWay", (Object)each.getOnShelveWay());
                            object.put("hide", (Object)each.getHide());
                            object.put("on_the_shelf_remarks", (Object)each.getOn_the_shelf_remarks());
                            object.put("intMinPrice", (Object)each.getIntMinPrice());
                            object.put("intMaxPrice", (Object)each.getIntMaxPrice());
                            object.put("intVagPrice", (Object)each.getIntVagPrice());
                            object.put("sameIntSkuIdPrice", (Object)each.getSameIntSkuIdPrice());
                            object.put("abnormalPriceStatusDesc", (Object)each.getAbnormalPriceStatusDesc());
                            object.put("abnormalFloatingRateDesc", (Object)each.getAbnormalFloatingRateDesc());
                            object.put("surpassVptStr", (Object)each.getSurpassVptStr());
                            object.put("surpassVpt", (Object)each.getSurpassVpt());
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSku_id().toString() : reqBO.getSceneId() + "" + each.getSku_id(), object);
                        }
                        this.syncStandard(poList);
                    }
                } else if (reqBO.getSingleType() == 3) {
                    List<UccSkuPricePo> pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    List<UccLadderPricePO> ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    Map<Object, Object> skuLadderMap = new HashMap();
                    if (CollectionUtils.isEmpty(ladderPricePOS)) {
                        skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                    }
                    if (!CollectionUtils.isEmpty(pricePos)) {
                        for (UccSkuPricePo each : pricePos) {
                            JSONObject object = new JSONObject();
                            object.put("sale_price", (Object)each.getSalePrice());
                            object.put("agreement_price", (Object)each.getAgreementPrice());
                            object.put("market_price", (Object)each.getMarketPrice());
                            object.put("member_price1", (Object)each.getMemberPrice1());
                            object.put("member_price2", (Object)each.getMemberPrice2());
                            object.put("member_price3", (Object)each.getMemberPrice3());
                            object.put("member_price4", (Object)each.getMemberPrice4());
                            object.put("member_price5", (Object)each.getMemberPrice5());
                            String discount = "0";
                            if (each.getAgreementPrice() != null && each.getMarketPrice() != null && each.getMarketPrice() != 0L) {
                                BigDecimal bigDecimal = new BigDecimal(each.getAgreementPrice()).divide(new BigDecimal(each.getMarketPrice()), Integer.parseInt(this.digit), RoundingMode.DOWN);
                                discount = bigDecimal.toString();
                            }
                            object.put("discounts", (Object)discount);
                            if (skuLadderMap.containsKey(each.getSkuId())) {
                                List ladderPrice = ((List)skuLadderMap.get(each.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList());
                                object.put("ladderPrice", ladderPrice);
                            }
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else if (reqBO.getSingleType() == 4) {
                    List<UccSkuPo> poList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
                    if (!CollectionUtils.isEmpty(poList)) {
                        UccCollectPO uccCollectPO = new UccCollectPO();
                        uccCollectPO.setSkuIds(reqBO.getSkuIds());
                        List<UccCollectPO> collectList = this.uccCollectMapper.getList(uccCollectPO);
                        Map<Object, Object> collectMap = new HashMap();
                        if (!CollectionUtils.isEmpty(collectList)) {
                            collectMap = collectList.stream().collect(Collectors.toMap(e -> e.getSkuId(), e -> e, (k, v) -> k));
                        }
                        for (UccSkuPo each : poList) {
                            UccCollectPO collectPO = (UccCollectPO)collectMap.get(each.getSkuId());
                            JSONObject object = new JSONObject();
                            if (collectPO == null) {
                                object.put("collectNum", (Object)0);
                                object.put("pageViews", (Object)0);
                            } else {
                                object.put("collectNum", (Object)collectPO.getCollectNum());
                                object.put("pageViews", (Object)collectPO.getLookNum());
                            }
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else {
                    LOGGER.error("\u672a\u77e5\u540c\u6b65\u7c7b\u578b");
                }
            }
        }
    }

    private void dealPush1(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        try {
            List pushList = esStorageSpuInfoBOS.stream().filter(e -> e.getSku_source() == 2).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(pushList)) {
                this.uccDataGovernPushSkuStateCompareAbilityService.compareDataGovernPushSkuState(esStorageSpuInfoBOS);
            }
        }
        catch (Exception e1) {
            log.error("\u63a8\u9001\u72b6\u6001\u4fe1\u606f\u5931\u8d25 {}", (Object)e1.getMessage());
        }
    }

    private void dealPush(List<UccSkuPo> poList) {
        try {
            List<EsStorageSpuInfoBO> pushList = poList.stream().filter(e -> e.getSkuSource() == 2).map(e -> {
                EsStorageSpuInfoBO atomBO = new EsStorageSpuInfoBO();
                atomBO.setSku_id(e.getSkuId());
                atomBO.setSku_status(e.getSkuStatus());
                return atomBO;
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(pushList)) {
                this.uccDataGovernPushSkuStateCompareAbilityService.compareDataGovernPushSkuState(pushList);
            }
        }
        catch (Exception e2) {
            log.error("\u63a8\u9001\u72b6\u6001\u4fe1\u606f\u5931\u8d25 {}", (Object)e2.getMessage());
        }
    }

    private void syncStandard(List<UccSkuPo> poList) {
        CompletableFuture.runAsync(() -> {
            SyncSceneStandardCommodityToEsAbilityReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsAbilityReqBO();
            syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
            syncSceneStandardCommodityToEsReqBO.setSkuIds(poList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
            syncSceneStandardCommodityToEsReqBO.setSyncScene(UccConstants.StandardSyncEsScene.Sku);
            SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneStandardCommodityToEsAbilityService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
            if (!"0000".equals(syncSceneCommodityToEsRspBO.getRespCode())) {
                log.error("\u4e0b\u67b6\u5546\u54c1\u548c\u5355\u54c1\u5931\u8d25\uff1a{}", (Object)syncSceneCommodityToEsRspBO.getRespCode());
            }
        });
    }

    private void updateBrandVerifyToEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, 1000);
                List<SkuSurPassVptPo> syncSkus = this.uccSkuMapper.getSkuBrandVerfy(reqBO.getCategoryIds(), page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (CollectionUtils.isEmpty(syncSkus)) continue;
                ArrayList<SkuForEsBO> skuForEsBOS = new ArrayList<SkuForEsBO>();
                for (SkuSurPassVptPo sku : syncSkus) {
                    SkuForEsBO skuForEsBO = new SkuForEsBO();
                    BeanUtils.copyProperties((Object)sku, (Object)skuForEsBO);
                    skuForEsBO.setMgCatalogId(sku.getCatalogId());
                    skuForEsBOS.add(skuForEsBO);
                }
                this.checkMallBrand(skuForEsBOS);
                Map<Long, SkuForEsBO> skuMap = skuForEsBOS.stream().collect(Collectors.toMap(a -> a.getSkuId(), a -> a, (first, second) -> first));
                for (SkuSurPassVptPo each : syncSkus) {
                    try {
                        JSONObject object = new JSONObject();
                        object.put("brand_verify", (Object)each.getBrandVerify());
                        if (skuMap.containsKey(each.getSkuId())) {
                            if (skuMap.get(each.getSkuId()).getBrandVerifyResult() != null) {
                                object.put("brandVerifyResult", (Object)skuMap.get(each.getSkuId()).getBrandVerifyResult());
                            }
                            if (!StringUtils.isEmpty((CharSequence)skuMap.get(each.getSkuId()).getBrandVerifyFailReason())) {
                                object.put("brandVerifyFailReason", (Object)skuMap.get(each.getSkuId()).getBrandVerifyFailReason());
                            }
                            if (null != skuMap.get(each.getSkuId()).getDataGovernFlag()) {
                                object.put("data_govern_flag", (Object)skuMap.get(each.getSkuId()).getDataGovernFlag());
                            }
                        }
                        this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getSkuId().toString(), object);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            } while (++num <= total);
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            List<SkuSurPassVptPo> syncSkus = this.uccSkuMapper.getSkuBrandVerfyBySkuIds(reqBO.getSkuIds());
            ArrayList<SkuForEsBO> skuForEsBOS = new ArrayList<SkuForEsBO>();
            for (SkuSurPassVptPo sku : syncSkus) {
                SkuForEsBO skuForEsBO = new SkuForEsBO();
                BeanUtils.copyProperties((Object)sku, (Object)skuForEsBO);
                skuForEsBO.setMgCatalogId(sku.getCatalogId());
                skuForEsBOS.add(skuForEsBO);
            }
            this.checkMallBrand(skuForEsBOS);
            Map<Long, SkuForEsBO> skuMap = skuForEsBOS.stream().collect(Collectors.toMap(a -> a.getSkuId(), a -> a, (first, second) -> first));
            for (SkuSurPassVptPo each : syncSkus) {
                try {
                    JSONObject object = new JSONObject();
                    object.put("brand_verify", (Object)each.getBrandVerify());
                    if (skuMap.containsKey(each.getSkuId())) {
                        if (skuMap.get(each.getSkuId()).getBrandVerifyResult() != null) {
                            object.put("brandVerifyResult", (Object)skuMap.get(each.getSkuId()).getBrandVerifyResult());
                        }
                        if (!StringUtils.isEmpty((CharSequence)skuMap.get(each.getSkuId()).getBrandVerifyFailReason())) {
                            object.put("brandVerifyFailReason", (Object)skuMap.get(each.getSkuId()).getBrandVerifyFailReason());
                        }
                        if (null != skuMap.get(each.getSkuId()).getDataGovernFlag()) {
                            object.put("data_govern_flag", (Object)skuMap.get(each.getSkuId()).getDataGovernFlag());
                        }
                    }
                    object.put("sku_status", (Object)each.getSkuStatus());
                    this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getSkuId().toString(), object);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    private void updateSurPassVptToEs(SyncSceneCommodityToEsReqBO reqBO) {
        SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
        searchEsReqBO.setSkuList(reqBO.getSkuIds());
        searchEsReqBO.setPageNo(1);
        searchEsReqBO.setPageSize(reqBO.getSkuIds().size());
        SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
        List esExistSkuIds = null;
        if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
            List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
            esExistSkuIds = commodityRspBos.stream().map(CommodityRspBo::getSku_id).collect(Collectors.toList());
        }
        if (esExistSkuIds == null || esExistSkuIds.isEmpty()) {
            return;
        }
        List<SkuSurPassVptPo> skuSurPassVptPos = this.uccSkuMapper.getSurPassVpt(esExistSkuIds);
        if (!CollectionUtils.isEmpty(skuSurPassVptPos)) {
            for (SkuSurPassVptPo each : skuSurPassVptPos) {
                JSONObject object = new JSONObject();
                JudgeSkuEsBo overJudge = this.isOverJudge(each.getSkuId());
                if (overJudge.getIsSync().booleanValue()) {
                    object.put("intMinPrice", (Object)overJudge.getIntMinPrice());
                    object.put("intMaxPrice", (Object)overJudge.getIntMaxPrice());
                    object.put("intVagPrice", (Object)overJudge.getIntVagPrice());
                    object.put("sameIntSkuIdPrice", (Object)overJudge.getSameIntSkuIdPrice());
                    object.put("abnormalPriceStatusDesc", (Object)overJudge.getAbnormalPriceStatusDesc());
                    object.put("abnormalFloatingRateDesc", (Object)overJudge.getAbnormalFloatingRateDesc());
                    object.put("surpassVptStr", (Object)overJudge.getSurpassVptStr());
                    object.put("surpassVpt", (Object)overJudge.getSurpassVpt());
                }
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getSkuId().toString(), object);
            }
        }
    }

    private List<CommodityForEsBO> qryCommodityList(SyncSceneCommodityToEsReqBO reqBO) {
        List<Long> commodityTypeIds;
        List<CommodityForEsBO> commodityForEsBOS = new ArrayList<CommodityForEsBO>();
        List<CommodityForEsPO> forEsPOList = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBO.getGuiCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSceneId());
        }
        List<UccSkuPo> skuPoList = null;
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                throw new BusinessException("8888", "\u672a\u83b7\u53d6\u5230skuId");
            }
            skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                return commodityForEsBOS;
            }
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            for (UccSkuPo each : skuPoList) {
                if (commodityIds.contains(each.getCommodityId())) continue;
                commodityIds.add(each.getCommodityId());
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (!CollectionUtils.isEmpty(forEsPOList)) {
            commodityForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(forEsPOList), CommodityForEsBO.class);
            if (!CollectionUtils.isEmpty(skuPoList)) {
                Map<Long, List<UccSkuPo>> collect = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
                for (int i = 0; i < commodityForEsBOS.size(); ++i) {
                    CommodityForEsBO commodityForEsBO = commodityForEsBOS.get(i);
                    List<UccSkuPo> uccSkuPos = collect.get(commodityForEsBO.getCommodityId());
                    if (CollectionUtils.isEmpty(uccSkuPos)) continue;
                    Integer onShelveWay = uccSkuPos.get(0).getOnShelveWay();
                    commodityForEsBO.setOnShelveWay(onShelveWay);
                }
            }
        }
        if (!CollectionUtils.isEmpty(commodityForEsBOS)) {
            ArrayList mergeSameB0s = new ArrayList();
            HashedMap mergeSameMap = new HashedMap();
            for (CommodityForEsBO each : commodityForEsBOS) {
                CommodityForEsBO bo;
                if (each.getGuideCataLogId() == null) {
                    bo = new CommodityForEsBO();
                    BeanUtils.copyProperties((Object)each, (Object)bo);
                    mergeSameMap.put(each.getCommodityId(), bo);
                    continue;
                }
                if (mergeSameMap.containsKey(each.getCommodityId())) {
                    ((CommodityForEsBO)mergeSameMap.get(each.getCommodityId())).getGuideCataLogIds().add(each.getGuideCataLogId());
                    continue;
                }
                bo = new CommodityForEsBO();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setGuideCataLogIds(new ArrayList<Long>(Arrays.asList(each.getGuideCataLogId())));
                mergeSameMap.put(each.getCommodityId(), bo);
            }
            commodityForEsBOS = new ArrayList();
            for (Map.Entry entry : mergeSameMap.entrySet()) {
                commodityForEsBOS.add((CommodityForEsBO)entry.getValue());
            }
            commodityForEsBOS.addAll(mergeSameB0s);
        }
        return commodityForEsBOS;
    }

    private void assemblyEsSkuInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<Long> skuIds;
        List<UccLadderPricePO> ladderPricePOS;
        Object mallBrandRelList;
        List<SkuForEsPO> skuForEsPOList = this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty(skuForEsPOList)) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        List skuForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(skuForEsPOList), SkuForEsBO.class);
        skuForEsBOS.forEach(sku -> {
            sku.setOriginBrandId(sku.getBrandId());
            sku.setOriginBrandName(sku.getBrandName());
        });
        List<Long> brandList = skuForEsBOS.stream().filter(a -> a.getBrandId() != null).map(SkuForEsBO::getBrandId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(brandList) && !CollectionUtils.isEmpty((Collection)(mallBrandRelList = this.uccMallBrandRelMapper.getRelByBrandList(brandList)))) {
            block2: for (SkuForEsBO sku2 : skuForEsBOS) {
                Iterator iterator = mallBrandRelList.iterator();
                while (iterator.hasNext()) {
                    UccMallBrandRelPO rel = (UccMallBrandRelPO)iterator.next();
                    if (sku2.getBrandId() == null || !sku2.getBrandId().equals(rel.getBrandId())) continue;
                    sku2.setBrandId(rel.getMallBrandId());
                    sku2.setBrandName(rel.getMallBrandName());
                    continue block2;
                }
            }
        }
        for (SkuForEsBO each : skuForEsBOS) {
            if (each.getStandardPrice() != null && each.getUpRatio() != null && each.getAgreementPrice() != null) {
                if (MoneyUtils.haoToYuan(each.getAgreementPrice()).compareTo(each.getStandardPrice().multiply(BigDecimal.ONE.add(each.getUpRatio()))) > 0) {
                    each.setSurpassStandardPriceFlag("1");
                    continue;
                }
                each.setSurpassStandardPriceFlag("0");
                continue;
            }
            each.setSurpassStandardPriceFlag("0");
        }
        this.checkMallBrand(skuForEsBOS);
        List ladderEsBo = skuForEsBOS.stream().filter(a -> a.getSwitchOn() != null && a.getSwitchOn() == 1).collect(Collectors.toList());
        List laderSku = null;
        if (!CollectionUtils.isEmpty(ladderEsBo)) {
            laderSku = ladderEsBo.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(laderSku) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId()))) {
            Map<Long, List<UccLadderPricePO>> skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            skuForEsBOS.forEach(sku -> {
                if (skuLadderMap.containsKey(sku.getSkuId())) {
                    sku.setLadderPrice(((List)skuLadderMap.get(sku.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList()));
                }
            });
        }
        if (!CollectionUtils.isEmpty(skuIds = skuForEsBOS.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList()))) {
            Map<Object, Object> skuPutMap = new HashMap();
            Map<Object, Object> skuDownMap = new HashMap();
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setState(1);
            List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccSkuPutCirMapper.batchQryById(skuIds, uccSkuPutCirPo);
            if (!CollectionUtils.isEmpty(uccSkuPutCirPos)) {
                skuPutMap = uccSkuPutCirPos.stream().filter(a -> a.getRealUpTime() != null).collect(Collectors.toMap(a -> a.getSkuId(), a -> a.getRealUpTime(), (first, second) -> first));
                skuDownMap = uccSkuPutCirPos.stream().filter(a -> a.getRealDownTime() != null).collect(Collectors.toMap(a -> a.getSkuId(), a -> a.getRealDownTime(), (first, second) -> first));
            }
            List<Object> addCoefficientSkuIds = new ArrayList();
            List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
            if (!CollectionUtils.isEmpty(uccSkuAddCoefficientPOS)) {
                addCoefficientSkuIds = uccSkuAddCoefficientPOS.stream().map(a -> a.getSkuId()).distinct().collect(Collectors.toList());
            }
            Map<Object, Object> skuUpConutMap = new HashMap();
            List<UccSkuShelvesPo> uccSkuShelvesPos = this.uccSkuPutCirLogMapper.getSkuShelves(skuIds);
            if (!CollectionUtils.isEmpty(uccSkuShelvesPos)) {
                skuUpConutMap = uccSkuShelvesPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), a -> a.getUpCount(), (first, second) -> first));
            }
            for (SkuForEsBO sku3 : skuForEsBOS) {
                if (skuPutMap.containsKey(sku3.getSkuId())) {
                    sku3.setOnShelveTime(DateUtils.dateToStr((Date)((Date)skuPutMap.get(sku3.getSkuId()))));
                    try {
                        sku3.setOnShelveTime(DateUtils.dateToStrLong((Date)((Date)skuPutMap.get(sku3.getSkuId()))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (skuDownMap.containsKey(sku3.getSkuId())) {
                    sku3.setDownTime((Date)skuDownMap.get(sku3.getSkuId()));
                }
                if (addCoefficientSkuIds.contains(sku3.getSkuId())) {
                    sku3.setSkuAddPrice(1);
                } else {
                    sku3.setSkuAddPrice(0);
                }
                if (skuUpConutMap.containsKey(sku3.getSkuId())) {
                    sku3.setUpCount((Integer)skuUpConutMap.get(sku3.getSkuId()));
                    continue;
                }
                sku3.setUpCount(0);
            }
        }
        HashMap<Long, Long> skuStockPoMap = new HashMap();
        List<UccSaleNumPo> saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, Function.identity(), (k1, k2) -> k1));
        List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds, 1);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, Function.identity(), (k1, k2) -> k1));
        if (!CollectionUtils.isEmpty(skuIds = this.uccSkuMapper.checkInventoryManagement(skuIds, reqBO.getSupplierId()))) {
            SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
            smcsdkQryStockNumReqBO.setSkuIds(skuIds);
            SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
            if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode()) && smcsdkQryStockNumRspBO.getSkuStockNumMap() != null && !smcsdkQryStockNumRspBO.getSkuStockNumMap().isEmpty()) {
                skuStockPoMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
        }
        List<Long> agrId = skuForEsBOS.stream().map(SkuForEsBO::getAgreementId).collect(Collectors.toList());
        List<UccOrgSkuWhiteRestrictionPo> restrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrId, null, 1);
        HashMap<Long, List<Long>> agrWhite = new HashMap<Long, List<Long>>();
        if (!CollectionUtils.isEmpty(restrictionPoList)) {
            Map<Long, List<UccOrgSkuWhiteRestrictionPo>> agrWhitepo = restrictionPoList.stream().collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getAgreementId));
            for (Long agr : agrWhitepo.keySet()) {
                agrWhite.put(agr, agrWhitepo.get(agr).stream().map(UccOrgSkuWhiteRestrictionPo::getOrgId).collect(Collectors.toList()));
            }
        }
        this.buildEsSku(esStorageSpuInfoBOS, skuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap, agrWhite);
    }

    private void buildEsSku(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<SkuForEsBO> skuForEsBOS, Map<Long, Long> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap, Map<Long, List<Long>> agrWhite) {
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            UccSaleNumPo uccSaleNumPo;
            Long stockNum;
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            esStorageSpuInfoBO.setStandard_com_code(skuForEsBO.getStandard_com_code());
            esStorageSpuInfoBO.setGovernance_status(skuForEsBO.getGovernance_status());
            esStorageSpuInfoBO.setStandard_com_name(skuForEsBO.getStandard_com_name());
            esStorageSpuInfoBO.setStandard_com_id(skuForEsBO.getStandard_com_id());
            if (skuForEsBO.getStandard_com_id() == null) {
                esStorageSpuInfoBO.setStandard_flag(0);
            } else {
                esStorageSpuInfoBO.setStandard_flag(skuForEsBO.getStandard_flag());
            }
            esStorageSpuInfoBO.setStandard_sku_num(skuForEsBO.getStandard_sku_num());
            esStorageSpuInfoBO.setAbnormal_desc(skuForEsBO.getAbnormal_desc());
            esStorageSpuInfoBO.setAbnormal_float_str(skuForEsBO.getAbnormal_float_str());
            esStorageSpuInfoBO.setAbnormal_float(skuForEsBO.getAbnormal_float());
            if (!ObjectUtils.isEmpty((Object)skuForEsBO.getReference_price_start())) {
                esStorageSpuInfoBO.setReference_price_start(skuForEsBO.getReference_price_start());
            }
            if (!ObjectUtils.isEmpty((Object)skuForEsBO.getReference_price_end())) {
                esStorageSpuInfoBO.setReference_price_end(skuForEsBO.getReference_price_end());
            }
            if (!ObjectUtils.isEmpty((Object)skuForEsBO.getReference_price_start())) {
                esStorageSpuInfoBO.setReference_price_start(skuForEsBO.getReference_price_start());
            }
            if (!ObjectUtils.isEmpty((Object)skuForEsBO.getReference_price_end())) {
                esStorageSpuInfoBO.setReference_price_end(skuForEsBO.getReference_price_end());
            }
            esStorageSpuInfoBO.setDiscountLimitValue(skuForEsBO.getDiscountLimitValue());
            esStorageSpuInfoBO.setHide(skuForEsBO.getHide());
            esStorageSpuInfoBO.setGovern_result(skuForEsBO.getResult());
            esStorageSpuInfoBO.setData_govern_remark(skuForEsBO.getData_govern_remark());
            esStorageSpuInfoBO.setData_govern_flag(ObjectUtil.isEmpty((Object)skuForEsBO.getDataGovernFlag()) ? 0 : skuForEsBO.getDataGovernFlag());
            esStorageSpuInfoBO.setBrandVerifyFailReason(skuForEsBO.getBrandVerifyFailReason());
            esStorageSpuInfoBO.setSurpassVpt(skuForEsBO.getSurpassVpt());
            esStorageSpuInfoBO.setSurpassStandardPriceFlag(skuForEsBO.getSurpassStandardPriceFlag());
            esStorageSpuInfoBO.setStandardPrice(skuForEsBO.getStandardPrice());
            if (skuForEsBO.getRegularPrice() != null) {
                esStorageSpuInfoBO.setRegular_price(skuForEsBO.getRegularPrice().setScale(4, 4));
            }
            esStorageSpuInfoBO.setBrandVerifyResult(skuForEsBO.getBrandVerifyResult());
            esStorageSpuInfoBO.setMaterial_type(skuForEsBO.getMaterialType());
            esStorageSpuInfoBO.setBrand_verify(skuForEsBO.getBrandVerify());
            esStorageSpuInfoBO.setCommodity_id(skuForEsBO.getCommodityId());
            esStorageSpuInfoBO.setSku_id(skuForEsBO.getSkuId());
            esStorageSpuInfoBO.setSku_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setSearch_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setExt_sku_id(skuForEsBO.getExtSkuId());
            esStorageSpuInfoBO.setSell(skuForEsBO.getSell());
            esStorageSpuInfoBO.setBrand_id(skuForEsBO.getBrandId());
            esStorageSpuInfoBO.setBrand_name(skuForEsBO.getBrandName());
            esStorageSpuInfoBO.setSku_status(skuForEsBO.getSkuStatus());
            esStorageSpuInfoBO.setUp_count(skuForEsBO.getUpCount());
            esStorageSpuInfoBO.setSku_source(skuForEsBO.getSkuSource());
            esStorageSpuInfoBO.setMfgsku(skuForEsBO.getMfgsku());
            esStorageSpuInfoBO.setUpc(skuForEsBO.getUpcCode());
            esStorageSpuInfoBO.setType_id(skuForEsBO.getCommodityTypeId());
            esStorageSpuInfoBO.setType_name(skuForEsBO.getCommodityTypeName());
            esStorageSpuInfoBO.setAgreement_id(skuForEsBO.getAgreementId());
            esStorageSpuInfoBO.setAgreement_details_id(skuForEsBO.getAgreementDetailsId());
            esStorageSpuInfoBO.setSale_price(skuForEsBO.getSalePrice() == null ? 0.0 : (double)skuForEsBO.getSalePrice().longValue());
            esStorageSpuInfoBO.setAgreement_price(skuForEsBO.getAgreementPrice() == null ? 0.0 : (double)skuForEsBO.getAgreementPrice().longValue());
            esStorageSpuInfoBO.setMarket_price(skuForEsBO.getMarketPrice() == null ? 0.0 : (double)skuForEsBO.getMarketPrice().longValue());
            esStorageSpuInfoBO.setMember_price1(skuForEsBO.getMemberPrice1() == null ? 0.0 : (double)skuForEsBO.getMemberPrice1().longValue());
            esStorageSpuInfoBO.setMember_price2(skuForEsBO.getMemberPrice2() == null ? 0.0 : (double)skuForEsBO.getMemberPrice2().longValue());
            esStorageSpuInfoBO.setMember_price3(skuForEsBO.getMemberPrice3() == null ? 0.0 : (double)skuForEsBO.getMemberPrice3().longValue());
            esStorageSpuInfoBO.setMember_price4(skuForEsBO.getMemberPrice4() == null ? 0.0 : (double)skuForEsBO.getMemberPrice4().longValue());
            esStorageSpuInfoBO.setMember_price5(skuForEsBO.getMemberPrice5() == null ? 0.0 : (double)skuForEsBO.getMemberPrice5().longValue());
            esStorageSpuInfoBO.setSupplier_id(skuForEsBO.getSupplierId());
            esStorageSpuInfoBO.setSupplier_shop_id(skuForEsBO.getSupplierShopId());
            esStorageSpuInfoBO.setShop_name(skuForEsBO.getShopName());
            esStorageSpuInfoBO.setSupplier_name(skuForEsBO.getSupplierName());
            esStorageSpuInfoBO.setClassify_manager(skuForEsBO.getClassifyManager());
            esStorageSpuInfoBO.setE_category_flag(skuForEsBO.getECategoryFlag());
            String discount = "0";
            if (skuForEsBO.getAgreementPrice() != null && skuForEsBO.getMarketPrice() != null && skuForEsBO.getMarketPrice() != 0L) {
                BigDecimal bigDecimal = new BigDecimal(skuForEsBO.getAgreementPrice()).divide(new BigDecimal(skuForEsBO.getMarketPrice()), Integer.parseInt(this.digit), RoundingMode.DOWN);
                discount = bigDecimal.toString();
            }
            esStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            esStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (stockNum = skuStockPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setComment_number(stockNum);
            }
            esStorageSpuInfoBO.setSold_number(null);
            esStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(skuForEsBO.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    esStorageSpuInfoBO.setSold_number(uccSaleNumPo.getSoldNumber().longValue());
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    esStorageSpuInfoBO.setEcommerce_sale(uccSaleNumPo.getEcommerceSale().longValue());
                }
            }
            if (skuPicPoMap.size() > 0) {
                UccSkuPicPo uccSkuPicPo = skuPicPoMap.get(skuForEsBO.getSkuId());
                if (uccSkuPicPo != null) {
                    esStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
                } else {
                    esStorageSpuInfoBO.setPicture_url(null);
                }
            } else {
                esStorageSpuInfoBO.setPicture_url(null);
            }
            if (!agrWhite.isEmpty() && agrWhite.containsKey(skuForEsBO.getAgreementId())) {
                esStorageSpuInfoBO.setWhitelist(agrWhite.get(skuForEsBO.getAgreementId()));
            }
            esStorageSpuInfoBO.setChannel_id(null);
            esStorageSpuInfoBO.setBrand_id_name(null);
            esStorageSpuInfoBO.setDescription(null);
            esStorageSpuInfoBO.setSupplier_id_name(null);
            esStorageSpuInfoBO.setProperties(null);
            esStorageSpuInfoBO.setL4mg_category_id(skuForEsBO.getMgCatalogId());
            esStorageSpuInfoBO.setL4mg_category_name(skuForEsBO.getMgCatalogName());
            esStorageSpuInfoBO.setMaterial_id(skuForEsBO.getMaterialId());
            if (!StringUtils.isEmpty((CharSequence)skuForEsBO.getMaterialName())) {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getMaterialName());
            } else {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getOrgMaterialName());
            }
            esStorageSpuInfoBO.setMaterial_code(skuForEsBO.getMaterialCode());
            esStorageSpuInfoBO.setLong_desc(skuForEsBO.getLongDesc());
            esStorageSpuInfoBO.setRecommMaterialLongDesc(skuForEsBO.getLongDesc());
            esStorageSpuInfoBO.setModel(skuForEsBO.getModel());
            esStorageSpuInfoBO.setSpec(skuForEsBO.getSpec());
            esStorageSpuInfoBO.setMeasure_name(skuForEsBO.getMeasure());
            esStorageSpuInfoBO.setMeasure_id(skuForEsBO.getMeasureId());
            esStorageSpuInfoBO.setOrigin_brand_id(skuForEsBO.getOriginBrandId());
            esStorageSpuInfoBO.setOrigin_brand_name(skuForEsBO.getOriginBrandName());
            esStorageSpuInfoBO.setInsert_time(System.currentTimeMillis());
            esStorageSpuInfoBO.setSku_code(skuForEsBO.getSkuCode());
            esStorageSpuInfoBO.setSku_approval_status(skuForEsBO.getApprovalStatus());
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSupplierShopId(skuForEsBO.getSupplierShopId());
            uccSkuPo.setSkuId(skuForEsBO.getSkuId());
            if (skuForEsBO.getDownTime() != null) {
                esStorageSpuInfoBO.setDown_time(skuForEsBO.getDownTime().getTime());
            }
            if (skuForEsBO.getOnShelveTime() != null) {
                LOGGER.info(skuForEsBO.getOnShelveTime());
                LOGGER.info("" + DateUtils.strToDate((String)skuForEsBO.getOnShelveTime()));
                esStorageSpuInfoBO.setUp_time(DateUtils.strToDate((String)skuForEsBO.getOnShelveTime()).getTime());
                esStorageSpuInfoBO.setOn_shelve_time(esStorageSpuInfoBO.getUp_time());
                try {
                    esStorageSpuInfoBO.setUp_time(DateUtils.strToDateLong((String)skuForEsBO.getOnShelveTime()).getTime());
                    esStorageSpuInfoBO.setOn_shelve_time(esStorageSpuInfoBO.getUp_time());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            esStorageSpuInfoBO.setSupplier_org_id(skuForEsBO.getSupplierOrgId());
            esStorageSpuInfoBO.setSupplier_org_name(skuForEsBO.getSupplierOrgName());
            esStorageSpuInfoBO.setCreate_oper_id(skuForEsBO.getCreateOperId());
            esStorageSpuInfoBO.setCreate_oper_name(skuForEsBO.getCreateOperName());
            esStorageSpuInfoBO.setUpdate_oper_id(skuForEsBO.getUpdateOperId());
            esStorageSpuInfoBO.setUpdate_oper_name(skuForEsBO.getUpdateOperName());
            esStorageSpuInfoBO.setSwitch_on(skuForEsBO.getSwitchOn());
            esStorageSpuInfoBO.setLadderPrice(skuForEsBO.getLadderPrice());
            if (skuForEsBO.getCreateTime() != null) {
                esStorageSpuInfoBO.setCreate_time(skuForEsBO.getCreateTime().getTime());
            }
            if (skuForEsBO.getUpdateTime() != null) {
                esStorageSpuInfoBO.setUpdate_time(skuForEsBO.getUpdateTime().getTime());
            }
            esStorageSpuInfoBO.setMoq(skuForEsBO.getMoq());
            esStorageSpuInfoBO.setSales_unit_id(skuForEsBO.getSalesUnitId());
            esStorageSpuInfoBO.setSales_unit_name(skuForEsBO.getSalesUnitName());
            if (skuForEsBO.getPreDeliverDay() != null) {
                esStorageSpuInfoBO.setPre_deliver_day(new BigDecimal(skuForEsBO.getPreDeliverDay()));
            }
            esStorageSpuInfoBO.setSettlement_unit(skuForEsBO.getSettlementUnit());
            esStorageSpuInfoBO.setSkuAddPrice(skuForEsBO.getSkuAddPrice());
            UccRelCatalogBrandVendorPoolPO qryPo = new UccRelCatalogBrandVendorPoolPO();
            qryPo.setStatus(1);
            qryPo.setBrandId(skuForEsBO.getBrandId());
            qryPo.setVendorId(skuForEsBO.getSupplierShopId());
            qryPo.setCatalogId(skuForEsBO.getMgCatalogId());
            List<UccRelCatalogBrandVendorPoolPO> uccRelCatalogBrandVendorPoolPOS = this.uccRelCatalogBrandVendorPoolMapper.qryByCatalogBrandVendor(qryPo);
            if (!CollectionUtils.isEmpty(uccRelCatalogBrandVendorPoolPOS)) {
                List<Long> relIdList = uccRelCatalogBrandVendorPoolPOS.stream().map(UccRelCatalogBrandVendorPoolPO::getRelId).collect(Collectors.toList());
                esStorageSpuInfoBO.setBrandCataLogVendorId(relIdList);
            } else {
                esStorageSpuInfoBO.setBrandCataLogVendorId(Lists.newArrayList());
            }
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<CommodityForEsBO> commodityForEsBOS) {
        Map<Long, CommodityForEsBO> commodityEsBOMap = commodityForEsBOS.stream().collect(Collectors.toMap(CommodityForEsBO::getCommodityId, commodityForEsBO -> commodityForEsBO));
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (CommodityForEsBO each : commodityForEsBOS) {
            if (CollectionUtils.isEmpty(each.getGuideCataLogIds())) continue;
            guiCataLog.addAll(each.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<Object> catalogLevelPos = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(guiCataLog)) {
            catalogLevelPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog);
        }
        List commoditySpecForEsBOS = new ArrayList();
        List<CommoditySpecForEsPO> specForEsPOS = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getSupplierId());
        if (!CollectionUtils.isEmpty(specForEsPOS)) {
            commoditySpecForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(specForEsPOS), CommoditySpecForEsBO.class);
        }
        Map<Long, CommoditySpecForEsBO> commoditySpecForEsBOMap = commoditySpecForEsBOS.stream().collect(Collectors.toMap(CommoditySpecForEsBO::getCommodityId, commoditySpecForEsBO -> commoditySpecForEsBO));
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            CommoditySpecForEsBO commoditySpecForEsBO2;
            CommodityForEsBO commodityForEsBO2 = commodityEsBOMap.get(esStorageSpuInfoBO.getCommodity_id());
            esStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            esStorageSpuInfoBO.setCommodity_name(commodityForEsBO2.getCommodityName());
            esStorageSpuInfoBO.setAssist_dist_code(commodityForEsBO2.getAssistDistCode());
            esStorageSpuInfoBO.setAssist_dist_name(commodityForEsBO2.getAssistDistName());
            esStorageSpuInfoBO.setCommodity_status(commodityForEsBO2.getCommodityStatus());
            esStorageSpuInfoBO.setCommd_pic_url(commodityForEsBO2.getCommodityPicUrl());
            esStorageSpuInfoBO.setOnShelveWay(commodityForEsBO2.getOnShelveWay());
            if (!Objects.isNull(commodityForEsBO2.getHide())) {
                esStorageSpuInfoBO.setHide(commodityForEsBO2.getHide());
            }
            if (!CollectionUtils.isEmpty(commodityForEsBO2.getGuideCataLogIds())) {
                esStorageSpuInfoBO.setL3_category_id(commodityForEsBO2.getGuideCataLogIds().stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            esStorageSpuInfoBO.setVendor_id(commodityForEsBO2.getVendorId());
            esStorageSpuInfoBO.setVendor_name(commodityForEsBO2.getVendorName());
            if (StringUtils.isEmpty((CharSequence)esStorageSpuInfoBO.getPicture_url())) {
                esStorageSpuInfoBO.setPicture_url(commodityForEsBO2.getCommodityPicUrl());
            }
            esStorageSpuInfoBO.setView_order(commodityForEsBO2.getViewOrder());
            esStorageSpuInfoBO.setOther_source_name(commodityForEsBO2.getOtherSourceName());
            esStorageSpuInfoBO.setOther_source_id(commodityForEsBO2.getOtherSourceId());
            esStorageSpuInfoBO.setOther_source_code(commodityForEsBO2.getOtherSourceCode());
            esStorageSpuInfoBO.setTaxRate(commodityForEsBO2.getTaxRate());
            esStorageSpuInfoBO.setTaxCode(commodityForEsBO2.getTaxCatCode());
            esStorageSpuInfoBO.setSpu_approval_status(commodityForEsBO2.getApprovalStatus());
            esStorageSpuInfoBO.setCommodity_code(commodityForEsBO2.getCommodityCode());
            esStorageSpuInfoBO.setExt_spu_id(commodityForEsBO2.getExtSpuId());
            esStorageSpuInfoBO.setCommodity_expand1(commodityForEsBO2.getCommodityExpand1());
            esStorageSpuInfoBO.setShow_prop_json(null);
            if (!CollectionUtils.isEmpty(catalogLevelPos) && !CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_id())) {
                for (UccCatalogLevelPo uccCatalogLevelPo : catalogLevelPos) {
                    for (String l3_category_id : esStorageSpuInfoBO.getL3_category_id()) {
                        if (!uccCatalogLevelPo.getL3GuideCatalogId().equals(Long.valueOf(l3_category_id))) continue;
                        if (uccCatalogLevelPo.getL1GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_id())) {
                                esStorageSpuInfoBO.setL1_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_id().contains(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL1_category_id().add(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()));
                            }
                        }
                        if (uccCatalogLevelPo.getL2GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_id())) {
                                esStorageSpuInfoBO.setL2_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_id().contains(String.valueOf(uccCatalogLevelPo.getL2GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL2_category_id().add(uccCatalogLevelPo.getL2GuideCatalogId().toString());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL1CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_name())) {
                                esStorageSpuInfoBO.setL1_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_name().contains(uccCatalogLevelPo.getL1CatalogName())) {
                                esStorageSpuInfoBO.getL1_category_name().add(uccCatalogLevelPo.getL1CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL2CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_name())) {
                                esStorageSpuInfoBO.setL2_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_name().contains(uccCatalogLevelPo.getL2CatalogName())) {
                                esStorageSpuInfoBO.getL2_category_name().add(uccCatalogLevelPo.getL2CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL3CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_name())) {
                                esStorageSpuInfoBO.setL3_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL3CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL3_category_name().contains(uccCatalogLevelPo.getL3CatalogName())) {
                                esStorageSpuInfoBO.getL3_category_name().add(uccCatalogLevelPo.getL3CatalogName());
                            }
                        }
                        if (uccCatalogLevelPo.getChannelId() == null) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                            esStorageSpuInfoBO.setChannel_id(Lists.newArrayList((Object[])new Long[]{uccCatalogLevelPo.getChannelId()}));
                            esStorageSpuInfoBO.setChannel_Name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getChannelName()}));
                            continue;
                        }
                        if (!esStorageSpuInfoBO.getChannel_id().contains(uccCatalogLevelPo.getChannelId())) {
                            esStorageSpuInfoBO.getChannel_id().add(uccCatalogLevelPo.getChannelId());
                        }
                        if (esStorageSpuInfoBO.getChannel_Name().contains(uccCatalogLevelPo.getChannelName())) continue;
                        esStorageSpuInfoBO.getChannel_Name().add(uccCatalogLevelPo.getChannelName());
                    }
                }
            }
            if (commoditySpecForEsBOMap.size() > 0 && (commoditySpecForEsBO2 = commoditySpecForEsBOMap.get(esStorageSpuInfoBO.getCommodity_id())) != null) {
                esStorageSpuInfoBO.setShow_prop_json(commoditySpecForEsBO2.getPropJson());
            }
            Integer dataGovernFlag = null;
            List<UccEMdmCatalogPO> list = this.uccEMdmCatalogMapper.qryUccEMdmCatalogBySkuId(esStorageSpuInfoBO.getSku_id());
            if (!CollectionUtils.isEmpty(list)) {
                dataGovernFlag = list.get(0).getDataGovernFlag();
            }
            if (dataGovernFlag != null && dataGovernFlag == 1) {
                String dataGovernProperties = this.uccSpuSpecMapper.getSkuDataGovernProperties(esStorageSpuInfoBO.getSku_id());
                if (!StringUtils.isEmpty((CharSequence)dataGovernProperties)) {
                    esStorageSpuInfoBO.setProperties(dataGovernProperties);
                }
            } else {
                String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esStorageSpuInfoBO.getSku_id());
                esStorageSpuInfoBO.setProperties(properties);
            }
            esStorageSpuInfoBO.setUnuse_suppliershop_list(null);
            esStorageSpuInfoBO.setBelongModule(commodityForEsBO2.getBelongModule());
            esStorageSpuInfoBO.setRunMainBodyId(commodityForEsBO2.getRunMainBodyId());
            esStorageSpuInfoBO.setRunMainBodyName(commodityForEsBO2.getRunMainBodyName());
            esStorageSpuInfoBO.setIsSupermarketStaff(commodityForEsBO2.getIsSupermarketStaff());
            if (esStorageSpuInfoBO.getSupplier_id() != null && (this.jdIdFl.equals(esStorageSpuInfoBO.getSupplier_id().toString()) || this.snIdFl.equals(esStorageSpuInfoBO.getSupplier_id().toString()))) {
                esStorageSpuInfoBO.setIsSupermarketStaff(1);
            }
            esStorageSpuInfoBO.setTradeMode(commodityForEsBO2.getTradeMode());
            esStorageSpuInfoBO.setMarketingFlag(commodityForEsBO2.getMarketingFlag());
        }
    }

    private CommodityCategoryForEsBO assemblyCategoryInfo(CommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        CommodityCategoryForEsBO finalSpuCategoryForEsBO = new CommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private CommodityCategoryForEsBO mergeChildAndParentCategory(CommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        CommodityCategoryForEsBO finalCategory = new CommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog(childCategory);
        return finalCategory;
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        this.dealPush1(esStorageSpuInfoBOS);
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = esStorageSpuInfoBO.getScene_id() == null ? String.valueOf(esStorageSpuInfoBO.getSku_id()) : esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            String SceneId = Objects.nonNull(esStorageSpuInfoBO.getScene_id()) ? esStorageSpuInfoBO.getScene_id() + "" : "";
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + SceneId + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
        List skuIds = esStorageSpuInfoBOS.stream().map(EsStorageSpuInfoBO::getSku_id).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuIds)) {
            SyncSceneStandardCommodityToEsAbilityReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsAbilityReqBO();
            syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
            syncSceneStandardCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneStandardCommodityToEsReqBO.setSyncScene(UccConstants.StandardSyncEsScene.Sku);
            SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneStandardCommodityToEsAbilityService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
        }
    }

    private void syncCommodityAttrToEs(List<EsStorageSpuAttrInfoBO> attrInfoBOS) {
        if (CollectionUtils.isEmpty(attrInfoBOS)) {
            return;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (EsStorageSpuAttrInfoBO each : attrInfoBOS) {
            JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)each));
            list.add((Map<String, Object>)map);
        }
        this.elasticsearchUtil.bulkPutIndex(this.esConfig.getPropIndexName(), this.esConfig.getPropIndexType(), list, "spec_id");
    }

    private void deleteSpuInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            for (Long each : reqBO.getCommodityIds()) {
                JSONObject delConditionOrderJson = new JSONObject();
                delConditionOrderJson.put("commodity_id", (Object)String.valueOf(each));
                JSONObject termOrderJson = new JSONObject();
                termOrderJson.put("term", (Object)delConditionOrderJson);
                JSONObject termAfsJson = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)termOrderJson);
                JSONObject mustJson = new JSONObject();
                mustJson.put("must", (Object)jsonArray);
                JSONObject boolJson = new JSONObject();
                boolJson.put("bool", (Object)mustJson);
                JSONObject qryJson = new JSONObject();
                qryJson.put("query", (Object)boolJson);
                String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
                Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
                if (deleteResult.booleanValue()) continue;
                LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + each + "]\u5220\u9664\u5931\u8d25!");
            }
        } else if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            for (Long each : reqBO.getSkuIds()) {
                JSONObject delConditionOrderJson = new JSONObject();
                delConditionOrderJson.put("sku_id", (Object)String.valueOf(each));
                JSONObject termOrderJson = new JSONObject();
                termOrderJson.put("term", (Object)delConditionOrderJson);
                JSONObject termAfsJson = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)termOrderJson);
                JSONObject mustJson = new JSONObject();
                mustJson.put("must", (Object)jsonArray);
                JSONObject boolJson = new JSONObject();
                boolJson.put("bool", (Object)mustJson);
                JSONObject qryJson = new JSONObject();
                qryJson.put("query", (Object)boolJson);
                String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
                Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
                if (deleteResult.booleanValue()) continue;
                LOGGER.error("\u5355\u54c1\u4fe1\u606f[" + each + "]\u5220\u9664\u5931\u8d25!");
            }
        } else {
            LOGGER.error("\u5220\u9664ES \u6570\u636e\u672a\u77e5\u7684\u5904\u7406\u7c7b\u578b" + JSONObject.toJSONString((Object)reqBO));
        }
    }

    public void searchSku(SyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            return;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGuiCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByGuiCataLogs(reqBO.getGuiCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCataLogs(reqBO.getCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty(skuPoList)) {
            reqBO.setSkuIds(skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
    }

    private List<EsStorageSpuAttrInfoBO> assemblyCommodityAttrInfo(List<Long> commodityIds) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return new ArrayList<EsStorageSpuAttrInfoBO>();
        }
        return JSONObject.parseArray((String)JSONObject.toJSONString(this.uccSpuSpecMapper.qryEsAttrList(commodityIds)), EsStorageSpuAttrInfoBO.class);
    }

    private void validateReqParams(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getGuiCategoryIds() == null || reqBO.getGuiCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getSpuEsForActivityBOS() == null || reqBO.getSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType()) && (reqBO.getSkuIds() == null || reqBO.getSkuIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u5355\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void syncSkuPoolToES(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS) || CollectionUtils.isEmpty(commodityIds)) {
            return;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySkuForPool(reqBO.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u6c60\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        uccSkuPos.forEach(s -> s.setBrandCataLogVendorId(this.uccSkuMapper.qryCatalogBrandVendorPoolId(s.getSkuId())));
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agrIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<Long> spuIds = new ArrayList<Long>();
        ArrayList<Long> brandCataLogVendorId = new ArrayList<Long>();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId())) {
                spuIds.add(each.getCommodityId());
            }
            if (CollectionUtils.isEmpty((Collection)brandCataLogVendorId)) {
                each.getBrandCataLogVendorId().forEach(b -> brandCataLogVendorId.add((Long)b));
            }
        });
        List<Object> uccRelPoolCommodityPosBySku = new ArrayList();
        if (!CollectionUtils.isEmpty(skuIds)) {
            uccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPools(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        List<Object> uccRelPoolCommodityPosByType = new ArrayList();
        if (!CollectionUtils.isEmpty(typeIds)) {
            uccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPools(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        List<Object> uccRelPoolCommodityPosByVendor = new ArrayList();
        if (!CollectionUtils.isEmpty(vendorIds)) {
            uccRelPoolCommodityPosByVendor = this.uccRelPoolCommodityMapper.queryPools(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        List<Object> uccRelPoolCommodityPosByAgr = new ArrayList();
        if (!CollectionUtils.isEmpty(agrIds)) {
            uccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPools(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        List<Object> uccRelPoolCommodityPosBySpu = new ArrayList();
        if (!CollectionUtils.isEmpty(spuIds)) {
            uccRelPoolCommodityPosBySpu = this.uccRelPoolCommodityMapper.queryPools(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        List<Object> uccRelPoolCommodityPosBybrandCataLogVendor = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(brandCataLogVendorId)) {
            uccRelPoolCommodityPosBybrandCataLogVendor = this.uccRelPoolCommodityMapper.queryPools(brandCataLogVendorId, SkuPoolRelTypeConstant.REL_BY_BRANDCATALOGVENDOR);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosBySku)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySku) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getSku_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByType)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByType) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getType_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByVendor)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByVendor) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getVendor_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByAgr)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByAgr) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getAgreement_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosBySpu)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySpu) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getCommodity_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (CollectionUtils.isEmpty(uccRelPoolCommodityPosBybrandCataLogVendor)) continue;
            for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBybrandCataLogVendor) {
                if (!esStorageSpuInfoBO.getBrandCataLogVendorId().contains(uccRelPoolCommodityPo.getSource())) continue;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                    esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                    continue;
                }
                esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
            }
        }
    }

    private void applrovalCommodityToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        Map<Long, List<UocSpuApproverPO>> approvar;
        List<UocSpuApproverPO> approvers;
        ArrayList<Long> skus = new ArrayList<Long>();
        HashSet spus = new HashSet();
        esStorageSpuInfoBOS.forEach(bo -> {
            if (ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO.equals(bo.getSku_approval_status()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.equals(bo.getSku_approval_status()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(bo.getSku_approval_status()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.equals(bo.getSku_approval_status())) {
                skus.add(bo.getSku_id());
            } else if (ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(bo.getSku_approval_status())) {
                spus.add(bo.getCommodity_id());
            }
        });
        if (!skus.isEmpty() && !CollectionUtils.isEmpty(approvers = this.uocApprovalObjMapper.querySpuApprover(skus, null))) {
            approvar = approvers.stream().collect(Collectors.groupingBy(UocSpuApproverPO::getObjId));
            esStorageSpuInfoBOS.forEach(bo -> {
                if (approvar.containsKey(bo.getSku_id())) {
                    bo.setOperIds(((List)approvar.get(bo.getSku_id())).stream().map(UocSpuApproverPO::getOperId).collect(Collectors.toList()));
                    bo.setAudit_time(((UocSpuApproverPO)((List)approvar.get(bo.getSku_id())).get(0)).getCreateTime().getTime());
                }
            });
        }
        if (skus.isEmpty()) {
            esStorageSpuInfoBOS.forEach(bo -> {
                bo.setOperIds(null);
                bo.setAudit_time(null);
            });
        }
        if (!spus.isEmpty() && !CollectionUtils.isEmpty(approvers = this.uocApprovalObjMapper.querySpuApprover(new ArrayList<Long>(spus), null))) {
            approvar = approvers.stream().collect(Collectors.groupingBy(UocSpuApproverPO::getObjId));
            esStorageSpuInfoBOS.forEach(bo -> {
                if (approvar.containsKey(bo.getCommodity_id())) {
                    bo.setOperIds(((List)approvar.get(bo.getCommodity_id())).stream().map(UocSpuApproverPO::getOperId).collect(Collectors.toList()));
                    bo.setAudit_time(((UocSpuApproverPO)((List)approvar.get(bo.getCommodity_id())).get(0)).getCreateTime().getTime());
                }
            });
        }
    }

    private void dealLable(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        ArrayList<Long> skuPoos = new ArrayList<Long>();
        esStorageSpuInfoBOS.stream().filter(s -> !CollectionUtils.isEmpty(s.getSkuPoolIds())).forEach(item -> skuPoos.addAll(item.getSkuPoolIds()));
        if (CollectionUtils.isEmpty(skuPoos)) {
            return;
        }
        List<UccRelCommodityLabelPoolPo> cnncRelCommodityLabelPoolPos = this.cnncRelCommodityLaberPoolMapper.queryAllInfoByPoolList(skuPoos);
        if (CollectionUtils.isEmpty(cnncRelCommodityLabelPoolPos)) {
            return;
        }
        HashSet lableList = new HashSet();
        cnncRelCommodityLabelPoolPos.stream().forEach(item -> lableList.add(item.getLabelId()));
        List<UccCommodityLabelPo> labelPos = this.cnncCommodityLabelMapper.selectLabel(null, new ArrayList<Long>(skuPoos));
        if (CollectionUtils.isEmpty(labelPos)) {
            LOGGER.error("\u5546\u54c1\u540c\u6b65es \uff0c\u6807\u7b7e\u4e0d\u5b58\u5728" + lableList);
            return;
        }
        Map<Long, UccCommodityLabelPo> labelMap = labelPos.stream().collect(Collectors.toMap(UccCommodityLabelPo::getLabelId, CnncCommodityLabelPo -> CnncCommodityLabelPo, (a, b) -> a));
        Map<Long, List<UccRelCommodityLabelPoolPo>> groupByPools = cnncRelCommodityLabelPoolPos.stream().collect(Collectors.groupingBy(UccRelCommodityLabelPoolPo::getPoolId));
        HashMap<Long, UccPoolsLableBo> poolsLableDetailMap = new HashMap<Long, UccPoolsLableBo>();
        for (Map.Entry<Long, List<UccRelCommodityLabelPoolPo>> entry : groupByPools.entrySet()) {
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            UccPoolsLableBo uccPoolsLableBo = new UccPoolsLableBo();
            uccPoolsLableBo.setPoolId(entry.getKey());
            for (UccRelCommodityLabelPoolPo relCommodityLabelPoolPo : entry.getValue()) {
                if (!labelMap.containsKey(relCommodityLabelPoolPo.getLabelId())) continue;
                labelIds.add(relCommodityLabelPoolPo.getLabelId());
                labelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
                if (relCommodityLabelPoolPo.getIsShow() != 1) continue;
                showLabelIds.add(relCommodityLabelPoolPo.getLabelId());
                showLabelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
            }
            uccPoolsLableBo.setLabelIds(new ArrayList<Long>(labelIds));
            uccPoolsLableBo.setLabelNames(new ArrayList<String>(labelNames));
            uccPoolsLableBo.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            uccPoolsLableBo.setShowLabelNames(new ArrayList<String>(showLabelNames));
            poolsLableDetailMap.put(entry.getKey(), uccPoolsLableBo);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) continue;
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            for (Long pool : esStorageSpuInfoBO.getSkuPoolIds()) {
                if (poolsLableDetailMap.containsKey(pool)) {
                    labelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelIds());
                    showLabelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelIds());
                    labelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelNames());
                    showLabelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelNames());
                    continue;
                }
                LOGGER.error("\u672a\u5339\u914d\u5230\u5546\u54c1\u6c60\u8be6\u60c5\u6570\u636e\uff1a" + pool);
            }
            esStorageSpuInfoBO.setLabelIds(new ArrayList<Long>(labelIds));
            esStorageSpuInfoBO.setLabelNames(new ArrayList<String>(labelNames));
            esStorageSpuInfoBO.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            esStorageSpuInfoBO.setShowLabelNames(new ArrayList<String>(showLabelNames));
        }
    }

    private void dealChannel(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            List<UccRelChannelPoolPo> uccRelChannelPoolPos;
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                List<UccRelChannelPoolPo> uccRelChannelPoolPos2;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos2 = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
                List channelIdList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_id(channelIdList);
                List<String> channelNameList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelName()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_Name(channelNameList);
                continue;
            }
            ArrayList<Long> channelIdLists = new ArrayList<Long>();
            channelIdLists.addAll(esStorageSpuInfoBO.getChannel_id());
            for (Long each : esStorageSpuInfoBO.getChannel_id()) {
                UccChannelDealPO uccChannelDealPO = new UccChannelDealPO();
                uccChannelDealPO.setChannelId(each);
                uccChannelDealPO.setRelatedType(1);
                List<UccChannelDealPO> uccChannelDealPOList = this.uccChannelDealMapper.selectByChannelCode(uccChannelDealPO);
                if (CollectionUtils.isEmpty(uccChannelDealPOList)) continue;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                    channelIdLists.remove(each);
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    continue;
                }
                List<UccRelChannelPoolPo> uccRelChannelPoolPos3 = this.uccRelChannelPoolMapper.getRelListByChannelIds(Lists.newArrayList((Object[])new Long[]{uccChannelDealPOList.get(0).getChannelId()}));
                if (CollectionUtils.isEmpty(uccRelChannelPoolPos3)) {
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    channelIdLists.remove(each);
                    continue;
                }
                boolean contain = false;
                for (UccRelChannelPoolPo uccRelChannelPoolPo : uccRelChannelPoolPos3) {
                    if (!esStorageSpuInfoBO.getSkuPoolIds().contains(uccRelChannelPoolPo.getPoolId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                channelIdLists.remove(each);
                esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
            }
            esStorageSpuInfoBO.setChannel_id(channelIdLists);
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
            List channelIdList = uccRelChannelPoolPos.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
            Map<Long, String> channelMap = uccRelChannelPoolPos.stream().collect(Collectors.toMap(a -> a.getChannelId(), b -> b.getChannelName(), (oldValue, newValue) -> newValue));
            for (Long each : channelIdList) {
                if (esStorageSpuInfoBO.getChannel_id().contains(each)) continue;
                esStorageSpuInfoBO.getChannel_id().add(each);
                esStorageSpuInfoBO.getChannel_Name().add(channelMap.get(each));
            }
        }
    }

    private void syncActiveToSkuEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        List<Long> skuIds = esStorageSpuInfoBOS.stream().map(a -> a.getSku_id()).distinct().collect(Collectors.toList());
        WelfareActiveSkuPO welfareActiveSkuPO = new WelfareActiveSkuPO();
        welfareActiveSkuPO.setSkuIds(skuIds);
        List<WelfareActiveSkuPO> welfareActiveSkuPOS = this.welfareActiveSkuMapper.getList(welfareActiveSkuPO);
        if (!CollectionUtils.isEmpty(welfareActiveSkuPOS)) {
            Map<Long, List<WelfareActiveSkuPO>> skuActiveMap = welfareActiveSkuPOS.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
            HashMap skuActiveIdMap = new HashMap();
            for (Map.Entry<Long, List<WelfareActiveSkuPO>> each : skuActiveMap.entrySet()) {
                List activeIds = each.getValue().stream().map(a -> a.getActiveId()).distinct().collect(Collectors.toList());
                skuActiveIdMap.put(each.getKey(), activeIds);
            }
            for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
                if (esStorageSpuInfoBO.getSku_id() == null) continue;
                esStorageSpuInfoBO.setActiveIds((List)skuActiveIdMap.get(esStorageSpuInfoBO.getSku_id()));
            }
        }
    }

    private void checkMallBrand(List<SkuForEsBO> skuForEsBOS) {
        if (CollectionUtils.isEmpty(skuForEsBOS)) {
            return;
        }
        List<Long> skuIds = skuForEsBOS.stream().filter(a -> a.getSkuSource() != null && a.getSkuSource() == 2).map(a -> a.getSkuId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List<UccSkuBrandPo> uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrand(skuIds);
        Map<Object, Object> skuBrandMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuBrandPos)) {
            skuBrandMap = uccSkuBrandPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (a, b) -> a));
        }
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            if (skuForEsBO.getSkuSource() == null || skuForEsBO.getSkuSource() != 2) continue;
            if (skuForEsBO.getBrandVerify() != null && skuForEsBO.getBrandVerify() == 1) {
                UccSkuBrandPo skuBrandPo = (UccSkuBrandPo)skuBrandMap.get(skuForEsBO.getSkuId());
                if (skuBrandPo == null || skuBrandPo.getBrandId() == null) {
                    skuForEsBO.setBrandVerifyResult(3);
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getBrandStatus() != 1) {
                    if (skuBrandPo.getBrandStatus() == 2) {
                        skuForEsBO.setBrandVerifyResult(3);
                        skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                        continue;
                    }
                    log.error("\u54c1\u724cID\uff1a" + skuBrandPo.getBrandId() + "\u54c1\u724c\u72b6\u6001\u4e3a\uff1a" + skuBrandPo.getBrandStatus());
                    skuForEsBO.setBrandVerifyResult(2);
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getAppRange() == null || skuBrandPo.getAppRange() == 2) {
                    skuForEsBO.setBrandVerifyResult(2);
                    log.error("\u54c1\u724cID\uff1a" + skuBrandPo.getBrandId() + "\u8303\u56f4\u662f\u5426\u4e3a\u7a7a\uff1a" + skuBrandPo.getAppRange() + "\u8303\u56f4\u662f\u5426\u4e3a2\uff1a" + skuBrandPo.getAppRange());
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u5e94\u7528\u8303\u56f4\u4e3a\u975e\u7535\u5546\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u66f4\u6539\u5e94\u7528\u8303\u56f4\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                uccRelCatalogBrandVendorPO.setCatalogId(skuForEsBO.getMgCatalogId());
                uccRelCatalogBrandVendorPO.setBrandId(skuBrandPo.getBrandId());
                uccRelCatalogBrandVendorPO.setVendorId(skuForEsBO.getSupplierShopId());
                uccRelCatalogBrandVendorPO.setDiscountFlag(0);
                List<UccRelCatalogBrandVendorPO> uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                if (CollectionUtils.isEmpty(uccRelCatalogBrandVendorPOS)) {
                    log.error("ES\u67e5\u8be2\u5173\u8054\u5165\u53c2\u662f\u5426\u4e3a\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b\uff1a" + JSON.toJSONString((Object)uccRelCatalogBrandVendorPO));
                    log.error("ES\u67e5\u8be2\u8fd4\u53c2\u662f\u5426\u4e3a\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b \uff1a" + JSON.toJSONString(uccRelCatalogBrandVendorPOS));
                    skuForEsBO.setBrandVerifyResult(2);
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u8be5\u4f9b\u5e94\u5546\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u8be5\u54c1\u724c\u505a\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (uccRelCatalogBrandVendorPOS.get(0).getStatus() == null || uccRelCatalogBrandVendorPOS.get(0).getStatus() != 1) {
                    skuForEsBO.setBrandVerifyResult(2);
                    log.error("\u67e5\u8be2\u5173\u8054\u5165\u53c2\u662f\u5426\u4e3a\u7a7a \uff1a" + JSON.toJSONString((Object)uccRelCatalogBrandVendorPO));
                    log.error("\u67e5\u8be2\u5173\u8054\u8fd4\u53c2\u662f\u5426\u4e3a\u7a7a \uff1a" + JSON.toJSONString(uccRelCatalogBrandVendorPOS));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u4f9b\u5e94\u5546\u5546\u54c1\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u54c1\u724c\u5173\u8054\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                skuForEsBO.setBrandVerifyResult(1);
                continue;
            }
            skuForEsBO.setBrandVerifyResult(0);
        }
    }

    private void checkDiscountLimitValue(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        if (CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getSkuIds())) {
            return;
        }
        List skuIds = syncSceneCommodityToEsReqBO.getSkuIds();
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.getSkuDiscountLimit(skuIds);
        for (UccSkuPo each : uccSkuPos) {
            try {
                JSONObject object = new JSONObject();
                object.put("discountLimitValue", (Object)each.getDiscountLimitValue());
                object.put("hide", (Object)each.getHide());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getSkuId().toString(), object);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    private void syncDataGovernToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        if (CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getSkuIds())) {
            return;
        }
        List skuIds = syncSceneCommodityToEsReqBO.getSkuIds();
        List<SkuForEsPO> skuForEsPOS = this.uccSkuMapper.qryDataGovernSyncSkuInfo(skuIds);
        List<UccEMdmCatalogPO> catalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalogBySkuIds(skuIds);
        Map<Object, Object> skuIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(catalogPOS)) {
            skuIdMap = catalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getSkuId, UccEMdmCatalogPO::getDataGovernFlag));
        }
        if (!CollectionUtils.isEmpty(skuForEsPOS)) {
            List skuForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(skuForEsPOS), SkuForEsBO.class);
            for (SkuForEsBO each : skuForEsBOS) {
                EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
                esStorageSpuInfoBO.setSku_id(each.getSkuId());
                esStorageSpuInfoBO.setSku_name(each.getSkuName());
                esStorageSpuInfoBO.setSku_status(each.getSkuStatus());
                esStorageSpuInfoBO.setMaterial_id(each.getMaterialId());
                esStorageSpuInfoBO.setMaterial_name(each.getMaterialName());
                esStorageSpuInfoBO.setMaterial_code(each.getMaterialCode());
                esStorageSpuInfoBO.setLong_desc(each.getLongDesc());
                esStorageSpuInfoBO.setMaterial_type(each.getMaterialType());
                esStorageSpuInfoBO.setGovern_result(each.getResult());
                esStorageSpuInfoBO.setData_govern_flag(ObjectUtil.isEmpty((Object)each.getDataGovernFlag()) ? 0 : each.getDataGovernFlag());
                esStorageSpuInfoBO.setRegular_price(each.getRegularPrice());
                esStorageSpuInfoBO.setDiscountLimitValue(each.getDiscountLimitValue());
                esStorageSpuInfoBO.setHide(each.getHide());
                esStorageSpuInfoBO.setSurpassVpt(each.getSurpassVpt());
                Integer dataGovernFlag = null;
                dataGovernFlag = (Integer)skuIdMap.get(each.getSkuId());
                if (dataGovernFlag != null && dataGovernFlag == 1) {
                    String dataGovernProperties = this.uccSpuSpecMapper.getSkuDataGovernProperties(each.getSkuId());
                    if (!StringUtils.isEmpty((CharSequence)dataGovernProperties)) {
                        esStorageSpuInfoBO.setProperties(dataGovernProperties);
                    }
                } else {
                    String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esStorageSpuInfoBO.getSku_id());
                    esStorageSpuInfoBO.setProperties(properties);
                }
                JudgeSkuEsBo overJudge = this.isOverJudge(esStorageSpuInfoBO.getSku_id());
                if (overJudge.getIsSync().booleanValue()) {
                    BeanUtils.copyProperties((Object)overJudge, (Object)esStorageSpuInfoBO);
                }
                try {
                    JSONObject object = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esStorageSpuInfoBO), JSONObject.class);
                    this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), each.getSkuId().toString(), object);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    private void syncCatalogDataGovernFlagToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        if (CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getCatalogIds())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getCatalogIds())) {
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, 1000);
                List<Long> skuIds = this.uccSkuMapper.getSkuIdByCommodityTypeCatalog(syncSceneCommodityToEsReqBO.getCatalogIds(), page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (CollectionUtils.isEmpty(skuIds)) break;
                SyncSceneCommodityToEsReqBO toEsReqBO = new SyncSceneCommodityToEsReqBO();
                toEsReqBO.setSkuIds(skuIds);
                this.syncDataGovernToEs(toEsReqBO);
            } while (++num <= total);
        }
    }
}

