/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccSendNotificationExtAtomService;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.common.ability.api.UccAutoHideCatalogStandardSkuAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoHideCatalogStandardSkuAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccAutoHideCatalogStandardSkuBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiRspBo;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccStandardComInfoMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccStandardComInfoPO;
import com.tydic.umc.general.ability.api.UmcQryMemInfoForNotifyService;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyBo;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyReqBo;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAutoHideCatalogStandardSkuAbilityService"})
public class UccAutoHideCatalogStandardSkuAbilityServiceImpl
implements UccAutoHideCatalogStandardSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoHideCatalogStandardSkuAbilityServiceImpl.class);
    public static final Integer OPER_TYPE_HIDE_CATALOG = 1;
    public static final Integer OPER_TYPE_DISPLAY_CATALOG = 2;
    public static final Integer OPER_TYPE_HIDE_BANNER = 3;
    @Autowired
    private UccAutoHideCatalogStandardSkuBusiService uccAutoHideCatalogStandardSkuBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private SyncSceneStandardCommodityToEsAtomService syncSceneStandardCommodityToEsAtomService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${MDM_STANDARD_SKU_NUM_HIDE_SIZE:100}")
    private Integer MDM_STANDARD_SKU_NUM_HIDE_SIZE;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();
    private static final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
    private static final ExecutorService fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
    @Autowired
    private UccSendNotificationExtAtomService uccSendNotificationExtAtomService;
    @Autowired
    private UmcQryMemInfoForNotifyService umcQryMemInfoForNotifyService;
    @Value(value="${HIDE_MSG_ROLE:HIDE_MSG_ROLE}")
    private String hideMsgRole;
    private static final String hideMsgRoleStr = "HIDE_MSG_ROLE";
    @Autowired
    private UccStandardComInfoMapper uccStandardComInfoMapper;

    @PostMapping(value={"autoHideCatalogStandardSku"})
    public RspUccBo autoHideCatalogStandardSku(@RequestBody UccAutoHideCatalogStandardSkuAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOperType())) {
            this.hideSku(reqBO);
            this.displaySku(reqBO);
            this.hideSkuByBrandVerify();
        } else {
            if (reqBO.getOperType().contains(OPER_TYPE_HIDE_CATALOG)) {
                this.hideSku(reqBO);
            }
            if (reqBO.getOperType().contains(OPER_TYPE_DISPLAY_CATALOG)) {
                this.displaySku(reqBO);
            }
            if (reqBO.getOperType().contains(OPER_TYPE_HIDE_BANNER)) {
                this.hideSkuByBrandVerify();
            }
        }
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    private void hideSku(UccAutoHideCatalogStandardSkuAbilityReqBO reqBO) {
        log.debug("\u8fdb\u5165\u4e86\u9690\u85cf\u903b\u8f91-----------");
        UccEMdmCatalogPO qryUccEMdmCatalogPO = new UccEMdmCatalogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryUccEMdmCatalogPO);
        qryUccEMdmCatalogPO.setHide(UccConstants.Hide.no);
        Integer count = this.uccEMdmCatalogMapper.getListByStandardTaskCount(qryUccEMdmCatalogPO);
        if (count > 0) {
            fixedThreadPool.submit(() -> {
                Page page;
                List byStandardTaskCountPage;
                int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
                for (int i = 1; i <= cycle && !CollectionUtils.isEmpty((Collection)(byStandardTaskCountPage = this.uccEMdmCatalogMapper.getListByStandardTaskCountPage(qryUccEMdmCatalogPO, page = new Page(1, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue())))); ++i) {
                    UccAutoHideCatalogStandardSkuBusiReqBo uccAutoHideCatalogStandardSkuBusiReqBo = new UccAutoHideCatalogStandardSkuBusiReqBo();
                    uccAutoHideCatalogStandardSkuBusiReqBo.setUccSkuPoList(byStandardTaskCountPage);
                    uccAutoHideCatalogStandardSkuBusiReqBo.setHide(UccConstants.Hide.yes);
                    UccAutoHideCatalogStandardSkuBusiRspBo rspBo = this.uccAutoHideCatalogStandardSkuBusiService.dealSkuChangeTask(uccAutoHideCatalogStandardSkuBusiReqBo);
                    if (!"0000".equals(rspBo.getRespCode())) {
                        throw new BusinessException("8888", rspBo.getRespDesc());
                    }
                    try {
                        this.addLog(uccAutoHideCatalogStandardSkuBusiReqBo.getUccSkuPoList(), uccAutoHideCatalogStandardSkuBusiReqBo.getHide());
                    }
                    catch (Exception e) {
                        log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                    }
                    List<Long> standardIds = rspBo.getStandardIds();
                    List skuIds = byStandardTaskCountPage.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        log.info("\u540c\u6b65\u5355\u54c1ES\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO));
                        SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                        log.info("\u540c\u6b65\u5355\u54c1ES\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsRspBO));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(standardIds)) continue;
                    SyncSceneStandardCommodityToEsReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                    syncSceneStandardCommodityToEsReqBO.setStandardIdLList(standardIds);
                    syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                    this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
                }
            });
            if (reqBO.getOffCheckStandardId() != null && !hideMsgRoleStr.equals(this.hideMsgRole)) {
                try {
                    Long roleId = Long.valueOf(this.hideMsgRole);
                    UmcQryMemInfoForNotifyReqBo umcQryMemInfoForNotifyReqBo = new UmcQryMemInfoForNotifyReqBo();
                    umcQryMemInfoForNotifyReqBo.setPageNo(Integer.valueOf(1));
                    umcQryMemInfoForNotifyReqBo.setPageSize(Integer.valueOf(200));
                    ArrayList<Long> roleIdList = new ArrayList<Long>();
                    roleIdList.add(roleId);
                    umcQryMemInfoForNotifyReqBo.setRoleIdList(roleIdList);
                    UmcQryMemInfoForNotifyRspBo umcQryMemInfoForNotifyRspBo = this.umcQryMemInfoForNotifyService.qryOWMemInfo(umcQryMemInfoForNotifyReqBo);
                    if (!CollectionUtils.isEmpty((Collection)umcQryMemInfoForNotifyRspBo.getRows())) {
                        List userIds = umcQryMemInfoForNotifyRspBo.getRows().stream().map(UmcQryMemInfoForNotifyBo::getMemId).collect(Collectors.toList());
                        UccSendNotificationExtAtomReqBO uccSendNotificationExtAtomReqBO = new UccSendNotificationExtAtomReqBO();
                        UccStandardComInfoPO searchStandInfoPO = new UccStandardComInfoPO();
                        searchStandInfoPO.setStandardComId(reqBO.getOffCheckStandardId());
                        UccStandardComInfoPO standardComInfoPO = this.uccStandardComInfoMapper.getModelBy(searchStandInfoPO);
                        uccSendNotificationExtAtomReqBO.setText("\u3010" + reqBO.getOffSkuCode() + "-" + reqBO.getOffSkuName() + "\u3011\u5df2\u4e0b\u67b6\uff0c\u5bfc\u81f4\u5546\u54c1\u3010" + standardComInfoPO.getStandardComCode() + "-" + standardComInfoPO.getStandardComName() + "\u3011\u4e0b\u7684\u5546\u54c1\u9690\u85cf");
                        uccSendNotificationExtAtomReqBO.setTitel(uccSendNotificationExtAtomReqBO.getText());
                        uccSendNotificationExtAtomReqBO.setReceiveIds(userIds);
                        uccSendNotificationExtAtomReqBO.setUserId(Long.valueOf(1L));
                        this.uccSendNotificationExtAtomService.sendNotification(uccSendNotificationExtAtomReqBO);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5904\u7406\u53d1\u9001\u9690\u85cf\u7ad9\u5185\u4fe1\u5931\u8d25" + e.getMessage());
                }
            }
        }
    }

    private void displaySku(UccAutoHideCatalogStandardSkuAbilityReqBO reqBO) {
        log.debug("\u8fdb\u5165\u4e86\u6062\u590d\u4e0a\u67b6\u903b\u8f91-----------");
        UccEMdmCatalogPO qryUccEMdmCatalogPO = new UccEMdmCatalogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryUccEMdmCatalogPO);
        qryUccEMdmCatalogPO.setHide(UccConstants.Hide.yes);
        Integer count = this.uccEMdmCatalogMapper.getListByStandardTaskCount(qryUccEMdmCatalogPO);
        if (count > 0) {
            fixedThreadPool.submit(() -> {
                Page page;
                List byStandardTaskCountPage;
                int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
                for (int i = 1; i <= cycle && !CollectionUtils.isEmpty((Collection)(byStandardTaskCountPage = this.uccEMdmCatalogMapper.getListByStandardTaskCountPage(qryUccEMdmCatalogPO, page = new Page(1, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue())))); ++i) {
                    UccAutoHideCatalogStandardSkuBusiReqBo uccAutoHideCatalogStandardSkuBusiReqBo = new UccAutoHideCatalogStandardSkuBusiReqBo();
                    uccAutoHideCatalogStandardSkuBusiReqBo.setUccSkuPoList(byStandardTaskCountPage);
                    uccAutoHideCatalogStandardSkuBusiReqBo.setHide(UccConstants.Hide.no);
                    UccAutoHideCatalogStandardSkuBusiRspBo rspBo = this.uccAutoHideCatalogStandardSkuBusiService.dealSkuChangeTask(uccAutoHideCatalogStandardSkuBusiReqBo);
                    if (!"0000".equals(rspBo.getRespCode())) {
                        throw new BusinessException("8888", rspBo.getRespDesc());
                    }
                    try {
                        this.addLog(uccAutoHideCatalogStandardSkuBusiReqBo.getUccSkuPoList(), uccAutoHideCatalogStandardSkuBusiReqBo.getHide());
                    }
                    catch (Exception e) {
                        log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                    }
                    List<Long> standardIds = rspBo.getStandardIds();
                    List skuIds = byStandardTaskCountPage.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        log.info("\u540c\u6b65\u5355\u54c1ES\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO));
                        SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                        log.info("\u540c\u6b65\u5355\u54c1ES\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsRspBO));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(standardIds)) continue;
                    SyncSceneStandardCommodityToEsReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                    syncSceneStandardCommodityToEsReqBO.setStandardIdLList(standardIds);
                    syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                    this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
                }
            });
        }
    }

    private void addLog(List<UccSkuPo> uccSkuPoList, Integer hide) {
        ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        List skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        for (Long skuId : skuIds) {
            UccSkuOperationLogRecordAbilityBO uccSkuOperationLogRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
            uccSkuOperationLogRecordAbilityBO.setSkuId(skuId);
            uccSkuOperationLogRecordAbilityBO.setCreateOperId("\u7ba1\u7406\u5458");
            uccSkuOperationLogRecordAbilityBO.setCommodityId(null);
            uccSkuOperationLogRecordAbilityBO.setCreateTime(new Date());
            if (UccConstants.Hide.no.equals(hide)) {
                uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(24));
                uccSkuOperationLogRecordAbilityBO.setRemark("\u5355\u54c1\u53d6\u6d88\u9690\u85cf");
            } else {
                uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(23));
                uccSkuOperationLogRecordAbilityBO.setRemark("\u5355\u54c1\u9690\u85cf");
            }
            recordAbilityBOS.add(uccSkuOperationLogRecordAbilityBO);
        }
        UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
        skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
        this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
    }

    private void hideSkuByBrandVerify() {
        log.debug("\u8fdb\u5165\u4e86\u4f9b\u5e94\u5546\u4e0e\u54c1\u724c\u5173\u8054\u5173\u7cfb\u9690\u85cf\u903b\u8f91-----------");
        Integer count = this.uccEMdmCatalogMapper.getCatalogBrandVerifyTaskCount();
        if (count > 0) {
            fixedThreadPool.submit(() -> {
                Page page;
                List byStandardTaskCountPage;
                int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
                for (int i = 1; i <= cycle && !CollectionUtils.isEmpty((Collection)(byStandardTaskCountPage = this.uccEMdmCatalogMapper.getCatalogBrandVerifyTaskPage(page = new Page(1, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue())))); ++i) {
                    UccAutoHideCatalogStandardSkuBusiReqBo uccAutoHideCatalogStandardSkuBusiReqBo = new UccAutoHideCatalogStandardSkuBusiReqBo();
                    uccAutoHideCatalogStandardSkuBusiReqBo.setUccSkuPoList(byStandardTaskCountPage);
                    uccAutoHideCatalogStandardSkuBusiReqBo.setHide(UccConstants.Hide.yes);
                    UccAutoHideCatalogStandardSkuBusiRspBo rspBo = this.uccAutoHideCatalogStandardSkuBusiService.dealSkuChangeTask(uccAutoHideCatalogStandardSkuBusiReqBo);
                    if (!"0000".equals(rspBo.getRespCode())) {
                        throw new BusinessException("8888", rspBo.getRespDesc());
                    }
                    try {
                        this.addLog(uccAutoHideCatalogStandardSkuBusiReqBo.getUccSkuPoList(), uccAutoHideCatalogStandardSkuBusiReqBo.getHide());
                    }
                    catch (Exception e) {
                        log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                    }
                    List<Long> standardIds = rspBo.getStandardIds();
                    List skuIds = byStandardTaskCountPage.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        log.info("\u540c\u6b65\u5355\u54c1ES\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO));
                        SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                        log.info("\u540c\u6b65\u5355\u54c1ES\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsRspBO));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(standardIds)) continue;
                    SyncSceneStandardCommodityToEsReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                    syncSceneStandardCommodityToEsReqBO.setStandardIdLList(standardIds);
                    syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                    this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
                }
            });
        }
    }
}

