/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.common.ability.api.UccMdmCatalogVerificationEditService;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogVerificationEdit;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogVerificationEditReq;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogVerificationEditRsp;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMdmCatalogVerificationEditService"})
public class UccMdmCatalogVerificationEditServiceImpl
implements UccMdmCatalogVerificationEditService {
    private static final Logger log = LoggerFactory.getLogger(UccMdmCatalogVerificationEditServiceImpl.class);
    private UccEMdmCatalogMapper uccMdmCatalogMapper;
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;

    @PostMapping(value={"dycMdmCatalogVerification"})
    public UccMdmCatalogVerificationEditRsp dycMdmCatalogVerification(@RequestBody UccMdmCatalogVerificationEditReq reqBo) {
        UccMdmCatalogVerificationEditRsp rsp = new UccMdmCatalogVerificationEditRsp();
        if (CheckUtil.isEmpty((Collection)reqBo.getVerificationList())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u5fc5\u4f20\u4fee\u6539\u5217\u8868\u4e3a\u7a7a");
            return rsp;
        }
        int count = 0;
        for (UccMdmCatalogVerificationEdit edit : reqBo.getVerificationList()) {
            UccEMdmCatalogPO uccMdmCatalogPo;
            if (edit.getCatalogId() == null || (uccMdmCatalogPo = this.uccMdmCatalogMapper.queryByCatId(edit.getCatalogId())) == null || edit.getBrandVerify() == null) continue;
            boolean ifEditStatus = false;
            if (edit.getBrandVerify() == 1 && !edit.getBrandVerify().equals(uccMdmCatalogPo.getBrandVerify())) {
                ifEditStatus = true;
            }
            if (!CheckUtil.isNotBlank((Object)uccMdmCatalogPo)) continue;
            uccMdmCatalogPo.setBrandVerify(edit.getBrandVerify());
            if (this.uccMdmCatalogMapper.updateCatalogInfo(uccMdmCatalogPo) != 1) continue;
            ++count;
            if (!ifEditStatus) continue;
            UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
            esReqBO.setCatalogId(edit.getCatalogId());
            try {
                log.info("\u8c03\u7528\u54c1\u724c\u6279\u91cfMQ\u63a5\u53e3\uff0c\u7269\u8d44\u7c7b\u522bID:{}", (Object)edit.getCatalogId());
                this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
            }
        }
        if (count == reqBo.getVerificationList().size()) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
        } else {
            rsp.setRespCode("8888");
            if (count == 0) {
                rsp.setRespCode("\u5931\u8d25");
            }
            rsp.setRespDesc("\u66f4\u65b0\u76ee\u6807\u6761\u6570:" + reqBo.getVerificationList().size() + "\u5b9e\u9645\u66f4\u65b0\u6210\u529f\u6761\u6570:" + count);
        }
        return rsp;
    }

    @Autowired
    public void setUccMdmCatalogMapper(UccEMdmCatalogMapper uccMdmCatalogMapper) {
        this.uccMdmCatalogMapper = uccMdmCatalogMapper;
    }
}

