/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccAutoHideCatalogStandardSkuBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiRspBo;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccAutoHideCatalogStandardSkuBusiServiceImpl
implements UccAutoHideCatalogStandardSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoHideCatalogStandardSkuBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccAutoHideCatalogStandardSkuBusiRspBo dealSkuChangeTask(UccAutoHideCatalogStandardSkuBusiReqBo reqBO) {
        List collect = reqBO.getUccSkuPoList().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        try {
            this.uccSkuMapper.updateSkuByStandardValid(collect, reqBO.getHide());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5355\u54c1\u662f\u5426\u9690\u85cf\u5b57\u6bb5\u5931\u8d25");
            throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u662f\u5426\u9690\u85cf\u5b57\u6bb5\u5931\u8d25");
        }
        List<Long> standardIds = reqBO.getUccSkuPoList().stream().map(UccSkuPo::getStandardComId).distinct().collect(Collectors.toList());
        UccAutoHideCatalogStandardSkuBusiRspBo rspBo = new UccAutoHideCatalogStandardSkuBusiRspBo();
        rspBo.setStandardIds(standardIds);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

