/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuReqBo;
import com.tydic.commodity.common.ability.bo.UccStandardRestorePushGavernAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardRestorePushGavernAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardRestorePushGavernBusiService;
import com.tydic.commodity.dao.UccExtRecoveryShelveGoveryRecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccExtRecoveryShelveGoveryRecordPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccStandardRestorePushGavernBusiServiceImpl
implements UccStandardRestorePushGavernBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardRestorePushGavernBusiServiceImpl.class);
    @Autowired
    private UccExtRecoveryShelveGoveryRecordMapper uccExtRecoveryShelveGoveryRecordMapper;
    @Autowired
    private UccDataGovernPushSkuService uccDataGovernPushSkuService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccStandardRestorePushGavernAbilityRspBO dealRestorePushGavern(UccStandardRestorePushGavernAbilityReqBO reqBO) {
        this.validateParam(reqBO);
        List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        UccStandardRestorePushGavernAbilityRspBO rspBO = new UccStandardRestorePushGavernAbilityRspBO();
        UccDataGovernPushSkuReqBo uccDataGovernPushSkuReqBo = new UccDataGovernPushSkuReqBo();
        uccDataGovernPushSkuReqBo.setSkuIds(skus);
        uccDataGovernPushSkuReqBo.setType(Integer.valueOf(1));
        this.uccDataGovernPushSkuService.dealDataGovernPushSku(uccDataGovernPushSkuReqBo);
        List insertPos = reqBO.getBatchSkuList().stream().map(e -> {
            UccExtRecoveryShelveGoveryRecordPO recoveryShelveGoveryRecordPO = new UccExtRecoveryShelveGoveryRecordPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)recoveryShelveGoveryRecordPO);
            recoveryShelveGoveryRecordPO.setDelTag(Integer.valueOf(0));
            recoveryShelveGoveryRecordPO.setSkuId(e.getSkuId());
            recoveryShelveGoveryRecordPO.setStandardComId(e.getStandardComId());
            recoveryShelveGoveryRecordPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            recoveryShelveGoveryRecordPO.setCreateTime(new Date());
            recoveryShelveGoveryRecordPO.setCreateId(reqBO.getUserId());
            recoveryShelveGoveryRecordPO.setCreateName(reqBO.getName());
            recoveryShelveGoveryRecordPO.setHandleState(UccConstants.StandardReOnShelveStatus.wait);
            recoveryShelveGoveryRecordPO.setReqJson(JSON.toJSONString((Object)reqBO));
            return recoveryShelveGoveryRecordPO;
        }).collect(Collectors.toList());
        this.uccExtRecoveryShelveGoveryRecordMapper.insertBatch(insertPos);
        try {
            this.uccSkuMapper.batchUpdateSkuStatusByIds(skus, ModelRuleConstant.SKU_STATUS_DATA_GOVERNANCE, null);
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u4e3a\u6cbb\u7406\u4e2d\u5931\u8d25{}", (Object)e2.getMessage());
            throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u72b6\u6001\u4e3a\u67b6\u6cbb\u7406\u4e2d\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setSkuIds(skus);
        return rspBO;
    }

    private void validateParam(UccStandardRestorePushGavernAbilityReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getBatchSkuList())) {
            throw new BusinessException("8888", "\u5165\u53c2 batchSkuList \u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSkuBO batchSkuBO : reqBO.getBatchSkuList()) {
            if (batchSkuBO.getSkuId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2 batchSkuList skuId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (batchSkuBO.getStandardComId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2 batchSkuList standardComId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (batchSkuBO.getSupplierShopId() != null) continue;
            throw new BusinessException("8888", "\u5165\u53c2 batchSkuList supplierShopId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List collect = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        UccExtRecoveryShelveGoveryRecordPO goveryRecordPO = new UccExtRecoveryShelveGoveryRecordPO();
        goveryRecordPO.setSkuIds(collect);
        goveryRecordPO.setHandleState(Integer.valueOf(0));
        goveryRecordPO.setDelTag(Integer.valueOf(0));
        List list = this.uccExtRecoveryShelveGoveryRecordMapper.getList(goveryRecordPO);
        if (!CollectionUtil.isEmpty((Collection)list)) {
            throw new BusinessException("8888", "\u5b58\u5728\u5df2\u7ecf\u63d0\u4ea4\u6062\u590d\u4e0a\u67b6\u7684\u5546\u54c1:" + JSON.toJSONString(list.stream().map(UccExtRecoveryShelveGoveryRecordPO::getSkuId).collect(Collectors.toList())));
        }
    }
}

