/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.busi.api.UccIteminbulkOffApplyBusiService;
import com.tydic.commodity.common.busi.bo.UccIteminbulkOffApplyBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccIteminbulkOffApplyBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccIteminbulkOffApplyBusiServiceImpl
implements UccIteminbulkOffApplyBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public UccIteminbulkOffApplyBusiRspBO dealOffShelfApply(UccIteminbulkOffApplyBusiReqBO reqBO) {
        List skuIds;
        UccIteminbulkOffApplyBusiRspBO rspBO = new UccIteminbulkOffApplyBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getProcess())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        Iterator<Long> iteratorSpu = mapSku.keySet().iterator();
        HashMap mapSpu = new HashMap();
        while (iteratorSpu.hasNext()) {
            Long supplierShopId = iteratorSpu.next();
            skuIds = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, supplierShopId);
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5ba1\u6279\u5546\u54c1\u4e0d\u5b58\u5728" + skuIds);
                return rspBO;
            }
            if (uccSkuPos.size() != skuIds.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u90e8\u5206\u5546\u54c1\u4e0d\u5b58\u5728");
                return rspBO;
            }
            List noPass = uccSkuPos.stream().filter(a -> ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO.equals(a.getApprovalStatus()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.equals(a.getApprovalStatus()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(a.getApprovalStatus()) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(a.getApprovalStatus()) || !ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(a.getApprovalStatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(noPass)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(" \u90e8\u5206\u5355\u54c1\u5ba1\u6279\u72b6\u6001\u6216\u5219\u5355\u54c1\u72b6\u6001\u4e0d\u6b63\u786e" + ((UccSkuPo)noPass.get(0)).getSkuId());
                return rspBO;
            }
            List spu = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            mapSpu.put(supplierShopId, spu);
        }
        for (Long supplierShopId : mapSku.keySet()) {
            skuIds = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)approveCreationAtomReqBO);
            approveCreationAtomReqBO.setObjId(skuIds);
            approveCreationAtomReqBO.setMenuId(reqBO.getProcess());
            approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
            approveCreationAtomReqBO.setOrderId(supplierShopId);
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                UccStatusChangeUpdateSpuAtomReqBO changeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
                ArrayList<UccSkuUpdateStatusBO> skuStatusList = new ArrayList<UccSkuUpdateStatusBO>();
                UccSkuUpdateStatusBO bo = null;
                for (UccBatchSkuBO each : mapSku.get(supplierShopId)) {
                    bo = new UccSkuUpdateStatusBO();
                    bo.setSkuId(each.getSkuId());
                    bo.setSkuStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF);
                    skuStatusList.add(bo);
                }
                changeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
                changeUpdateSpuAtomReqBO.setSkuStatusList(skuStatusList);
                UccStatusChangeUpdateSpuAtomRspBO changeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(changeUpdateSpuAtomReqBO);
                if ("0000".equals(changeUpdateSpuAtomRspBO.getRespCode())) continue;
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), changeUpdateSpuAtomRspBO.getRespDesc());
            }
            try {
                if (!StringUtils.isEmpty((Object)uccApproveCreationAtomRspBO.getStepId())) {
                    this.uccCommodityMapper.batchUpdateSpuApprovalStatus((List)mapSpu.get(supplierShopId), uccApproveCreationAtomRspBO.getStepId(), supplierShopId);
                    this.uccSkuMapper.batchUpdateStep((List)mapSpu.get(supplierShopId), uccApproveCreationAtomRspBO.getStepId(), supplierShopId);
                }
                this.uccCommodityMapper.batchUpdateSpuApprovalStatus((List)mapSpu.get(supplierShopId), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.toString(), supplierShopId);
                this.uccSkuMapper.batchUpdateSpuApprovalStatus((List)mapSpu.get(supplierShopId), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.toString(), supplierShopId);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

