/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.PCodeConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccJudgeSkuSurpassVptAtomReqBo;
import com.tydic.commodity.common.ability.bo.UccJudgeSkuSurpassVptAtomRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccJudgeSkuSurpassVptBusiService;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccMallPriceRangeExtMapper;
import com.tydic.commodity.dao.UccMallPriceRangeMapper;
import com.tydic.commodity.dao.UccPriceAnomalyItemMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccMallPriceRangeExtPO;
import com.tydic.commodity.po.UccMallPriceRangePO;
import com.tydic.commodity.po.UccPriceAnomalyItemPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccJudgeSkuSurpassVptBusiServiceImpl
implements UccJudgeSkuSurpassVptBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccJudgeSkuSurpassVptBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private SkuDataGovernPriceMapper skuDataGovernPriceMapper;
    @Autowired
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    @Autowired
    private UccMallPriceRangeExtMapper uccMallPriceRangeExtMapper;
    @Autowired
    private UccMallPriceRangeMapper uccMallPriceRangeMapper;
    @Autowired
    private UccPriceAnomalyItemMapper uccPriceAnomalyItemMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;
    @Autowired
    private XwgLSaveLogAbilityService xwglSaveLogAbilityService;
    @Value(value="${ucc.sku.surpass.ruleNo:YGSC-SP-00009}")
    private String uccSkuSurpassRuleNo;
    @Value(value="${ucc.sku.detail.url:http://172.20.175.3/#/index/ecCommodityItemDetail?skuId=}")
    private String uccSkuDetailUrl;

    @Override
    public UccJudgeSkuSurpassVptAtomRspBo dealSkuSurpassVpt(UccJudgeSkuSurpassVptAtomReqBo reqBo) {
        UccMallPriceRangePO uccMallPriceRangePO;
        List uccMallPriceRangePOS;
        List uccSkuPos;
        UccJudgeSkuSurpassVptAtomRspBo rspBo = new UccJudgeSkuSurpassVptAtomRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            return rspBo;
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
        statusList.add(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
        statusList.add(SkuStatusEnum.EC_DOWN_STATUS.getStatus());
        statusList.add(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
        statusList.add(SkuStatusEnum.WARN_DOWN_STATUS.getStatus());
        statusList.add(SkuStatusEnum.SKU_STATUS_RESTORATION_LISTING_GOVERNANCE.getStatus());
        List skuInfoList = this.uccSkuMapper.getInfoListByStateAndIdList(reqBo.getSkuIds(), statusList);
        if (CollectionUtils.isEmpty((Collection)skuInfoList)) {
            return rspBo;
        }
        List collect = skuInfoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        reqBo.setSkuIds(collect);
        rspBo.setSkuIdList(collect);
        SkuDataGovernPricePO skuDataGovernPricePO = new SkuDataGovernPricePO();
        skuDataGovernPricePO.setSkuIds(reqBo.getSkuIds());
        List skuDataGovernPricePOS = this.skuDataGovernPriceMapper.getList(skuDataGovernPricePO);
        Map<Object, Object> dataGovernPricePOMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)skuDataGovernPricePOS)) {
            dataGovernPricePOMap = skuDataGovernPricePOS.stream().collect(Collectors.toMap(SkuDataGovernPricePO::getSkuId, b -> b, (first, second) -> first));
        }
        SkuDataGovernSamePricePO skuDataGovernSamePricePO = new SkuDataGovernSamePricePO();
        skuDataGovernSamePricePO.setSkuIds(reqBo.getSkuIds());
        skuDataGovernSamePricePO.setType(Integer.valueOf(1));
        List skuDataGovernSamePricePOS = this.skuDataGovernSamePriceMapper.getList(skuDataGovernSamePricePO);
        HashMap<Long, BigDecimal> skuLowestPriceMap = new HashMap<Long, BigDecimal>();
        if (!CollectionUtils.isEmpty((Collection)skuDataGovernSamePricePOS)) {
            Map<Long, List<SkuDataGovernSamePricePO>> skuSameMap = skuDataGovernSamePricePOS.stream().collect(Collectors.groupingBy(SkuDataGovernSamePricePO::getSkuId));
            for (Map.Entry<Long, List<SkuDataGovernSamePricePO>> each : skuSameMap.entrySet()) {
                BigDecimal lowestPrice = BigDecimal.ZERO;
                for (SkuDataGovernSamePricePO skuDataGovernSamePricePO1 : each.getValue()) {
                    if (lowestPrice.compareTo(skuDataGovernSamePricePO1.getPrice()) <= 0) continue;
                    lowestPrice = skuDataGovernSamePricePO1.getPrice();
                }
                skuLowestPriceMap.put(each.getKey(), lowestPrice);
            }
        }
        List uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        Map<Object, Object> skuPriceMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)uccSkuPricePos)) {
            skuPriceMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, a -> MoneyUtils.haoToYuan((Long)a.getAgreementPrice())));
        }
        if (CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null)))) {
            return rspBo;
        }
        List typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
        UccMallPriceRangeExtPO uccMallPriceRangeExtPO = new UccMallPriceRangeExtPO();
        uccMallPriceRangeExtPO.setCommodityTypeIds(typeIds);
        List uccMallPriceRangeExtPOS = this.uccMallPriceRangeExtMapper.getList(uccMallPriceRangeExtPO);
        HashMap<Long, Integer> skuSurVptMap = new HashMap<Long, Integer>();
        ArrayList<UccPriceAnomalyItemPO> uccPriceAnomalyItemPoList = new ArrayList<UccPriceAnomalyItemPO>();
        Date date = new Date();
        HashSet<String> skuSurVptRangeSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)uccMallPriceRangeExtPOS)) {
            Map<Long, List<UccMallPriceRangeExtPO>> extMap = uccMallPriceRangeExtPOS.stream().collect(Collectors.groupingBy(UccMallPriceRangeExtPO::getCommodityTypeId));
            for (Map.Entry<Long, List<UccMallPriceRangeExtPO>> each : extMap.entrySet()) {
                List<UccMallPriceRangeExtPO> extPOS = each.getValue();
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    if (!uccSkuPo.getCommodityTypeId().equals(each.getKey())) continue;
                    skuSurVptMap.put(uccSkuPo.getSkuId(), 0);
                    BigDecimal regularPrice = null;
                    BigDecimal lowestPrice = null;
                    BigDecimal intMinPrice = null;
                    BigDecimal intMaxPrice = null;
                    BigDecimal intVagPrice = null;
                    BigDecimal sameIntSkuIdPrice = null;
                    if (dataGovernPricePOMap.containsKey(uccSkuPo.getSkuId())) {
                        regularPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getRegularPrice();
                        lowestPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getLowestPrice();
                        intMinPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntMinPrice();
                        intMaxPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntMaxPrice();
                        intVagPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntVagPrice();
                        sameIntSkuIdPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getSameIntSkuIdPrice();
                    }
                    BigDecimal sameLowestPrice = null;
                    if (skuLowestPriceMap.containsKey(uccSkuPo.getSkuId())) {
                        sameLowestPrice = (BigDecimal)skuLowestPriceMap.get(uccSkuPo.getSkuId());
                    }
                    BigDecimal agreementPrice = null;
                    if (skuPriceMap.containsKey(uccSkuPo.getSkuId())) {
                        agreementPrice = (BigDecimal)skuPriceMap.get(uccSkuPo.getSkuId());
                    }
                    if (agreementPrice == null) continue;
                    for (int i = 0; i < extPOS.size(); ++i) {
                        skuSurVptRangeSet.add(uccSkuPo.getSkuId().toString() + ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType().toString());
                        if (1 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (regularPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), regularPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (2 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (lowestPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), lowestPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (3 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (sameLowestPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), sameLowestPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (4 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (intMinPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intMinPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (5 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (intMaxPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intMaxPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (6 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                            if (intVagPrice == null) continue;
                            this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intVagPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                            continue;
                        }
                        if (7 != ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType() || sameIntSkuIdPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), sameIntSkuIdPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(uccMallPriceRangePOS = this.uccMallPriceRangeMapper.getList(uccMallPriceRangePO = new UccMallPriceRangePO())))) {
            List extPOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccMallPriceRangePOS), UccMallPriceRangeExtPO.class);
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                BigDecimal regularPrice = null;
                BigDecimal lowestPrice = null;
                BigDecimal intMinPrice = null;
                BigDecimal intMaxPrice = null;
                BigDecimal intVagPrice = null;
                BigDecimal sameIntSkuIdPrice = null;
                if (dataGovernPricePOMap.containsKey(uccSkuPo.getSkuId())) {
                    regularPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getRegularPrice();
                    lowestPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getLowestPrice();
                    intMinPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntMinPrice();
                    intMaxPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntMaxPrice();
                    intVagPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getIntVagPrice();
                    sameIntSkuIdPrice = ((SkuDataGovernPricePO)dataGovernPricePOMap.get(uccSkuPo.getSkuId())).getSameIntSkuIdPrice();
                }
                BigDecimal sameLowestPrice = null;
                if (skuLowestPriceMap.containsKey(uccSkuPo.getSkuId())) {
                    sameLowestPrice = (BigDecimal)skuLowestPriceMap.get(uccSkuPo.getSkuId());
                }
                BigDecimal agreementPrice = null;
                if (skuPriceMap.containsKey(uccSkuPo.getSkuId())) {
                    agreementPrice = (BigDecimal)skuPriceMap.get(uccSkuPo.getSkuId());
                }
                if (agreementPrice == null) continue;
                for (int i = 0; i < extPOS.size(); ++i) {
                    if (skuSurVptRangeSet.contains(uccSkuPo.getSkuId().toString() + ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType().toString())) continue;
                    if (1 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (regularPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), regularPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (2 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (lowestPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), lowestPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (3 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (sameLowestPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), sameLowestPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (4 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (intMinPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intMinPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (5 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (intMaxPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intMaxPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (6 == ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType()) {
                        if (intVagPrice == null) continue;
                        this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), intVagPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                        continue;
                    }
                    if (7 != ((UccMallPriceRangeExtPO)extPOS.get(i)).getRangeType() || sameIntSkuIdPrice == null) continue;
                    this.getResult((UccMallPriceRangeExtPO)extPOS.get(i), sameIntSkuIdPrice, agreementPrice, uccSkuPo.getSkuId(), skuSurVptMap, uccPriceAnomalyItemPoList, date);
                }
            }
        }
        skuSurVptMap.forEach((k, v) -> {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(k);
            uccSkuPo.setSurpassVpt(v);
            this.uccSkuMapper.modifySku(uccSkuPo);
        });
        UccPriceAnomalyItemPO where = new UccPriceAnomalyItemPO();
        where.setIsDeleted(UccConstants.DelTag.NOT_DEL.toString());
        where.setSkuIdList(reqBo.getSkuIds());
        where.setTriggerType(UccConstants.TriggerType.THRESHOLD);
        UccPriceAnomalyItemPO set = new UccPriceAnomalyItemPO();
        set.setIsDeleted(UccConstants.DelTag.DEL.toString());
        this.uccPriceAnomalyItemMapper.updateBy(set, where);
        if (!CollectionUtils.isEmpty(uccPriceAnomalyItemPoList)) {
            this.uccPriceAnomalyItemMapper.insertBatch(uccPriceAnomalyItemPoList);
        }
        if (CollectionUtils.isEmpty(uccPriceAnomalyItemPoList)) {
            rspBo.setIsCheck(Boolean.valueOf(false));
        } else {
            rspBo.setIsCheck(Boolean.valueOf(true));
            Map<Long, String> collectMap = skuInfoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getExtSkuId));
            HashMap stringListMap = new HashMap();
            Map<Integer, List<UccPriceAnomalyItemPO>> collect2 = uccPriceAnomalyItemPoList.stream().collect(Collectors.groupingBy(UccPriceAnomalyItemPO::getChangePriceType));
            collect2.keySet().forEach(o -> {
                Map<String, String> expStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(PCodeConstant.UCC_PRICE_WARN_TYPE_DIC.getCode());
                String desc = "\u60a8\u9009\u62e9\u7684\u5546\u54c1\u4e2d\u5305\u542b\u4e86\u8d85\u8fc7" + expStateMap.get(o.toString()) + "\u683c\u9600\u503c\u7ebf\u7684\u5546\u54c1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f";
                ArrayList skuCodeList = new ArrayList();
                ((List)collect2.get(o)).forEach(value -> skuCodeList.add(collectMap.get(value.getSkuId())));
                stringListMap.put(desc, skuCodeList);
            });
            rspBo.setSkuPriceSurpassVptMap(stringListMap);
            if (!reqBo.getIsCheck().booleanValue()) {
                try {
                    this.dealXwgl(uccSkuPos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5546\u54c1\u9600\u503c\u53d1\u9001\u9884\u8b66\u5931\u8d25\uff0c\u5931\u8d25\u5546\u54c1\u4e3a{}", (Object)reqBo.getSkuIds());
                }
            }
        }
        return rspBo;
    }

    private void dealXwgl(List<UccSkuPo> uccSkuPos) {
        XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.getXwglRuleGetNoauthDetailRspBo();
        ArrayList xwglLogs = new ArrayList();
        XwgLSaveLogReqBo xwgLSaveLogReqBo = new XwgLSaveLogReqBo();
        uccSkuPos.forEach(o -> {
            XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
            x.setBusinessName(o.getSkuName());
            x.setBusinessId(o.getExtSkuId());
            x.setBusinessCode(o.getSkuCode());
            x.setIsZj(Integer.valueOf(1));
            x.setBusinessUrl(this.uccSkuDetailUrl + o.getSkuId() + "&supplierShopId=" + o.getSupplierShopId());
            x.setRulId(expRuleRspBo.getRuleId());
            if (ObjectUtil.isNotEmpty((Object)o.getCreateOperId())) {
                x.setManagerId(Long.valueOf(o.getCreateOperId()));
            } else {
                x.setManagerId(Long.valueOf(1L));
            }
            if (ObjectUtil.isNotEmpty((Object)o.getCreateOperName())) {
                x.setManagerName(o.getCreateOperName());
            } else {
                x.setManagerName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            x.setCompanyId(o.getOrgId() + "");
            x.setDeptId(o.getOrgId() + "");
            x.setCompanyName(o.getOrgName());
            x.setDeptName(o.getOrgName());
            xwglLogs.add(x);
        });
        xwgLSaveLogReqBo.setXwglLogs(xwglLogs);
        xwgLSaveLogReqBo.setUserId(Long.valueOf(1L));
        xwgLSaveLogReqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        log.debug("dealSkuSurpassVpt-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)xwgLSaveLogReqBo));
        XwgLSaveLogRspBo xwgLSaveLogRspBo = this.xwglSaveLogAbilityService.saveXwglLog(xwgLSaveLogReqBo);
        log.debug("dealSkuSurpassVpt-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)xwgLSaveLogRspBo));
    }

    private XwglRuleGetNoauthDetailRspBo getXwglRuleGetNoauthDetailRspBo() {
        XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
        ruleReqBo.setRuleNo(this.uccSkuSurpassRuleNo);
        XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
        log.debug("dealSkuSurpassVpt-\u4ef7\u683c\u9600\u503c\u9884\u8b66\u89c4\u5219\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)expRuleRspBo));
        if (!"0000".equals(expRuleRspBo.getRespCode())) {
            throw new BusinessException(expRuleRspBo.getRespCode(), expRuleRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleContent()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleName())) {
            throw new BusinessException("8888", "\u89c4\u5219\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
        }
        return expRuleRspBo;
    }

    private void getResult(UccMallPriceRangeExtPO extPo, BigDecimal dataPrice, BigDecimal skuPrice, Long skuId, Map<Long, Integer> skuSurVptMap, List<UccPriceAnomalyItemPO> uccPriceAnomalyItemPoList, Date date) {
        if (BigDecimal.ZERO.compareTo(extPo.getNumEnd()) == 0 && skuPrice.compareTo(extPo.getNumStart()) > 0 || skuPrice.compareTo(extPo.getNumStart()) > 0 && skuPrice.compareTo(extPo.getNumEnd()) < 1) {
            BigDecimal max = skuPrice.multiply(BigDecimal.ONE.add(extPo.getMaxPercentage().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP)));
            BigDecimal min = skuPrice.multiply(BigDecimal.ONE.subtract(extPo.getMinPercentage().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP)));
            if (dataPrice.compareTo(max) > 0 || dataPrice.compareTo(min) < 0) {
                skuSurVptMap.put(skuId, 1);
                UccPriceAnomalyItemPO uccPriceAnomalyItemPo = new UccPriceAnomalyItemPO();
                uccPriceAnomalyItemPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccPriceAnomalyItemPo.setSkuId(skuId);
                uccPriceAnomalyItemPo.setChangePriceType(extPo.getRangeType());
                uccPriceAnomalyItemPo.setTriggerType(UccConstants.TriggerType.THRESHOLD);
                uccPriceAnomalyItemPo.setIsDeleted(UccConstants.DelTag.NOT_DEL.toString());
                uccPriceAnomalyItemPo.setCreateTime(date);
                BigDecimal bigDecimal = dataPrice.subtract(skuPrice).divide(skuPrice, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                uccPriceAnomalyItemPo.setFloatingRate(bigDecimal);
                uccPriceAnomalyItemPoList.add(uccPriceAnomalyItemPo);
            }
        }
    }
}

