/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.UccStandardCodeApplyResultSyncAbilityBO;
import com.tydic.commodity.common.ability.bo.UccStandardCodeApplyResultSyncAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardCodeApplyResultSyncAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardCodeApplyResultSyncBusiService;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccStandardComInfoMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccPushLogPO;
import com.tydic.commodity.po.UccStandardComInfoPO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccStandardCodeApplyResultSyncBusiServiceImpl
implements UccStandardCodeApplyResultSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardCodeApplyResultSyncBusiServiceImpl.class);
    @Autowired
    private UccStandardComInfoMapper uccStandardComInfoMapper;
    @Autowired
    private UccPushLogMapper uccPushLogMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccStandardCodeApplyResultSyncAbilityRspBO dealStandardCodeApplyResultSync(UccStandardCodeApplyResultSyncAbilityReqBO reqBO) {
        UccPushLogPO uccPushLogPO = new UccPushLogPO();
        uccPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uccPushLogPO.setCreateTime(new Date());
        uccPushLogPO.setType(Integer.valueOf(101));
        uccPushLogPO.setReqJson(JSON.toJSONString((Object)reqBO));
        try {
            List materialCodes = reqBO.getAssignResultList().stream().map(UccStandardCodeApplyResultSyncAbilityBO::getMaterialCode).collect(Collectors.toList());
            List materialPOS = this.uccEMdmMaterialMapper.getListByCodes(materialCodes);
            Map<Object, Object> materialMap = !CollectionUtils.isEmpty((Collection)materialPOS) ? materialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialCode, o -> o)) : new HashMap();
            List standardComInfoPOS = reqBO.getAssignResultList().stream().map(e -> {
                UccStandardComInfoPO standardComInfoPO = (UccStandardComInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)e), UccStandardComInfoPO.class);
                standardComInfoPO.setExtStandardComId(e.getSpuId());
                standardComInfoPO.setMaterialCode(e.getMaterialCode());
                standardComInfoPO.setMaterialName(e.getMaterialName());
                standardComInfoPO.setExt2(e.getMaterialDesc());
                standardComInfoPO.setMaterialType(Integer.valueOf(1));
                if (materialMap.containsKey(e.getMaterialCode()) && ((UccEMdmMaterialPO)materialMap.get(e.getMaterialCode())).getMaterialId() != null) {
                    standardComInfoPO.setMaterialId(((UccEMdmMaterialPO)materialMap.get(e.getMaterialCode())).getMaterialId().toString());
                }
                return standardComInfoPO;
            }).collect(Collectors.toList());
            this.uccStandardComInfoMapper.updateBatchCode(standardComInfoPOS);
            this.uccSkuMapper.updateBatchCode(standardComInfoPOS);
            uccPushLogPO.setStatus(Integer.valueOf(1));
        }
        catch (Exception e2) {
            uccPushLogPO.setStatus(Integer.valueOf(0));
            e2.printStackTrace();
            log.error("\u5931\u8d25" + e2.getMessage());
        }
        this.uccPushLogMapper.insert(uccPushLogPO);
        UccStandardCodeApplyResultSyncAbilityRspBO rspBO = new UccStandardCodeApplyResultSyncAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setStandardComIdList(reqBO.getAssignResultList().stream().map(UccStandardCodeApplyResultSyncAbilityBO::getSpuId).collect(Collectors.toList()));
        return rspBO;
    }
}

