/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.common.ability.api.UccCheckBuyerAbilityService;
import com.tydic.commodity.common.ability.bo.UccCheckBuyerAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCheckBuyerAbilityRspBO;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionBO;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCheckBuyerAbilityService"})
public class UccCheckBuyerAbilityServiceImpl
implements UccCheckBuyerAbilityService {
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"checkUccBuyer"})
    public UccCheckBuyerAbilityRspBO checkUccBuyer(@RequestBody UccCheckBuyerAbilityReqBO reqBO) {
        List uccOrgSkuWhiteRestrictionPos;
        List uccSkuPos;
        UccCheckBuyerAbilityRspBO rspBO = new UccCheckBuyerAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isEmpty((Object)reqBO.getOccupation())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7528\u6237\u7684occupation\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2\u4e70\u53d7\u4eba");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u7684\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Object> orgIds = new ArrayList<Object>();
        DycUmcQueryBuyerPermissionReqBo permissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
        permissionReqBo.setErpCode(reqBO.getOccupation());
        permissionReqBo.setPageFlag(false);
        DycUmcQueryBuyerPermissionRspBo permissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(permissionReqBo);
        if (!CollectionUtils.isEmpty((Collection)permissionRspBo.getRows())) {
            if (!StringUtils.isEmpty((Object)reqBO.getOrgCodeWeb())) {
                Map<String, List<DycUmcQueryBuyerPermissionBO>> orgCodeMap = permissionRspBo.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrgCode())).collect(Collectors.groupingBy(DycUmcQueryBuyerPermissionBO::getOrgCode));
                if (orgCodeMap.containsKey(reqBO.getOrgCodeWeb())) {
                    List buyerPermissionBOS = (List)orgCodeMap.get(reqBO.getOrgCodeWeb());
                    List collect = buyerPermissionBOS.stream().map(DycUmcQueryBuyerPermissionBO::getOrgId).collect(Collectors.toList());
                    orgIds.addAll(collect);
                }
            } else {
                for (DycUmcQueryBuyerPermissionBO buyerPermissionBO : permissionRspBo.getRows()) {
                    orgIds.add(buyerPermissionBO.getOrgId());
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds())))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        HashMap<Long, String> failSkuMap = new HashMap<Long, String>();
        Map<Long, List<UccSkuPo>> commodityIdSkuMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
        List commodityIds = uccSkuPos.stream().filter(e -> e.getCommodityId() != null).map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityIds) && !CollectionUtils.isEmpty((Collection)(uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.qryCommdInfoByCommodityIds(commodityIds)))) {
            Map<Long, List<UccOrgSkuWhiteRestrictionPo>> commodityIdWhiteRestrictionMap = uccOrgSkuWhiteRestrictionPos.stream().collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getCommodityId));
            Set<Long> keys = commodityIdWhiteRestrictionMap.keySet();
            for (Long key : keys) {
                List<UccOrgSkuWhiteRestrictionPo> pos = commodityIdWhiteRestrictionMap.get(key);
                List whiteOrgIds = pos.stream().filter(e -> e.getOrgId() != null).map(UccOrgSkuWhiteRestrictionPo::getOrgId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(whiteOrgIds) || !Collections.disjoint(orgIds, whiteOrgIds)) continue;
                List<UccSkuPo> failPos = commodityIdSkuMap.get(key);
                for (UccSkuPo failPo : failPos) {
                    failSkuMap.put(failPo.getSkuId(), failPo.getSkuCode());
                }
            }
        }
        rspBO.setFailSkuMap(failSkuMap);
        return rspBO;
    }
}

