/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccMaterialSearchService;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.MdmMaterialQryModelBO;
import com.tydic.commodity.common.ability.bo.MdmMaterialQryParamBO;
import com.tydic.commodity.common.ability.bo.MdmMustTerms;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchRspBo;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.external.util.HttpUtil;
import com.tydic.commodity.common.external.util.MdmAuthUtil;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService"})
public class UccThematerialsearchAbilityServiceImpl
implements UccThematerialsearchAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccThematerialsearchAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccMaterialSearchService uccMaterialSearchService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Value(value="${mdm.material.qry.url:http://172.20.175.66:32176/api/wzbm/queryWzbmPage}")
    private String mdmMateruialQryUrl;
    @Value(value="${mdm.material.qry.appKey:123456}")
    private String appKey;
    @Value(value="${mdm.material.qry.secret:abcdef}")
    private String secret;

    @PostMapping(value={"dealUccThematerialsearch"})
    public UccThematerialsearchAbilityRspBO dealUccThematerialsearch(@RequestBody UccThematerialsearchAbilityReqBO reqBO) {
        List uccCommodityTypePos;
        List catalogIds;
        UccThematerialsearchAbilityRspBO rspBO = new UccThematerialsearchAbilityRspBO();
        if (reqBO.getPageNo() == -1) {
            reqBO.setPageNo(1);
            reqBO.setPageSize(50000);
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        if ("1".equals(reqBO.getPurchasePlanQryFlag())) {
            List rows = this.uccEMdmMaterialMapper.getPurchasePlanMaterialList(reqBO.getMaterialCode(), reqBO.getCatalogId(), page);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRows(rows);
            return rspBO;
        }
        if ("2".equals(reqBO.getPurchasePlanQryFlag())) {
            List rows = this.uccEMdmMaterialMapper.getPlanMaterialList(reqBO.getMaterialCode(), reqBO.getCatalogId(), page);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRows(rows);
            return rspBO;
        }
        UccEMdmMaterialPO po = new UccEMdmMaterialPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        UccMaterialSearchReqBo uccMaterialSearchReqBo = new UccMaterialSearchReqBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMaterialSearchReqBo);
        uccMaterialSearchReqBo.setLikeFields((List)Lists.newArrayList((Object[])new String[]{"materialCode", "materialName", "spec", "model"}));
        UccMaterialSearchRspBo uccMaterialSearchRspBo = this.uccMaterialSearchService.searchMaterial(uccMaterialSearchReqBo);
        if (CollectionUtils.isEmpty((Collection)uccMaterialSearchRspBo.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRecordsTotal(uccMaterialSearchRspBo.getRecordsTotal());
        rspBO.setTotal(uccMaterialSearchRspBo.getTotal());
        rspBO.setPageNo(reqBO.getPageNo());
        List uccEMdmMaterialBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccMaterialSearchRspBo.getRows()), UccEMdmMaterialBO.class);
        Map<String, String> isDeleteMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_IS_DELETE");
        Map<String, String> freezbMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_FREEZE_FLAG");
        Map<String, String> sourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_SOURCE");
        for (UccEMdmMaterialBO each2 : uccEMdmMaterialBOS) {
            if (isDeleteMap != null && isDeleteMap.containsKey(each2.getIsDelete().toString())) {
                each2.setIsDeleteDesc(isDeleteMap.get(each2.getIsDelete().toString()));
            }
            if (freezbMap != null && freezbMap.containsKey(each2.getFreezeFlag().toString())) {
                each2.setFreezeFlagDesc(freezbMap.get(each2.getFreezeFlag().toString()));
            }
            if (sourceMap == null || !sourceMap.containsKey(each2.getSource().toString())) continue;
            each2.setSourceDesc(sourceMap.get(each2.getSource().toString()));
        }
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialBOS)) {
            catalogIds = uccEMdmMaterialBOS.stream().map(UccEMdmMaterialBO::getCatalogId).collect(Collectors.toList());
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
            Map<Long, List<UccEMdmCatalogPO>> catalogIdLogMap = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
            for (UccEMdmMaterialBO uccEMdmMaterialBO : uccEMdmMaterialBOS) {
                if (catalogIdLogMap.get(uccEMdmMaterialBO.getCatalogId()) == null) continue;
                uccEMdmMaterialBO.setInImplementCatalog(catalogIdLogMap.get(uccEMdmMaterialBO.getCatalogId()).get(0).getInImplementCatalog());
                uccEMdmMaterialBO.setInControlsCatalog(catalogIdLogMap.get(uccEMdmMaterialBO.getCatalogId()).get(0).getInControlsCatalog());
                uccEMdmMaterialBO.setCatalogCode(catalogIdLogMap.get(uccEMdmMaterialBO.getCatalogId()).get(0).getCatalogCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialBOS) && !CollectionUtils.isEmpty((Collection)(uccCommodityTypePos = this.uccCommodityTypeMapper.qryCommodityTypesByCategorys(catalogIds = uccEMdmMaterialBOS.stream().map(a -> a.getCatalogId()).distinct().collect(Collectors.toList()))))) {
            Map<Long, UccCommodityTypePo> catAndPo = uccCommodityTypePos.stream().collect(Collectors.toMap(a -> a.getCatalogId(), b -> b, (o, n) -> o));
            uccEMdmMaterialBOS.forEach(each -> {
                if (catAndPo.get(each.getCatalogId()) != null) {
                    each.setCommodityTypeId(((UccCommodityTypePo)catAndPo.get(each.getCatalogId())).getCommodityTypeId());
                    each.setCommodityTypeName(((UccCommodityTypePo)catAndPo.get(each.getCatalogId())).getCommodityTypeName());
                }
            });
        }
        rspBO.setRows(uccEMdmMaterialBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"searchMdmMaterialList"})
    public UccThematerialsearchAbilityRspBO searchMdmMaterialList(@RequestBody UccThematerialsearchAbilityReqBO reqBO) {
        UccThematerialsearchAbilityRspBO rspBO = new UccThematerialsearchAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            MdmMaterialQryParamBO qryParamBO = new MdmMaterialQryParamBO();
            ArrayList<MdmMustTerms> mustTermsList = new ArrayList<MdmMustTerms>();
            MdmMustTerms mdmMustTermsCode = new MdmMustTerms();
            mdmMustTermsCode.setName("code");
            mdmMustTermsCode.setExists(Boolean.TRUE);
            mustTermsList.add(mdmMustTermsCode);
            MdmMustTerms mdmMustTermsStatus = new MdmMustTerms();
            mdmMustTermsStatus.setName("status");
            mdmMustTermsStatus.setExists(Boolean.TRUE);
            mdmMustTermsStatus.setValueList(Arrays.asList("1"));
            mustTermsList.add(mdmMustTermsStatus);
            qryParamBO.setMustTermsList(mustTermsList);
            qryParamBO.setPageNo(Integer.valueOf(reqBO.getPageNo()));
            qryParamBO.setPageSize(Integer.valueOf(reqBO.getPageSize()));
            qryParamBO.setQueryStr(reqBO.getMaterialCode());
            qryParamBO.setTreePath(this.splitString(reqBO.getCatalogCode()));
            String header = this.buildHeader();
            String result = HttpUtil.doPost(this.mdmMateruialQryUrl, JSON.toJSONString((Object)qryParamBO), header);
            log.info("searchMdmMaterialList result:{}", (Object)result);
            this.rspResult(result, rspBO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        return rspBO;
    }

    private void rspResult(String result, UccThematerialsearchAbilityRspBO rspBO) {
        if (StringUtils.isEmpty((Object)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u7269\u6599\u7cfb\u7edf\u8fd4\u56de\u7a7a");
        }
        MdmMaterialQryModelBO mdmMaterialQryModelBO = (MdmMaterialQryModelBO)JSON.parseObject((String)result, MdmMaterialQryModelBO.class);
        if (!"0000".equals(mdmMaterialQryModelBO.getCode())) {
            throw new ZTBusinessException(mdmMaterialQryModelBO.getMessage());
        }
        rspBO.setRecordsTotal(mdmMaterialQryModelBO.getRecordsTotal().intValue());
        rspBO.setPageNo(mdmMaterialQryModelBO.getPageNo().intValue());
        rspBO.setTotal(mdmMaterialQryModelBO.getTotal().intValue());
        List wzbmList = mdmMaterialQryModelBO.getWzbmList();
        if (!CollectionUtils.isEmpty((Collection)wzbmList)) {
            rspBO.setRows(wzbmList.stream().map(item -> {
                UccEMdmMaterialBO uccEMdmMaterialBO = new UccEMdmMaterialBO();
                uccEMdmMaterialBO.setCatalogCode(item.getCategory_id());
                uccEMdmMaterialBO.setCatalogName(item.getCategory_name());
                uccEMdmMaterialBO.setMaterialCode(item.getCode());
                uccEMdmMaterialBO.setMaterialName(item.getDesc1());
                uccEMdmMaterialBO.setMeasure(item.getDesc5());
                return uccEMdmMaterialBO;
            }).collect(Collectors.toList()));
        }
    }

    private String buildHeader() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dateFormat.format(new Date());
        HashMap<String, String> header = new HashMap<String, String>();
        String auth = MdmAuthUtil.getAuth(this.appKey, this.secret, format);
        header.put("auth", auth);
        return JSON.toJSONString(header);
    }

    private String splitString(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        int twoCharLength = 2;
        int totalLength = str.length();
        int multiple = totalLength / twoCharLength;
        StringBuffer result = null;
        for (int i = 1; i <= multiple; ++i) {
            if (i == 1) {
                result = new StringBuffer(str.substring(0, 2));
                continue;
            }
            int index = i * twoCharLength;
            result.append("_" + str.substring(0, index));
        }
        return result.toString();
    }
}

