/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccCancelApprovalAbilityService;
import com.tydic.commodity.estore.ability.bo.UccCancelApprovalAbilityReqBo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditOrderSyncAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccCancelApprovalAbilityService"})
public class UccCancelApprovalAbilityServiceImpl
implements UccCancelApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCancelApprovalAbilityServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UacNoTaskAuditOrderSyncAbilityService uacNoTaskAuditOrderSyncAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @PostMapping(value={"cancelApproval"})
    public RspUccBo cancelApproval(@RequestBody UccCancelApprovalAbilityReqBo reqBo) {
        RspUccBo rspBo = new RspUccBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
        uacNoTaskAuditCancelReqBO.setObjId(reqBo.getObjId());
        uacNoTaskAuditCancelReqBO.setObjType(reqBo.getObjType());
        uacNoTaskAuditCancelReqBO.setOperDept(reqBo.getOperDept());
        uacNoTaskAuditCancelReqBO.setOperId(reqBo.getOperId());
        uacNoTaskAuditCancelReqBO.setCancelOperId(reqBo.getCancelOperId());
        uacNoTaskAuditCancelReqBO.setCancelReason(reqBo.getCancelReason());
        UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
        if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
            UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(reqBo.getObjId());
            if (uccSkuPo != null && uccSkuPo.getApprovalStatus() != null) {
                this.dealCancelTodo(uccSkuPo);
            }
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(uacNoTaskAuditCancelRspBO.getRespDesc());
            return rspBo;
        }
        if (reqBo.isSyncOrder()) {
            UacNoTaskAuditOrderSyncReqBO uocAuditOrderSyncReqBO = new UacNoTaskAuditOrderSyncReqBO();
            uocAuditOrderSyncReqBO.setObjType(reqBo.getObjType());
            uocAuditOrderSyncReqBO.setOperDept(reqBo.getOperDept());
            uocAuditOrderSyncReqBO.setAuditAdvice(reqBo.getCancelReason());
            uocAuditOrderSyncReqBO.setDownload("");
            uocAuditOrderSyncReqBO.setOperid(reqBo.getOperId());
            uocAuditOrderSyncReqBO.setObjId((List)Lists.newArrayList((Object[])new String[]{reqBo.getObjId()}));
            HashMap<String, String> ext = new HashMap<String, String>();
            ext.put("dealStepName", reqBo.getCancelReason());
            uocAuditOrderSyncReqBO.setExt(ext);
            UacNoTaskAuditOrderSyncRspBO uocAuditOrderSyncBusiRspBO = this.uacNoTaskAuditOrderSyncAbilityService.dealAuditOrderSync(uocAuditOrderSyncReqBO);
            if ("0000".equals(uocAuditOrderSyncBusiRspBO.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(uocAuditOrderSyncBusiRspBO.getRespDesc());
                return rspBo;
            }
        }
        return rspBo;
    }

    private void dealCancelTodo(UccSkuPo uccSkuPo) {
        switch (uccSkuPo.getApprovalStatus()) {
            case 21: {
                this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2001", "\u7535\u5546\u5546\u54c1\u4e0a\u67b6");
                break;
            }
            case 31: {
                Long objId = uccSkuPo.getCommodityId() == null ? uccSkuPo.getSkuId() : uccSkuPo.getCommodityId();
                this.cancelWaitDone(objId, ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT, "2008", "\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                break;
            }
            case 41: {
                this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN, "2002", "\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                break;
            }
            case 51: {
                this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER, "2003", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                break;
            }
        }
    }

    private void cancelWaitDone(Long skuId, Integer objType, String busiCode, String busiName) {
        try {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(objType);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a\uff01");
            }
            try {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setBusiCode(busiCode);
                todoUccWaitAbilityReqBO.setBusiName(busiName);
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setObjId(skuId);
                todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
                UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
                uccDealHandlerReqBO.setHandleName("handler");
                this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            }
            catch (Exception e) {
                log.error("taskTodoWaitService error:{}", (Throwable)e);
            }
        }
        catch (Exception ex) {
            log.error("\u53d6\u6d88\u5ba1\u6279\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }
}

