/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccBrandCheckAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccBrandCheckAbilityRspBo;
import com.tydic.commodity.estore.busi.api.UccBrandCheckBusiService;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBrandCheckBusiServiceImpl
implements UccBrandCheckBusiService {
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @Override
    public UccBrandCheckAbilityRspBo getBrandCheckSku(UccBrandCheckAbilityReqBo reqBo) {
        UccBrandCheckAbilityRspBo rspBo = new UccBrandCheckAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u4f20\u5165skuId");
            return rspBo;
        }
        ArrayList<Long> disValidSkuIds = new ArrayList<Long>();
        ArrayList<Long> notRelSkuIds = new ArrayList<Long>();
        ArrayList<String> disValidSkuCodes = new ArrayList<String>();
        ArrayList<String> notRelSkuCodes = new ArrayList<String>();
        List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrandExt(reqBo.getSkuIds());
        if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
            ArrayList<Long> validSkuIds = new ArrayList<Long>();
            for (UccSkuBrandPo uccSkuBrandPo : uccSkuBrandPos) {
                if (uccSkuBrandPo.getBrandVerify() != null && uccSkuBrandPo.getBrandVerify() == 1) {
                    if (uccSkuBrandPo.getBrandId() == null) {
                        notRelSkuIds.add(uccSkuBrandPo.getSkuId());
                        notRelSkuCodes.add(uccSkuBrandPo.getSkuCode());
                        continue;
                    }
                    if (uccSkuBrandPo.getBrandStatus() == null || uccSkuBrandPo.getBrandStatus() != 1) {
                        disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        disValidSkuCodes.add(uccSkuBrandPo.getSkuCode());
                        continue;
                    }
                    if (uccSkuBrandPo.getAppRange() == null || uccSkuBrandPo.getAppRange() == 2) {
                        disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        disValidSkuCodes.add(uccSkuBrandPo.getSkuCode());
                        continue;
                    }
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                    uccRelCatalogBrandVendorPO.setCatalogId(uccSkuBrandPo.getCatalogId());
                    uccRelCatalogBrandVendorPO.setBrandId(uccSkuBrandPo.getBrandId());
                    uccRelCatalogBrandVendorPO.setVendorId(uccSkuBrandPo.getSupplierShopId());
                    uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
                    List uccRelCatalogBrandVendorPOS = this.uccBrandDealMapper.getRelCatalogBrandVendor(uccRelCatalogBrandVendorPO);
                    if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                        disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        disValidSkuCodes.add(uccSkuBrandPo.getSkuCode());
                        continue;
                    }
                    if (((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() == null || ((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() != 1) {
                        disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        disValidSkuCodes.add(uccSkuBrandPo.getSkuCode());
                        continue;
                    }
                    validSkuIds.add(uccSkuBrandPo.getSkuId());
                    continue;
                }
                validSkuIds.add(uccSkuBrandPo.getSkuId());
            }
            if (!CollectionUtils.isEmpty(validSkuIds)) {
                this.uccSkuMapper.batchUpdateSkuStatusByIds(validSkuIds, Integer.valueOf(2), null);
                rspBo.setValidSkuIds(validSkuIds);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(validSkuIds);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            }
        }
        rspBo.setNotRelSkuIds(notRelSkuIds);
        rspBo.setDisValidSkuIds(disValidSkuIds);
        rspBo.setNotRelSkuCodes(notRelSkuCodes);
        rspBo.setDisValidSkuCodes(disValidSkuCodes);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

