/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccPicCompressAbilityService;
import com.tydic.commodity.estore.ability.bo.UccPicCompressAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccPicCompressAbilityRspBo;
import com.tydic.commodity.estore.busi.api.UccPicCompressBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccPicCompressAbilityService"})
public class UccPicCompressAbilityServiceImpl
implements UccPicCompressAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPicCompressAbilityServiceImpl.class);
    @Autowired
    private UccPicCompressBusiService uccPicCompressBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealPicCompress"})
    public UccPicCompressAbilityRspBo dealPicCompress(@RequestBody UccPicCompressAbilityReqBo reqBo) {
        UccPicCompressAbilityRspBo rspBo = new UccPicCompressAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, 500);
                List dealSkuIds = this.uccSkuMapper.getStaffSupermarketSku(page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (CollectionUtils.isEmpty((Collection)dealSkuIds)) continue;
                reqBo.setSkuIds(dealSkuIds);
                rspBo = this.uccPicCompressBusiService.dealPicCompress(reqBo);
                if (!"0000".equals(rspBo.getRespCode())) continue;
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
                syncSceneCommodityToEsReqBO.setSkuIds(dealSkuIds);
                syncSceneCommodityToEsReqBO.setSingleType(0);
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            } while (++num <= total);
        } else {
            rspBo = this.uccPicCompressBusiService.dealPicCompress(reqBo);
            if ("0000".equals(rspBo.getRespCode())) {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
                syncSceneCommodityToEsReqBO.setSkuIds(reqBo.getSkuIds());
                syncSceneCommodityToEsReqBO.setSingleType(0);
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBo;
    }
}

