/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccUpdateRemovalMethodService;
import com.tydic.commodity.estore.ability.bo.UccBrandCheckAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccBrandCheckAbilityRspBo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccUpdateRemovalMethodService"})
public class UccUpdateRemovalMethodServiceImpl
implements UccUpdateRemovalMethodService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"updateRemovalMethod"})
    public UccBrandCheckAbilityRspBo updateRemovalMethod(@RequestBody UccBrandCheckAbilityReqBo reqBo) {
        UccBrandCheckAbilityRspBo rspBo = new UccBrandCheckAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u4f20\u5165skuId");
            return rspBo;
        }
        ArrayList<Long> disValidSkuIds = new ArrayList<Long>();
        ArrayList<Long> validSkuIds = new ArrayList<Long>();
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBo.getSkuIds());
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("sku\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return rspBo;
        }
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            if (SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(uccSkuPo.getSkuStatus())) {
                validSkuIds.add(uccSkuPo.getSkuId());
                continue;
            }
            disValidSkuIds.add(uccSkuPo.getSkuId());
        }
        if (!CollectionUtils.isEmpty(validSkuIds)) {
            this.uccSkuMapper.batchUpdateSkuStatusByIds(validSkuIds, Integer.valueOf(5), null);
            rspBo.setValidSkuIds(validSkuIds);
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(validSkuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
        rspBo.setDisValidSkuIds(disValidSkuIds);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

