/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealHandlerTaskJobAbilityReqBO;
import com.tydic.commodity.base.constant.ApproveEntrustConstant;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerTaskJobBusiService;
import com.tydic.commodity.common.ability.bo.UccApproveEntrustNotificationAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAutoHideCatalogStandardSkuAbilityReqBO;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.estore.ability.api.CceUccBrandApplyAuditAbilityService;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityRspBo;
import com.tydic.commodity.estore.atom.api.UccWechatTemplateMsgSendAtomService;
import com.tydic.commodity.estore.atom.bo.UccWechatTemplateMsgDataFieldAtomBO;
import com.tydic.commodity.estore.atom.bo.UccWechatTemplateMsgSendAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccWechatTemplateMsgSendAtomRspBO;
import com.tydic.commodity.estore.busi.api.CceUccBrandApplyAuditBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.umc.general.ability.api.UmcGetOpenIdForPushAbilityService;
import com.tydic.umc.general.ability.bo.UmcGetOpenIdForPushAbilityReqBo;
import com.tydic.umc.general.ability.bo.UmcGetOpenIdForPushAbilityRspBo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.CceUccBrandApplyAuditAbilityService"})
public class CceUccBrandApplyAuditAbilityServiceImpl
implements CceUccBrandApplyAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CceUccBrandApplyAuditAbilityServiceImpl.class);
    @Autowired
    private CceUccBrandApplyAuditBusiService cceUccBrandApplyAuditBusiService;
    @Resource(name="brandSkuHideProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_HIDE_TOPIC:BRAND_SKU_HIDE_TOPIC}")
    private String brandSkuHideTopic;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    public static final Integer OPER_TYPE_HIDE_CATALOG = 1;
    public static final Integer OPER_TYPE_DISPLAY_CATALOG = 2;
    public static final Integer OPER_TYPE_HIDE_BANNER = 3;
    @Autowired
    private UccDealHandlerTaskJobBusiService uccDealHandlerTaskJobBusiService;
    @Resource(name="mqUccApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUccApproveEntrustNotificationProvider;
    @Value(value="${UCC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UCC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uccApproveEntrustNotificationTopic;
    @Value(value="${UCC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uccApproveEntrustNotificationTag;
    @Autowired
    private UmcGetOpenIdForPushAbilityService umcGetOpenIdForPushAbilityService;
    @Autowired
    private UccWechatTemplateMsgSendAtomService uccWechatTemplateMsgSendAtomService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"dealBrandApplyAudit"})
    public CceUccBrandApplyAuditAbilityRspBo dealBrandApplyAudit(@RequestBody CceUccBrandApplyAuditAbilityReqBo reqBo) {
        CceUccBrandApplyAuditAbilityRspBo rspBo = this.cceUccBrandApplyAuditBusiService.dealBrandApplyAudit(reqBo);
        UccDealHandlerTaskJobAbilityReqBO taskJobAbilityReqBO = new UccDealHandlerTaskJobAbilityReqBO();
        taskJobAbilityReqBO.setAbPush(Boolean.valueOf(true));
        this.uccDealHandlerTaskJobBusiService.dealHandlerTaskJob(taskJobAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getFinistList())) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(rspBo.getFinistList());
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            Map<Integer, List<BrandApplyPO>> applyRelStatusMap = brandApplyPOS.stream().filter(e -> e.getApplyRelStatus() != null).collect(Collectors.groupingBy(BrandApplyPO::getApplyRelStatus));
            ArrayList<Integer> operType = new ArrayList<Integer>();
            if (applyRelStatusMap.containsKey(2)) {
                operType.add(OPER_TYPE_DISPLAY_CATALOG);
            }
            if (applyRelStatusMap.containsKey(1)) {
                operType.add(OPER_TYPE_HIDE_BANNER);
            }
            if (!CollectionUtils.isEmpty(operType)) {
                UccAutoHideCatalogStandardSkuAbilityReqBO abilityReqBO = new UccAutoHideCatalogStandardSkuAbilityReqBO();
                try {
                    this.proxyMessageProducer.send(new ProxyMessage(this.brandSkuHideTopic, "*", JSON.toJSONString((Object)abilityReqBO)));
                }
                catch (Exception e2) {
                    log.error("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBo.getSendWechatList())) {
            BrandApplyPO brandApplyPo = new BrandApplyPO();
            brandApplyPo.setIds(rspBo.getSendWechatList());
            List brandApplyPos = this.brandApplyMapper.getList(brandApplyPo);
            if (!CollectionUtils.isEmpty((Collection)brandApplyPos)) {
                try {
                    this.sendVxNotice(reqBo, brandApplyPos);
                }
                catch (Exception e3) {
                    log.error("\u63a8\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u901a\u77e5\u5931\u8d25", (Throwable)e3);
                }
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspBo.getAuditNoticeList())) {
            UccApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UccApproveEntrustNotificationAbilityReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBo.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(ApproveEntrustConstant.ApproveEntrustType.CREATE_BRAND_APPLY);
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqUccApproveEntrustNotificationProvider.send(new ProxyMessage(this.uccApproveEntrustNotificationTopic, this.uccApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e4) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e4.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        return rspBo;
    }

    private void sendVxNotice(CceUccBrandApplyAuditAbilityReqBo reqBo, List<BrandApplyPO> brandApplyPos) {
        log.error("\u54c1\u724c\u4e0a\u67b6\u5ba1\u6279|\u63a8\u9001\u516c\u4f17\u53f7\u5165\u53c2|{}", (Object)JSON.toJSONString(brandApplyPos));
        for (BrandApplyPO brandApplyPo : brandApplyPos) {
            Long vendorId = brandApplyPo.getVendorId();
            Integer applyStatus = brandApplyPo.getApplyStatus();
            if (applyStatus != 5 && applyStatus != 4) {
                return;
            }
            UmcGetOpenIdForPushAbilityReqBo openIdForPushAbilityReqBo = new UmcGetOpenIdForPushAbilityReqBo();
            openIdForPushAbilityReqBo.setObjType(Integer.valueOf(1));
            ArrayList<String> objIds = new ArrayList<String>();
            objIds.add(String.valueOf(vendorId));
            openIdForPushAbilityReqBo.setObjIds(objIds);
            UmcGetOpenIdForPushAbilityRspBo openIdForPush = this.umcGetOpenIdForPushAbilityService.getOpenIdForPush(openIdForPushAbilityReqBo);
            log.error("\u54c1\u724c\u4e0a\u67b6\u5ba1\u6279|\u67e5\u8be2openid\u4fe1\u606f\u4e3a|{}", (Object)JSON.toJSONString((Object)openIdForPush));
            if (!openIdForPush.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)openIdForPush.getOpenIds())) continue;
            UccBrandDealPO uccBrandDealPo = new UccBrandDealPO();
            uccBrandDealPo.setBrandId(brandApplyPo.getBrandId());
            UccBrandDealPO brandInfo = this.uccBrandDealMapper.selectById(uccBrandDealPo);
            if (brandInfo == null) continue;
            List openIds = openIdForPush.getOpenIds();
            for (String openId : openIds) {
                UccWechatTemplateMsgSendAtomReqBO templateMsgSendAtomReqBO = new UccWechatTemplateMsgSendAtomReqBO();
                templateMsgSendAtomReqBO.setOpenId(openId);
                ArrayList<UccWechatTemplateMsgDataFieldAtomBO> templateFieldList = new ArrayList<UccWechatTemplateMsgDataFieldAtomBO>();
                if (applyStatus == 5) {
                    templateMsgSendAtomReqBO.setTemplateId("fcE89YgC0LDfx80Uo0jSrZYbyDP1QY6LLSCrECaOI_Q");
                } else {
                    templateMsgSendAtomReqBO.setTemplateId("JzkGkB2tFWAykMd61kXCgGkpDoAyGOPEbZpLkZhv77Y");
                }
                UccWechatTemplateMsgDataFieldAtomBO data1 = new UccWechatTemplateMsgDataFieldAtomBO();
                data1.setFieldName("character_string2");
                data1.setFieldValue(brandApplyPo.getApplyCode());
                templateFieldList.add(data1);
                UccWechatTemplateMsgDataFieldAtomBO data2 = new UccWechatTemplateMsgDataFieldAtomBO();
                data2.setFieldName("thing1");
                data2.setFieldValue(brandInfo.getBrandName());
                templateFieldList.add(data2);
                UccWechatTemplateMsgDataFieldAtomBO data3 = new UccWechatTemplateMsgDataFieldAtomBO();
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                data3.setFieldName("time4");
                data3.setFieldValue(sf.format(new Date()));
                templateFieldList.add(data3);
                templateMsgSendAtomReqBO.setTemplateFieldList(templateFieldList);
                UccWechatTemplateMsgSendAtomRspBO atomRspBO = this.uccWechatTemplateMsgSendAtomService.dealSendWechatTemplateMsg(templateMsgSendAtomReqBO);
                if (atomRspBO.getRespCode().equals("0000")) continue;
                log.error("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25,\u53d1\u9001\u5165\u53c2\u4e3a\uff1a{}\uff1b\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)templateMsgSendAtomReqBO), (Object)JSON.toJSONString((Object)((Object)atomRspBO)));
            }
        }
    }
}

