/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccJudgeSkuSurpassVptAbilityService;
import com.tydic.commodity.dao.DataGovernInitMapper;
import com.tydic.commodity.dao.SkuDataGovernRecordMapper;
import com.tydic.commodity.estore.ability.api.SkuPriceGovernAbilityService;
import com.tydic.commodity.estore.ability.bo.CceSkuPriceGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernInfo;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuPriceGovernBusiService;
import com.tydic.commodity.po.DataGovernInitPO;
import com.tydic.commodity.po.SkuDataGovernRecordPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SkuPriceGovernAbilityService"})
public class SkuPriceGovernAbilityServiceImpl
implements SkuPriceGovernAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SkuPriceGovernAbilityServiceImpl.class);
    private UccSkuPriceGovernBusiService uccSkuPriceGovernBusiService;
    @Autowired
    private UccJudgeSkuSurpassVptAbilityService uccJudgeSkuSurpassVptAbilityService;
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private SkuDataGovernRecordMapper skuDataGovernRecordMapper;
    @Autowired
    private DataGovernInitMapper dataGovernInitMapper;
    @Value(value="${data_govern_time_flag:1}")
    private String dataGovernTimeFlag;

    @PostMapping(value={"skuPriceGovernReceive"})
    public SkuPriceGovernRspBO skuPriceGovernReceive(@RequestBody CceSkuPriceGovernReqBO reqBO) {
        SkuPriceGovernRspBO rspBO = new SkuPriceGovernRspBO();
        if (reqBO.getData() == null || CollectionUtils.isEmpty((Collection)reqBO.getData().getSkuInfos())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6cbb\u7406\u63a8\u9001\u6570\u636e\u5355\u54c1\u4ef7\u683c\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
        } else {
            try {
                SkuDataGovernRecordPO skuDataGovernRecordPO = new SkuDataGovernRecordPO();
                skuDataGovernRecordPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                skuDataGovernRecordPO.setMsgGetTime(new Date());
                skuDataGovernRecordPO.setSerialNo(reqBO.getSerialNo());
                skuDataGovernRecordPO.setSkuData(JSONObject.toJSONString((Object)reqBO));
                this.skuDataGovernRecordMapper.insert(skuDataGovernRecordPO);
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u6570\u636e\u6cbb\u7406\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
            }
            if ("1".equals(this.dataGovernTimeFlag)) {
                DataGovernInitPO dataGovernInitPO = new DataGovernInitPO();
                dataGovernInitPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                dataGovernInitPO.setSerialNo(reqBO.getSerialNo());
                dataGovernInitPO.setData(JSONObject.toJSONString((Object)reqBO.getData()));
                dataGovernInitPO.setStatus(Integer.valueOf(0));
                dataGovernInitPO.setType(Integer.valueOf(1));
                dataGovernInitPO.setCreateTime(new Date());
                this.dataGovernInitMapper.insert(dataGovernInitPO);
            } else {
                rspBO = this.uccSkuPriceGovernBusiService.dealSkuPriceGovernBusi(reqBO.getData());
                List list = reqBO.getData().getSkuInfos().stream().filter(a -> !StringUtils.isEmpty((Object)a.getSkuId())).map(a -> Long.valueOf(a.getSkuId())).collect(Collectors.toList());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"skuPriceGovernReceiveInit"})
    public SkuPriceGovernRspBO skuPriceGovernReceiveInit(@RequestBody CceSkuPriceGovernReqBO reqBO) {
        int num = 1;
        int total = 0;
        do {
            Page page = new Page(num, 1000);
            List syncSkus = this.skuDataGovernRecordMapper.getListPageInit(page);
            if (total == 0) {
                total = page.getTotalPages();
            }
            if (CollectionUtils.isEmpty((Collection)syncSkus)) continue;
            CceSkuPriceGovernReqBO cceSkuPriceGovernReqBO = new CceSkuPriceGovernReqBO();
            ArrayList<SkuPriceGovernInfo> skuInfos = new ArrayList<SkuPriceGovernInfo>();
            for (SkuDataGovernRecordPO sku : syncSkus) {
                SkuPriceGovernInfo skuPriceGovernInfo = (SkuPriceGovernInfo)JSONObject.parseObject((String)sku.getSkuData(), SkuPriceGovernInfo.class);
                skuInfos.add(skuPriceGovernInfo);
            }
            SkuPriceGovernReqBO skuPriceGovernReqBO = new SkuPriceGovernReqBO();
            skuPriceGovernReqBO.setSkuInfos(skuInfos);
            cceSkuPriceGovernReqBO.setData(skuPriceGovernReqBO);
            this.skuPriceGovernReceive(cceSkuPriceGovernReqBO);
        } while (++num <= total);
        return null;
    }

    @Autowired
    public void setUccSkuPriceGovernBusiService(UccSkuPriceGovernBusiService uccSkuPriceGovernBusiService) {
        this.uccSkuPriceGovernBusiService = uccSkuPriceGovernBusiService;
    }

    @Autowired
    public void setSyncSceneCommodityToEsAtomService(SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService) {
        this.syncSceneCommodityToEsAtomService = syncSceneCommodityToEsAtomService;
    }
}

