/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardPriceMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.api.UccStandardPriceImportAbilityService;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceImportAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceImportAbilityRspBo;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceImportBo;
import com.tydic.commodity.estore.atom.api.UccEstoreDictionaryAtomService;
import com.tydic.commodity.estore.busi.api.UccStandardPriceImportBusiService;
import com.tydic.commodity.estore.busi.bo.UccStandardPriceImportBusiReqBo;
import com.tydic.commodity.estore.utils.BatchImportUtils;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuStandardPricePO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccStandardPriceImportAbilityService"})
public class UccStandardPriceImportAbilityServiceImpl
implements UccStandardPriceImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardPriceImportAbilityServiceImpl.class);
    @Autowired
    private UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    private static final int size = 3000;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private UccSkuStandardPriceMapper uccSkuStandardPriceMapper;
    @Autowired
    private UccStandardPriceImportBusiService uccStandardPriceImportBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealStandardPriceImport"})
    public UccStandardPriceImportAbilityRspBo dealStandardPriceImport(@RequestBody UccStandardPriceImportAbilityReqBo reqBo) {
        List<Map<String, Object>> importDataMap;
        Map<String, String> rowsMap;
        UccStandardPriceImportAbilityRspBo rspBo = new UccStandardPriceImportAbilityRspBo();
        int titleLine = 5;
        int rowsLine = 7;
        Map<String, String> titleMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("STANDARD_PRICE_IMPORT_TITLE");
        if (!CollectionUtils.isEmpty(titleMap)) {
            titleLine = Integer.valueOf((String)Lists.newArrayList(titleMap.keySet()).get(0));
        }
        if (!CollectionUtils.isEmpty(rowsMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("STANDARD_PRICE_IMPORT_DATA"))) {
            rowsLine = Integer.valueOf((String)Lists.newArrayList(rowsMap.keySet()).get(0));
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<UccStandardPriceImportBo> batchImportUtils = new BatchImportUtils<UccStandardPriceImportBo>(title, data, UccStandardPriceImportBo.class);
            batchImportUtils.batchImport(reqBo.getImportUrl(), titleLine, rowsLine, 3000);
            importDataMap = batchImportUtils.getImportDataMaps();
            log.debug("\u6587\u4ef6\u6570\u636e\u884c------------------------------------" + ((Object)data).toString() + "---------------------------------------------------------------");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}" + e.toString());
            return rspBo;
        }
        Map<String, String> vendorNameMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("ec_vendor_id");
        HashMap vendorMap = new HashMap();
        if (!CollectionUtils.isEmpty(vendorNameMap)) {
            for (Map.Entry<String, String> each : vendorNameMap.entrySet()) {
                if (vendorMap.containsKey(each.getValue())) continue;
                vendorMap.put(each.getValue(), each.getKey());
            }
        }
        HashMap skuMap = new HashMap();
        if (CollectionUtils.isEmpty(importDataMap)) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u6570\u636e");
        }
        for (Map map : importDataMap) {
            Object vendorName = map.get("vendorName");
            if (ObjectUtil.isEmpty(vendorName) || "null".equals(vendorName)) {
                map.put("impRemark", "\u6765\u6e90\u7535\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                map.put("impResult", "1");
                continue;
            }
            if (!vendorMap.containsKey(vendorName.toString())) {
                map.put("impRemark", "\u6765\u6e90\u7535\u5546\u6570\u636e\u586b\u5199\u9519\u8bef\uff01");
                map.put("impResult", "1");
                continue;
            }
            if (skuMap.containsKey(Long.valueOf((String)vendorMap.get(vendorName.toString())))) {
                ((List)skuMap.get(Long.valueOf((String)vendorMap.get(vendorName.toString())))).add(map.get("extSkuId").toString());
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(map.get("extSkuId").toString());
            skuMap.put(Long.valueOf((String)vendorMap.get(vendorName.toString())), arrayList);
        }
        ArrayList skuList = new ArrayList();
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : skuMap.entrySet()) {
            List list;
            if (!CollectionUtils.isEmpty((Collection)((Collection)entry.getValue())) && !CollectionUtils.isEmpty((Collection)(list = this.uccSkuMapper.qerySkusByExtSkuIds((List)entry.getValue(), (Long)entry.getKey())))) {
                skuList.addAll(list);
            }
            UccSkuStandardPricePO uccSkuStandardPricePO = new UccSkuStandardPricePO();
            uccSkuStandardPricePO.setExtSkuIds((List)entry.getValue());
            uccSkuStandardPricePO.setVendorId((Long)entry.getKey());
            List uccSkuStandardPricePOS = this.uccSkuStandardPriceMapper.getList(uccSkuStandardPricePO);
            if (CollectionUtils.isEmpty((Collection)uccSkuStandardPricePOS)) continue;
            arrayList.addAll(uccSkuStandardPricePOS);
        }
        ArrayList<UccStandardPriceImportBo> importBos = new ArrayList<UccStandardPriceImportBo>();
        for (Map<String, Object> map : importDataMap) {
            if (!map.get("impResult").toString().equals("0")) continue;
            UccStandardPriceImportBo uccStandardPriceImportBo = (UccStandardPriceImportBo)JSONObject.parseObject((String)JSONObject.toJSONString(map), UccStandardPriceImportBo.class);
            uccStandardPriceImportBo.setVendorId(Long.valueOf((String)vendorMap.get(uccStandardPriceImportBo.getVendorName())));
            boolean flag = false;
            for (UccSkuStandardPricePO uccSkuStandardPricePO : arrayList) {
                if (!uccStandardPriceImportBo.getVendorId().equals(uccSkuStandardPricePO.getVendorId()) || !uccStandardPriceImportBo.getExtSkuId().equals(uccSkuStandardPricePO.getExtSkuId())) continue;
                map.put("impRemark", "\u5546\u54c1\u5df2\u5b58\u5728\uff01");
                map.put("impResult", "1");
                flag = true;
                break;
            }
            if (flag) continue;
            for (UccSkuPo uccSkuPo : skuList) {
                if (!uccSkuPo.getSupplierShopId().equals(uccStandardPriceImportBo.getVendorId()) || !uccStandardPriceImportBo.getExtSkuId().equals(uccSkuPo.getExtSkuId())) continue;
                uccStandardPriceImportBo.setSkuId(uccSkuPo.getSkuId());
            }
            importBos.add(uccStandardPriceImportBo);
        }
        Long l = Long.valueOf(importDataMap.size()) - Long.valueOf(importBos.size());
        Long l2 = importBos.size();
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(this.exportImportFeedBackResults(importDataMap), reqBo.getMemIdIn(), l2, l);
        rspBo.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        UccStandardPriceImportBusiReqBo uccStandardPriceImportBusiReqBo = new UccStandardPriceImportBusiReqBo();
        uccStandardPriceImportBusiReqBo.setImportBos(importBos);
        this.uccStandardPriceImportBusiService.dealStandardPriceImport(uccStandardPriceImportBusiReqBo);
        if (!CollectionUtils.isEmpty(skuList)) {
            List skuIds = skuList.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Map<String, Object>> exportImportFeedBackResults(List<Map<String, Object>> importDataMap) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (Map<String, Object> mapData : importDataMap) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u5916\u90e8\u5355\u54c1\u7f16\u7801", mapData.get("extSkuId"));
            item.put("\u5355\u54c1\u540d\u79f0", mapData.get("skuName"));
            item.put("\u6765\u6e90\u7535\u5546", mapData.get("vendorName"));
            item.put("\u57fa\u51c6\u4ef7", mapData.get("standardPrice"));
            item.put("\u4e0a\u9650\u6bd4\u7387\uff08%\uff09", mapData.get("upRatio"));
            if (mapData.get("impResult") != null && Integer.parseInt(mapData.get("impResult").toString()) == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (mapData.get("impResult") != null && Integer.parseInt(mapData.get("impResult").toString()) == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", mapData.get("impRemark"));
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, Long memIdIn, Long sucessImportCounts, Long failedImportCounts) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(memIdIn);
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType("UCC_STANDARD_PRICE_IMPORT");
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }
}

