/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.utils.BeanUtils;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.estore.ability.bo.UccCatalogBrandVendorAddInfo;
import com.tydic.commodity.estore.ability.bo.UccCatalogBrandVendorAddReqBO;
import com.tydic.commodity.estore.ability.bo.UccCatalogBrandVendorAddRspBO;
import com.tydic.commodity.estore.busi.api.UccCatalogBrandVendorAddBusiService;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCatalogBrandVendorAddBusiServiceImpl
implements UccCatalogBrandVendorAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogBrandVendorAddBusiServiceImpl.class);
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    public final int MAX_VALUE = 200;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UccCatalogBrandVendorAddRspBO operUccCatalogBrandVendorAdd(UccCatalogBrandVendorAddReqBO reqBO) {
        UccCatalogBrandVendorAddRspBO rspBO = new UccCatalogBrandVendorAddRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getCatalogBrandVendorRelList().size() <= 0) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u4fdd\u5b58\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getCatalogBrandVendorRelList().size() > 200) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u4fdd\u5b58\u5217\u8868\u4e0d\u80fd\u8d85\u8fc7200\u884c\uff01");
            return rspBO;
        }
        if (reqBO.getDiscountFlag() == null) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6298\u6263\u7387\u6807\u8bc6");
            return rspBO;
        }
        String rspValue = this.checkDoubleData(reqBO.getCatalogBrandVendorRelList());
        if (CheckUtil.isNotBlank((String)rspValue)) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc(rspValue);
            return rspBO;
        }
        ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
        int i = 1;
        for (UccCatalogBrandVendorAddInfo relReqBo : reqBO.getCatalogBrandVendorRelList()) {
            UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
            uccRelCatalogBrandVendorPO.setVendorId(relReqBo.getVendorId());
            uccRelCatalogBrandVendorPO.setBrandId(relReqBo.getBrandId());
            uccRelCatalogBrandVendorPO.setCatalogId(relReqBo.getCatalogId());
            List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
            if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                UccRelCatalogBrandVendorPO where;
                UccRelCatalogBrandVendorPO set;
                UccRelCatalogBrandVendorPO checkPo = (UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0);
                if (reqBO.getDiscountFlag() == 0) {
                    if (checkPo.getDiscountFlag() != 1) {
                        rspBO.setRespCode("0002");
                        rspBO.setRespDesc("\u7b2c" + i + "\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff01\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u63d0\u4ea4");
                        return rspBO;
                    }
                    set = new UccRelCatalogBrandVendorPO();
                    BeanUtils.copyProperties((Object)relReqBo, (Object)set);
                    set.setDiscountFlag(Integer.valueOf(0));
                    set.setUpdateOperId(reqBO.getUsername());
                    set.setUpdateOperName(reqBO.getName());
                    set.setUpdateTime(new Date());
                    where = new UccRelCatalogBrandVendorPO();
                    where.setCatalogId(checkPo.getCatalogId());
                    where.setVendorId(checkPo.getVendorId());
                    where.setBrandId(checkPo.getBrandId());
                    this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                } else {
                    if (checkPo.getDiscountFlag() == 1) {
                        rspBO.setRespCode("0002");
                        rspBO.setRespDesc("\u7b2c" + i + "\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff01\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u63d0\u4ea4");
                        return rspBO;
                    }
                    set = new UccRelCatalogBrandVendorPO();
                    set.setDiscount(relReqBo.getDiscount());
                    set.setUpdateOperId(reqBO.getUsername());
                    set.setUpdateOperName(reqBO.getName());
                    set.setUpdateTime(new Date());
                    where = new UccRelCatalogBrandVendorPO();
                    where.setCatalogId(checkPo.getCatalogId());
                    where.setVendorId(checkPo.getVendorId());
                    where.setBrandId(checkPo.getBrandId());
                    this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                }
            } else {
                Date date = new Date();
                UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                insertPo.setVendorId(relReqBo.getVendorId());
                insertPo.setBrandId(relReqBo.getBrandId());
                insertPo.setCatalogId(relReqBo.getCatalogId());
                if (reqBO.getDiscountFlag() != null && reqBO.getDiscountFlag() == 1) {
                    insertPo.setStatus(Integer.valueOf(3));
                } else {
                    insertPo.setStatus(relReqBo.getStatus());
                }
                insertPo.setCreateOperId(reqBO.getUsername() != null ? reqBO.getUsername() : "");
                insertPo.setCreateOperName(reqBO.getName());
                insertPo.setCreateTime(date);
                insertPo.setUpdateOperId(reqBO.getUsername() != null ? reqBO.getUsername() : "");
                insertPo.setUpdateOperName(reqBO.getName());
                insertPo.setUpdateTime(date);
                insertPo.setDiscountFlag(reqBO.getDiscountFlag());
                insertPo.setDiscount(relReqBo.getDiscount());
                insertList.add(insertPo);
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(insertList)) {
            this.uccRelCatalogBrandVendorMapper.insertBatch(insertList);
        }
        return rspBO;
    }

    private String checkDoubleData(List<UccCatalogBrandVendorAddInfo> catalogBrandVendorRelList) {
        StringBuilder stringBuffer = new StringBuilder();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < catalogBrandVendorRelList.size(); ++i) {
            String key = "" + catalogBrandVendorRelList.get(i).getBrandId() + catalogBrandVendorRelList.get(i).getCatalogId() + catalogBrandVendorRelList.get(i).getVendorId();
            if (treeSet.add(key.trim())) continue;
            stringBuffer.append("\u7b2c").append(i + 1).append("\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff01\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u63d0\u4ea4");
            break;
        }
        return stringBuffer.toString();
    }

    @Autowired
    public void setUccRelCatalogBrandVendorMapper(UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper) {
        this.uccRelCatalogBrandVendorMapper = uccRelCatalogBrandVendorMapper;
    }
}

