/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.mall.ability.api.UccMallBatchQryDeliveryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQryDeliveryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQryDeliveryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQryDeliveryBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQryDeliveryReqBO;
import com.tydic.commodity.mall.atom.api.InterfaceCommdDetailsQryService;
import com.tydic.commodity.mall.atom.api.InterfaceDeliveryTimeQryService;
import com.tydic.commodity.mall.atom.api.UccMallExpectDeliveryTimeQueryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomRspBo;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.po.UccVendorPo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchQryDeliveryAbilityService"})
public class UccMallBatchQryDeliveryAbilityServiceImpl
implements UccMallBatchQryDeliveryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchQryDeliveryAbilityServiceImpl.class);
    @Autowired
    private InterfaceCommdDetailsQryService interfaceCommdDetailsQryService;
    @Autowired
    private InterfaceDeliveryTimeQryService interfaceDeliveryTimeQryService;
    @Autowired
    private UccMallExpectDeliveryTimeQueryAtomService uccExpectDeliveryTimeQueryAtomService;
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Value(value="${ESB_QRY_SKU_EXPECT_DELIVERY_TIME}")
    private String url;

    @PostMapping(value={"qryDelivery"})
    public UccMallBatchQryDeliveryAbilityRspBO qryDelivery(@RequestBody UccMallBatchQryDeliveryAbilityReqBO reqBo) {
        UccMallBatchQryDeliveryAbilityRspBO rspBO = new UccMallBatchQryDeliveryAbilityRspBO();
        rspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty((Collection)reqBo.getDeliveryBOList())) {
            throw new BusinessException("8888", "\u5165\u53c2 deliveryBOList \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mallBatchQryDeliveryBOS = reqBo.getDeliveryBOList().stream().map(e -> {
            UccMallBatchQryDeliveryBO uccMallBatchQryDeliveryBO = new UccMallBatchQryDeliveryBO();
            uccMallBatchQryDeliveryBO.setSkuId(e.getSkuId());
            uccMallBatchQryDeliveryBO.setSupplierShopId(e.getSupplierShopId());
            uccMallBatchQryDeliveryBO.setExtSkuId(e.getExtSkuId());
            return uccMallBatchQryDeliveryBO;
        }).collect(Collectors.toList());
        List<Long> supplierIds = reqBo.getDeliveryBOList().stream().map(UccMallBatchQryDeliveryReqBO::getSupplierShopId).collect(Collectors.toList());
        Map<Long, String> vendorMap = this.getVendorInfo(supplierIds);
        for (UccMallBatchQryDeliveryBO bo : mallBatchQryDeliveryBOS) {
            if ("jd".equals(vendorMap.get(bo.getSupplierShopId())) || "jdFl".equals(vendorMap.get(bo.getSupplierShopId()))) continue;
            try {
                InterfaceCommdDetailsQryReqBO busiQrySKUReqBO = new InterfaceCommdDetailsQryReqBO();
                busiQrySKUReqBO.setSkuIds(Collections.singletonList(bo.getExtSkuId()));
                busiQrySKUReqBO.setSupplierCode(vendorMap.get(bo.getSupplierShopId()));
                busiQrySKUReqBO.setShow(false);
                InterfaceCommdDetailsQryRspBO uccCommdDetailsQryRspBO = this.interfaceCommdDetailsQryService.qryCommdDetails(busiQrySKUReqBO);
                log.info("\u67e5\u8be2\u51fa\u53c2\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)((Object)uccCommdDetailsQryRspBO)));
                if (!"0000".equals(uccCommdDetailsQryRspBO.getResultCode()) || "jd".equals(busiQrySKUReqBO.getSupplierCode()) || "jdFl".equals(busiQrySKUReqBO.getSupplierCode())) continue;
                bo.setDeliveryTime(Integer.valueOf(uccCommdDetailsQryRspBO.getResult().getNotJdCommdDetails().getSkuGroup().get(0).getDeliveryTime()));
            }
            catch (Exception e2) {
                log.error("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25");
            }
        }
        rspBO.setDeliveryBOList(mallBatchQryDeliveryBOS);
        return rspBO;
    }

    private Map<Long, String> getVendorInfo(List<Long> supplierIds) {
        List<UccVendorPo> uccVendorPos = this.uccMallVendorMapper.getListByVendorIds(supplierIds);
        return uccVendorPos.stream().collect(Collectors.toMap(UccVendorPo::getVendorId, UccVendorPo::getVendorCode));
    }

    @PostMapping(value={"qryExceptDelivery"})
    public UccMallBatchQryDeliveryAbilityRspBO qryExceptDelivery(@RequestBody UccMallBatchQryDeliveryAbilityReqBO reqBo) {
        UccMallBatchQryDeliveryAbilityRspBO rspBO = new UccMallBatchQryDeliveryAbilityRspBO();
        rspBO.setRespCode("0000");
        List mallBatchQryDeliveryBOS = reqBo.getDeliveryBOList().stream().map(e -> {
            UccMallBatchQryDeliveryBO uccMallBatchQryDeliveryBO = new UccMallBatchQryDeliveryBO();
            uccMallBatchQryDeliveryBO.setSkuId(e.getSkuId());
            uccMallBatchQryDeliveryBO.setSupplierShopId(e.getSupplierShopId());
            uccMallBatchQryDeliveryBO.setExtSkuId(e.getExtSkuId());
            return uccMallBatchQryDeliveryBO;
        }).collect(Collectors.toList());
        List<Long> supplierIds = reqBo.getDeliveryBOList().stream().map(UccMallBatchQryDeliveryReqBO::getSupplierShopId).collect(Collectors.toList());
        Map<Long, String> vendorMap = this.getVendorInfo(supplierIds);
        for (UccMallBatchQryDeliveryBO mallBatchQryDeliveryBO : mallBatchQryDeliveryBOS) {
            try {
                UccMallExpectDeliveryTimeQueryAtomReqBo uccExpectDeliveryTimeQueryAtomReqBo = new UccMallExpectDeliveryTimeQueryAtomReqBo();
                BeanUtils.copyProperties((Object)reqBo, (Object)uccExpectDeliveryTimeQueryAtomReqBo);
                uccExpectDeliveryTimeQueryAtomReqBo.setUrl(this.url);
                uccExpectDeliveryTimeQueryAtomReqBo.setSkuId(mallBatchQryDeliveryBO.getExtSkuId());
                uccExpectDeliveryTimeQueryAtomReqBo.setSupplierId(mallBatchQryDeliveryBO.getSupplierShopId());
                uccExpectDeliveryTimeQueryAtomReqBo.setSupplierCode(vendorMap.get(mallBatchQryDeliveryBO.getSupplierShopId()));
                uccExpectDeliveryTimeQueryAtomReqBo.setCity(reqBo.getCity());
                uccExpectDeliveryTimeQueryAtomReqBo.setTown(reqBo.getTown());
                uccExpectDeliveryTimeQueryAtomReqBo.setCounty(reqBo.getCounty());
                uccExpectDeliveryTimeQueryAtomReqBo.setProvince(reqBo.getProvince());
                uccExpectDeliveryTimeQueryAtomReqBo.setNum("1");
                UccMallExpectDeliveryTimeQueryAtomRspBo uccExpectDeliveryTimeQueryAtomRspBo = this.uccExpectDeliveryTimeQueryAtomService.getExpectDeliveryTime(uccExpectDeliveryTimeQueryAtomReqBo);
                if (!"0000".equals(uccExpectDeliveryTimeQueryAtomRspBo.getRespCode())) continue;
                mallBatchQryDeliveryBO.setResult(uccExpectDeliveryTimeQueryAtomRspBo.getResult());
            }
            catch (Exception e2) {
                log.error(e2.getMessage());
            }
        }
        rspBO.setDeliveryBOList(mallBatchQryDeliveryBOS);
        return rspBO;
    }
}

