/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.mall.ability.api.UccMallQryHistorySearchGoodPageListAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallHistorySearchGoodBo;
import com.tydic.commodity.mall.ability.bo.UccMallQryHistorySearchGoodItemPageListAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryHistorySearchGoodItemPageListAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallDictionaryAtomService;
import com.tydic.commodity.mall.dao.UccSearchGoodItemMapper;
import com.tydic.commodity.mall.dao.UccSearchGoodMapper;
import com.tydic.commodity.mall.po.UccSearchGoodItemPO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQryHistorySearchGoodPageListAbilityService"})
public class UccMallQryHistorySearchGoodPageListAbilityServiceImpl
implements UccMallQryHistorySearchGoodPageListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQryHistorySearchGoodPageListAbilityServiceImpl.class);
    @Autowired
    private UccSearchGoodMapper uccSearchGoodMapper;
    @Autowired
    private UccSearchGoodItemMapper uccSearchGoodItemMapper;
    @Autowired
    private UccMallDictionaryAtomService dictionaryAbilityService;

    @PostMapping(value={"qryHistorySearchGoodPageList"})
    public UccMallQryHistorySearchGoodItemPageListAbilityRspBO qryHistorySearchGoodPageList(@RequestBody UccMallQryHistorySearchGoodItemPageListAbilityReqBO reqBO) {
        List<UccMallHistorySearchGoodBo> uccMallHistorySearchGoodBoList;
        UccMallQryHistorySearchGoodItemPageListAbilityRspBO rspBO = new UccMallQryHistorySearchGoodItemPageListAbilityRspBO();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getRequirement())) {
            UccSearchGoodItemPO po = new UccSearchGoodItemPO();
            po.setRequirement(reqBO.getRequirement());
            List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getList(po);
            if (CollectionUtils.isNotEmpty(list)) {
                reqBO.setSearchGoodIds(list.stream().map(UccSearchGoodItemPO::getSearchGoodId).collect(Collectors.toList()));
            }
        }
        if (CollectionUtils.isNotEmpty(uccMallHistorySearchGoodBoList = this.uccSearchGoodMapper.getHistorySearchListPage(reqBO, (Page<UccMallHistorySearchGoodBo>)page))) {
            UccSearchGoodItemPO po = new UccSearchGoodItemPO();
            reqBO.setSearchGoodIds(uccMallHistorySearchGoodBoList.stream().map(UccMallHistorySearchGoodBo::getSearchGoodId).collect(Collectors.toList()));
            List<UccSearchGoodItemPO> goodItemPOList = this.uccSearchGoodItemMapper.getList(po);
            Map<Long, List<UccSearchGoodItemPO>> groupList = goodItemPOList.stream().filter(g -> g.getSearchGoodId() != null).collect(Collectors.groupingBy(UccSearchGoodItemPO::getSearchGoodId));
            Map<String, String> dicMap = this.dictionaryAbilityService.queryBypCodeBackMap("UCC_BATCH_SEARCH_TYPE_DIC");
            uccMallHistorySearchGoodBoList.forEach(u -> {
                u.setSearchGoodTypeStr((String)dicMap.get(String.valueOf(u.getSearchGoodType())));
                u.setSearchGoodSum(Integer.valueOf(groupList.get(u.getSearchGoodId()) == null ? 0 : ((List)groupList.get(u.getSearchGoodId())).size()));
            });
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(uccMallHistorySearchGoodBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

