/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.tydic.commodity.mall.atom.api.UccMallCatalogCommdNumQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCatalogCommdNumBO;
import com.tydic.commodity.mall.atom.bo.UccMallCatalogCommdNumQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCatalogCommdNumQryRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStockMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierShopPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCatalogCommdNumQryAtomServiceImpl
implements UccMallCatalogCommdNumQryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCatalogCommdNumQryAtomServiceImpl.class);
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSkuStockMapper uccMallSkuStockMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    @Override
    public UccMallCatalogCommdNumQryRspBO qryCommdNum(UccMallCatalogCommdNumQryReqBO reqBO) {
        this.checkReq(reqBO);
        UccMallCatalogCommdNumQryRspBO rspBO = new UccMallCatalogCommdNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        ArrayList<UccMallCatalogCommdNumBO> uccMallsCatalogCommdNumBOList = new ArrayList<UccMallCatalogCommdNumBO>();
        rspBO.setResult(uccMallsCatalogCommdNumBOList);
        List<SupplierShopPo> supplierShopPos = this.uccMallSupplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty(supplierShopPos)) {
            rspBO.setRespDesc("\u5546\u6237\u4e0b\u65e0\u5e97\u94fa\u4fe1\u606f");
            return rspBO;
        }
        List<Long> supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        Map<Long, List<Long>> commodityTypeIdsMap = this.queryCommdTypeIds(reqBO.getCatalogIds());
        for (Map.Entry<Long, List<Long>> each : commodityTypeIdsMap.entrySet()) {
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            UccMallCatalogCommdNumBO uccMallsCatalogCommdNumBO = new UccMallCatalogCommdNumBO();
            uccMallsCatalogCommdNumBO.setCatalogId(catalogId);
            uccMallsCatalogCommdNumBO.setCommodityNum(0L);
            uccMallsCatalogCommdNumBO.setSaleItemNum(0L);
            uccMallsCatalogCommdNumBO.setDepotItemNum(0L);
            uccMallsCatalogCommdNumBO.setNotStockCount(0L);
            uccMallsCatalogCommdNumBOList.add(uccMallsCatalogCommdNumBO);
            if (CollectionUtils.isEmpty(commodityTypeIds)) continue;
            Long count = this.uccMallSkuMapper.qryNumsByStatus(null, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setCommodityNum(count);
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(0);
            status.add(1);
            status.add(2);
            status.add(5);
            status.add(7);
            status.add(10);
            Long depotItemNum = this.uccMallSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setDepotItemNum(depotItemNum);
            status = new ArrayList();
            status.add(3);
            Long saleNums = this.uccMallSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setSaleItemNum(saleNums);
            Long understockNum = this.uccMallCommodityMapper.qryRemark(reqBO.getSupplierId(), catalogId);
            uccMallsCatalogCommdNumBO.setNotStockCount(understockNum);
        }
        return rspBO;
    }

    public Map<Long, List<Long>> queryCommdTypeIds(List<Long> catalogIds) {
        if (CollectionUtils.isEmpty(catalogIds)) {
            return null;
        }
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (int i = 0; i < catalogIds.size(); ++i) {
            try {
                List<Long> commodityTypeIds = this.uccMallCatRCommdTypeMapper.qryCommodityTypeIds(catalogIds.get(i));
                map.put(catalogIds.get(i), commodityTypeIds);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException(UccMallConstantsEnums.COMMODITY_TYPE_NON_EXISTENT.code(), UccMallConstantsEnums.COMMODITY_TYPE_NON_EXISTENT.message());
            }
        }
        return map;
    }

    public void checkReq(UccMallCatalogCommdNumQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u5546\u6237ID");
        }
    }
}

