/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebExtNotiErpPlanMatchedBusiService;
import com.tydic.uoc.busibase.busi.bo.ErpNotiPlanMatchedBO;
import com.tydic.uoc.busibase.busi.bo.PebExtNotiErpPlanMatchedReqBO;
import com.tydic.uoc.busibase.busi.bo.PebExtNotiErpPlanMatchedRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class PebExtNotiErpPlanMatchedBusiServiceImpl
implements PebExtNotiErpPlanMatchedBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtNotiErpPlanMatchedBusiServiceImpl.class);
    @Value(value="${P_INTERFACE_CODE}")
    private String pInterfaceCode;
    @Value(value="${P_SOURCE_SYSTEM}")
    private String pSourceSystem;
    @Autowired
    private Environment environment;

    @Override
    public PebExtNotiErpPlanMatchedRspBO notiErpPlanMatched(PebExtNotiErpPlanMatchedReqBO reqBO) {
        PebExtNotiErpPlanMatchedRspBO rspBO;
        String reqStr = this.initReqStr(reqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.environment.getProperty("ZM_ERP_NOTI_PLAN_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.environment.getProperty("ZM_ERP_NOTI_PLAN_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isBlank((CharSequence)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private PebExtNotiErpPlanMatchedRspBO resolveRsp(String returnString) {
        log.debug("\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        String key = "ERP_STATUS";
        PebExtNotiErpPlanMatchedRspBO rspBO = new PebExtNotiErpPlanMatchedRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (StringUtils.isBlank((CharSequence)jsonObject.getString(key))) {
            rspBO.setRespCode("102001");
            rspBO.setRespDesc("\u8c03\u7528\u4e2d\u7164ESB\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u4fe1\u606f\u63a5\u53e3\u672a\u8fd4\u56de\u6267\u884c\u7ed3\u679c\u7f16\u7801!");
            return rspBO;
        }
        if ("S".equals(jsonObject.getString(key)) || "P".equals(jsonObject.getString(key))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setBatchNo(jsonObject.getString("PBATCH_ID"));
            rspBO.setErpStatus(jsonObject.getString("ERP_STATUS"));
            rspBO.setErpMsg(jsonObject.getString("ERP_MSG"));
            JSONArray datas = jsonObject.getJSONArray("DATA");
            ArrayList<ErpNotiPlanMatchedBO> erpNotiPlanMatchedBOList = new ArrayList<ErpNotiPlanMatchedBO>();
            for (Object data : datas) {
                JSONObject json = (JSONObject)data;
                ErpNotiPlanMatchedBO bo = new ErpNotiPlanMatchedBO();
                bo.setSourceCode(json.getString("SOURCE_CODE"));
                if (!StringUtils.isEmpty((CharSequence)json.getString("HEADER_ID"))) {
                    bo.setHeaderId(Long.valueOf(json.getString("HEADER_ID")));
                }
                if (!StringUtils.isEmpty((CharSequence)json.getString("LINE_ID"))) {
                    bo.setLineId(Long.valueOf(json.getString("LINE_ID")));
                }
                if (!StringUtils.isEmpty((CharSequence)json.getString("ATTCH_NO"))) {
                    bo.setAttchNo(Long.valueOf(json.getString("ATTCH_NO")));
                }
                bo.setReturnStatus(json.getString("RETURN_STATUS"));
                bo.setReturnMsg(json.getString("RETURN_MSG"));
                erpNotiPlanMatchedBOList.add(bo);
            }
        } else {
            rspBO.setRespCode("102001");
            rspBO.setRespDesc(jsonObject.getString("ERP_MSG"));
        }
        return rspBO;
    }

    private String initReqStr(PebExtNotiErpPlanMatchedReqBO reqBO) {
        reqBO.setP_INTERFACE_CODE(this.pInterfaceCode);
        reqBO.setP_SOURCE_SYSTEM(this.pSourceSystem);
        String s = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
        reqBO.setPBATCH_ID(s);
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        log.info("\u901a\u77e5erp\u91c7\u8d2d\u8ba1\u5212\u521d\u59cb\u5316\u62a5\u6587" + reqStr);
        return reqStr;
    }
}

