/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.common.ability.api.PebAmeQryDataAbilityService;
import com.tydic.uoc.common.ability.bo.PebAmeQryCjPriceItemBO;
import com.tydic.uoc.common.ability.bo.PebAmeQryOrderInfoBO;
import com.tydic.uoc.common.ability.bo.PebAmeQryOrderInfoReqBO;
import com.tydic.uoc.common.ability.bo.PebAmeQryOrderInfoRspBO;
import com.tydic.uoc.common.ability.bo.PebQryPlanInfoReqBO;
import com.tydic.uoc.common.ability.bo.PebQryPlanInfoRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebAmeQryDataAbilityService"})
public class PebAmeQryDataAbilityServiceImpl
implements PebAmeQryDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebAmeQryDataAbilityServiceImpl.class);
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${UOC_AMJ_QRY_DEPT_CODE:201123301,101301401,201209307}")
    private String deptCodes;

    @PostMapping(value={"qryPlanInfo"})
    public PebQryPlanInfoRspBO qryPlanInfo(@RequestBody PebQryPlanInfoReqBO reqBO) {
        PebQryPlanInfoRspBO rspBO = new PebQryPlanInfoRspBO();
        List list = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPlanIds())) {
            list = this.planDiversionMapper.selectNameAndNo(reqBO.getPlanIds(), reqBO.getPlanHeadeId());
        }
        rspBO.setList(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryOrderInfo"})
    public PebAmeQryOrderInfoRspBO qryOrderInfo(@RequestBody PebAmeQryOrderInfoReqBO reqBO) {
        PebAmeQryOrderInfoRspBO rspBO = new PebAmeQryOrderInfoRspBO();
        Page pageBO = new Page();
        pageBO.setPageSize(reqBO.getPageSize());
        pageBO.setPageNo(reqBO.getPageNo());
        reqBO.setDeptList(this.getdeptLists(this.deptCodes));
        List orderBOS = this.ordSaleMapper.qryOrder(reqBO, pageBO);
        List ordIds = orderBOS.stream().map(s -> s.getOrderId()).collect(Collectors.toList());
        if (ordIds.size() != 0) {
            List pebAmeQryCjPriceItemBOS = this.ordSaleMapper.qryOrderInfoByOrdIds(ordIds);
            Map<Long, List<PebAmeQryCjPriceItemBO>> map = pebAmeQryCjPriceItemBOS.stream().collect(Collectors.groupingBy(e -> e.getOrderId()));
            for (PebAmeQryOrderInfoBO bo : orderBOS) {
                Long ordId = bo.getOrderId();
                List<PebAmeQryCjPriceItemBO> itemBOS = map.get(ordId);
                if (CollectionUtils.isEmpty(itemBOS)) continue;
                bo.setInfo(itemBOS);
            }
        }
        rspBO.setRows(orderBOS);
        rspBO.setRecordsTotal(pageBO.getTotalCount());
        rspBO.setTotal(pageBO.getTotalPages());
        rspBO.setPageNo(pageBO.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> getdeptLists(String deptCodes) {
        List<String> deptList = Arrays.asList(deptCodes.split(","));
        return deptList;
    }
}

