/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.annotation.OrderFlowLog;
import com.tydic.uoc.common.ability.annotation.OrderLogRecord;
import com.tydic.uoc.common.ability.api.PebExtDealCancelAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtDealCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtDealCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.busi.api.PebExtDealCancelBusiService;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdStakeholderPO;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtDealCancelAbilityService"})
public class PebExtDealCancelAbilityServiceImpl
implements PebExtDealCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtDealCancelAbilityServiceImpl.class);
    @Autowired
    private PebExtDealCancelBusiService pebExtDealCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @OrderLogRecord(description="\u53d6\u6d88")
    @OrderFlowLog(operationLink="\u53d6\u6d88\u8ba2\u5355", description="\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"dealCancel"})
    public PebExtDealCancelRspBO dealCancel(@RequestBody PebExtDealCancelReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        this.val(reqBO);
        PebExtDealCancelRspBO rspBO = this.pebExtDealCancelBusiService.dealCancel(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setOrderId(reqBO.getOrderId());
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            syncReqBO.setObjId(reqBO.getSaleVoucherId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
            if (rspBO.getAudit().booleanValue()) {
                this.cancelAudit(reqBO);
            }
        }
        return rspBO;
    }

    private void cancelAudit(PebExtDealCancelReqBO reqBO) {
        UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
        taskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
        taskAuditCancelReqBO.setCancelReason(StringUtils.isBlank((CharSequence)reqBO.getDealDesc()) ? "\u8ba2\u5355\u64a4\u56de" : reqBO.getDealDesc());
        taskAuditCancelReqBO.setObjId(reqBO.getCancelId().toString());
        taskAuditCancelReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(false));
        taskAuditCancelReqBO.setOperName(reqBO.getUsername());
        this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
        try {
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(reqBO.getOrderId());
            uocTodoBO.setSaleVoucherId(reqBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.CANCLE.getCode());
            uocTodoBO.setOperatorId(stakeholderPO.getPurPlaceOrderId());
            uocTodoBO.setOperatorNo(stakeholderPO.getPurLogName());
            uocTodoBO.setOperatorName(stakeholderPO.getPurPlaceOrderName());
            uocTodoBO.setOrgId(Long.valueOf(stakeholderPO.getPurOrgId()));
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }

    private void val(PebExtDealCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCancelId() == null) {
            throw new UocProBusinessException("100001", "\u53d6\u6d88\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

