/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.ability.api.PebExtOrderWarehouseLogisticsQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderWarehouseLogisticsQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderWarehouseLogisticsQryAbilityRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtOrderWarehouseLogisticsQryAbilityService"})
public class PebExtOrderWarehouseLogisticsQryAbilityServiceImpl
implements PebExtOrderWarehouseLogisticsQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtOrderWarehouseLogisticsQryAbilityServiceImpl.class);
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdWarehouseMapper ordWarehouseMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;

    @PostMapping(value={"qryOrderWarehouseLogistics"})
    public PebExtOrderWarehouseLogisticsQryAbilityRspBO qryOrderWarehouseLogistics(@RequestBody PebExtOrderWarehouseLogisticsQryAbilityReqBO reqBO) {
        this.valid(reqBO);
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setShipVoucherId(reqBO.getShipVoucherId());
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
        if (ordShipPO == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.ordWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4f01\u914d\u4ed3\u4fe1\u606f\uff01");
        }
        String warehouseId = this.getEcomWarehouseCode(warehousePO.getSupplierId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("warehouseId", (Object)warehouseId);
        jsonObject.put("shipId", (Object)ordShipPO.getShipVoucherId());
        String signStr = "warehouseId" + warehouseId + "shipId" + reqBO.getShipVoucherId().toString();
        String sign = MD5Util.MD5Encode((String)(signStr + this.warehouseSignKey), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + this.warehouseSignKey), (String)"");
        jsonObject.put("sign", (Object)sign);
        return this.qryWarehouseLogistics(jsonObject, warehousePO.getSupplierId());
    }

    private PebExtOrderWarehouseLogisticsQryAbilityRspBO qryWarehouseLogistics(JSONObject jsonObject, Long supplierId) {
        PebExtOrderWarehouseLogisticsQryAbilityRspBO rspBO;
        String reqStr = this.initParam(jsonObject, supplierId);
        String returnString = null;
        try {
            log.debug("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ZM_ORDER_WAREHOUSE_LOGISTICS_QRY")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            log.debug("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u8fd4\u56de\u6570\u636e\uff1a" + JSON.toJSONString((Object)httpRetBean));
            if (httpRetBean.getStatus() != 200 && (httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ZM_ORDER_WAREHOUSE_LOGISTICS_QRY")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false)).getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ZM_ORDER_WAREHOUSE_LOGISTICS_QRY") + "]");
            }
            returnString = httpRetBean.getStr();
            if (StringUtils.isBlank((CharSequence)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u5f02\u5e38" + e);
            rspBO = new PebExtOrderWarehouseLogisticsQryAbilityRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        return rspBO;
    }

    private String initParam(JSONObject jsonObject, Long supplierId) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + supplierId));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)jsonObject, (String)hsn, (String)"BUSINESS_ORDER");
        return esbReqParam;
    }

    private PebExtOrderWarehouseLogisticsQryAbilityRspBO resolveRsp(String returnString) {
        PebExtOrderWarehouseLogisticsQryAbilityRspBO rspBO = (PebExtOrderWarehouseLogisticsQryAbilityRspBO)JSONObject.parseObject((String)returnString, PebExtOrderWarehouseLogisticsQryAbilityRspBO.class);
        if (!StringUtils.isEmpty((CharSequence)rspBO.getCode()) && rspBO.getCode().equals("0")) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u4e2d\u7164ESB\u67e5\u8be2\u4f01\u914d\u4ed3\u7269\u6d41\u4fe1\u606f\u5f02\u5e38\uff1a" + rspBO.getMessage());
        }
        return rspBO;
    }

    private void valid(PebExtOrderWarehouseLogisticsQryAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getShipVoucherId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[shipVoucherId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }
}

