/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.common.ability.api.PebExtSendMessageAbilityServer;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageRspBO;
import com.tydic.uoc.common.ability.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.busi.api.PebExtSendMessageBusiService;
import com.tydic.uoc.common.utils.UocNotificationUtil;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtSendMessageAbilityServer"})
public class PebExtSendMessageAbilityServerImpl
implements PebExtSendMessageAbilityServer {
    @Autowired
    private PebExtSendMessageBusiService pebExtSendMessageBusiService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocNotificationUtil uocNotificationUtil;

    @PostMapping(value={"sendNotifyMessage"})
    public PebExtSendMessageRspBO sendNotifyMessage(@RequestBody PebExtSendMessageReqBO reqBO) {
        return this.pebExtSendMessageBusiService.sendNotifyMessage(reqBO);
    }

    @PostMapping(value={"sendMessage"})
    public PebExtSendMessageRspBO sendMessage(@RequestBody String reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            return null;
        }
        PebExtSendMessageReqBO pebExtSendMessageReqBO = (PebExtSendMessageReqBO)JSON.parseObject((String)reqBO, PebExtSendMessageReqBO.class);
        Long orderId = pebExtSendMessageReqBO.getOrderId();
        OrderPO orderById = this.getOrderById(orderId);
        OrdStakeholderPO stakeHodleOrder = this.getStakeHodleOrder(orderId);
        long userId = Long.parseLong(stakeHodleOrder.getPurPlaceOrderId());
        long ext2 = Long.parseLong(orderById.getExt2());
        String supName = stakeHodleOrder.getSupName();
        OrdSalePO saleOrder = this.getSaleOrder(orderId);
        String saleVoucherNo = saleOrder.getSaleVoucherNo();
        List<OrdItemPO> ordItemPOS = this.listOrderItemList(orderId);
        List<OrdItemPO> checkOrdItemPOS = this.checkOrderCycle(ordItemPOS);
        if (CollectionUtils.isEmpty(checkOrdItemPOS)) {
            return null;
        }
        UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
        uocSendMessageReqBO.setUserId(Long.valueOf(1L));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(userId);
        ids.add(ext2);
        uocSendMessageReqBO.setReceiveIds(ids);
        uocSendMessageReqBO.setTitel("\u3010\u534f\u8bae\u8ba2\u5355\u4f9b\u5e94\u5546\u4fee\u6539\u4f9b\u8d27\u5468\u671f\u901a\u77e5\u3011");
        uocSendMessageReqBO.setText(this.buildText(supName, saleVoucherNo, ordItemPOS));
        this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
        return null;
    }

    private String buildText(String supName, String saleVoucherNo, List<OrdItemPO> ordItemPOS) {
        StringBuffer stringBuffer = new StringBuffer("\u3010" + supName + "\u3011\u4fee\u6539\u4e86\u3010" + saleVoucherNo + "\u3011\u4ee5\u4e0b\u5546\u54c1\u7684\u4f9b\u8d27\u5468\u671f:");
        for (int i = 0; i < ordItemPOS.size(); ++i) {
            OrdItemPO ordItemPO = ordItemPOS.get(i);
            String skuName = ordItemPO.getSkuName();
            Integer supplyCycle = ordItemPO.getSupplyCycle();
            Integer realSupplyCycle = ordItemPO.getRealSupplyCycle();
            stringBuffer.append("\u3010" + skuName + "\u3011\u539f\u4f9b\u8d27\u5468\u671f\u3010" + supplyCycle + "\u3011\uff08\u5929\uff09\u66f4\u6539\u4e3a\u3010" + realSupplyCycle + "\u3011\uff08\u5929\uff09");
        }
        return stringBuffer.toString();
    }

    private OrdSalePO getSaleOrder(Long orderId) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        return this.ordSaleMapper.getModelBy(ordSalePO);
    }

    private OrdStakeholderPO getStakeHodleOrder(Long orderId) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(orderId);
        return this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
    }

    private OrderPO getOrderById(Long orderId) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        return this.orderMapper.getModelBy(orderPO);
    }

    private List<OrdItemPO> listOrderItemList(Long orderId) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        return this.ordItemMapper.getList(ordItemPO);
    }

    private List<OrdItemPO> checkOrderCycle(List<OrdItemPO> list) {
        return list.stream().filter($ -> Objects.nonNull($.getRealSupplyCycle()) && $.getSupplyCycle().compareTo($.getRealSupplyCycle()) != 0).collect(Collectors.toList());
    }
}

