/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtWarehouseAbnormalDetailsListQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseAbnormalDetailsBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseAbnormalDetailsQryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseAbnormalDetailsQryRspBO;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.DicDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtWarehouseAbnormalDetailsListQryAbilityService"})
public class PebExtWarehouseAbnormalDetailsListQryAbilityServiceImpl
implements PebExtWarehouseAbnormalDetailsListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtWarehouseAbnormalDetailsListQryAbilityServiceImpl.class);
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @PostMapping(value={"qryWarehouseAbnormalDetails"})
    public PebExtWarehouseAbnormalDetailsQryRspBO qryWarehouseAbnormalDetails(@RequestBody PebExtWarehouseAbnormalDetailsQryReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[objType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List abnormalDetailsBOS = new ArrayList();
        if (reqBO.getObjType().equals(UocConstant.OBJ_TYPE.ORDER)) {
            abnormalDetailsBOS = this.uocOrdWarehouseMapper.qryOrderPushLogs(reqBO.getOrderId());
        } else if (reqBO.getObjType().equals(UocConstant.OBJ_TYPE.SHIP)) {
            abnormalDetailsBOS = this.uocOrdWarehouseLogMapper.qryShipPushLogs(reqBO.getOrderId());
        } else if (reqBO.getObjType().equals(UocConstant.OBJ_TYPE.AFTER_SERVICE)) {
            abnormalDetailsBOS = this.uocOrdWarehouseLogMapper.qryAfsPushLogs(reqBO.getOrderId());
        }
        PebExtWarehouseAbnormalDetailsQryRspBO rspBO = new PebExtWarehouseAbnormalDetailsQryRspBO();
        if (!CollectionUtils.isEmpty(abnormalDetailsBOS)) {
            Map<String, String> pushStatusMap = this.sysDicDictionaryMapper.selectByPCode("PEB_WAREHOUSE_PUSH_STATUS").stream().collect(Collectors.toMap(DicDictionary::getCode, DicDictionary::getDescrip));
            for (PebExtWarehouseAbnormalDetailsBO abnormalDetailsBO : abnormalDetailsBOS) {
                abnormalDetailsBO.setPushStatusStr(pushStatusMap.get(abnormalDetailsBO.getPushStatus() + ""));
                if (StringUtil.isEmpty((String)abnormalDetailsBO.getRemark())) continue;
                try {
                    JSONObject object = JSONObject.parseObject((String)abnormalDetailsBO.getRemark());
                    abnormalDetailsBO.setRemark(object.getString("message"));
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790\u63a8\u9001\u5931\u8d25\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        rspBO.setRows(abnormalDetailsBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

