/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebOrdHistryAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrdHistryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrdHistryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdHistoryBO;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdHistoryMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.UocOrdHistoryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrdHistryAbilityService"})
public class PebOrdHistryAbilityServiceImpl
implements PebOrdHistryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebOrdHistryAbilityServiceImpl.class);
    @Autowired
    private UocOrdHistoryMapper uocOrdHistoryMapper;
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${uoc.qryLastHistoryMaterial.url:${ESB_ACCESS_IP}/OSN/api/standardMaterialHistoryPriceApply/v1}")
    private String url;
    @Value(value="${uoc.qryLastHistoryMaterial.lastUrl:${ESB_ACCESS_IP}/OSN/api/standardMaterialCodePriceApply/v1}")
    private String lastUrl;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @PostMapping(value={"qryHistory"})
    public PebOrdHistryRspBO qryHistory(@RequestBody PebOrdHistryReqBO reqBO) {
        PebOrdHistryRspBO rspBO = new PebOrdHistryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
        historyPO.setMaterialCode(reqBO.getMaterialCode());
        DycUmcQueryOrgPermissionReqBo permissionReqBo = new DycUmcQueryOrgPermissionReqBo();
        permissionReqBo.setErpCode(reqBO.getUsername());
        permissionReqBo.setPageFlag(false);
        DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission(permissionReqBo);
        ArrayList<String> orgCode = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)permissionRspBo.getRows())) {
            for (DycUmcQueryOrgPermissionBo bo : permissionRspBo.getRows()) {
                orgCode.add(bo.getOrgCode());
            }
        } else {
            orgCode.add(reqBO.getOrgCodeIn());
        }
        historyPO.setOrgCodes(orgCode);
        List list = this.uocOrdHistoryMapper.selectPage(historyPO, page);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        List priceList = this.uocOrdHistoryMapper.getPriceIngnoreAudit(historyPO);
        Map<Object, Object> priceMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)priceList)) {
            priceMap = priceList.stream().collect(Collectors.toMap(e -> e.getMaterialCode(), e -> e));
        }
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        List rows = JSONArray.parseArray((String)JSON.toJSONString((Object)list), UocOrdHistoryBO.class);
        for (UocOrdHistoryBO row : rows) {
            UocOrdHistoryPO po = (UocOrdHistoryPO)priceMap.get(row.getMaterialCode());
            if (po == null) continue;
            row.setAvgPrice(po.getAvgPrice());
            row.setMaxPrice(po.getMaxPrice());
            row.setMinPrice(po.getMinPrice());
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    @PostMapping(value={"qryLastHistory"})
    public PebOrdHistryRspBO qryLastHistory(@RequestBody PebOrdHistryReqBO reqBO) {
        PebOrdHistryRspBO rspBO = new PebOrdHistryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
        historyPO.setMaterialCode(reqBO.getMaterialCode());
        DycUmcQueryOrgPermissionReqBo permissionReqBo = new DycUmcQueryOrgPermissionReqBo();
        permissionReqBo.setErpCode(reqBO.getUsername());
        permissionReqBo.setPageFlag(false);
        DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission(permissionReqBo);
        ArrayList<String> orgCode = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)permissionRspBo.getRows())) {
            for (DycUmcQueryOrgPermissionBo bo : permissionRspBo.getRows()) {
                orgCode.add(bo.getOrgCode());
            }
        } else {
            orgCode.add(reqBO.getOrgCodeIn());
        }
        historyPO.setOrgCodes(orgCode);
        historyPO.setMaterialCodes(reqBO.getMaterialCodes());
        List list = PebExtConstant.YES.equals(reqBO.getQryPrice()) ? this.uocOrdHistoryMapper.getPrice(historyPO) : this.uocOrdHistoryMapper.getLast(historyPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        List rows = JSONArray.parseArray((String)JSON.toJSONString((Object)list), UocOrdHistoryBO.class);
        for (UocOrdHistoryBO historyBO : rows) {
            historyBO.setSalePrice(MoneyUtil.b8B((BigDecimal)historyBO.getSalePrice()));
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    @PostMapping(value={"qryLastHistoryMaterial"})
    public PebOrdHistryRspBO qryLastHistoryMaterial(@RequestBody PebOrdHistryReqBO reqBO) {
        ArrayList<UocOrdHistoryBO> rows;
        PebOrdHistryRspBO rspBO = new PebOrdHistryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
        historyPO.setMaterialCode(reqBO.getMaterialCode());
        DycUmcQueryOrgPermissionReqBo permissionReqBo = new DycUmcQueryOrgPermissionReqBo();
        permissionReqBo.setErpCode(reqBO.getUsername());
        permissionReqBo.setPageFlag(false);
        DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermissionCodeShort(permissionReqBo);
        ArrayList<String> orgCode = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)permissionRspBo.getOrgCodes())) {
            orgCode.addAll(permissionRspBo.getOrgCodes());
        } else {
            orgCode.add(reqBO.getOrgCodeIn());
        }
        if (CollectionUtils.isEmpty(orgCode)) {
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        JSONObject req = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("standardMaterialCodeList", (Object)reqBO.getMaterialCodes());
        object.put("purchaseUnitCodeList", orgCode);
        req.put("data", (Object)object);
        req.put("serialNo", (Object)this.idUtil.nextId());
        log.debug("\u67e5\u8be2\u7269\u6599\u62a5\u6587\uff1a" + req.toJSONString());
        if (PebExtConstant.YES.equals(reqBO.getQryPrice())) {
            String result = HttpUtil.post(this.url, req.toJSONString(), new HashMap<String, String>());
            if (StringUtils.isBlank((CharSequence)result)) {
                log.error("\u7269\u6599\u8fd4\u56de\u4e3a\u7a7a");
                rspBO.setRespDesc("\u7269\u6599\u8fd4\u56de\u4e3a\u7a7a");
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            log.debug("\u7269\u6599\u8fd4\u56de\u7684\u62a5\u6587\uff1a" + result);
            JSONObject mResult = JSONObject.parseObject((String)result);
            JSONArray jsonArray = mResult.getJSONArray("result");
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            rows = new ArrayList<UocOrdHistoryBO>();
            for (Object o : jsonArray) {
                JSONObject material = (JSONObject)o;
                UocOrdHistoryBO bo = new UocOrdHistoryBO();
                bo.setAvgPrice(material.getBigDecimal("avg"));
                bo.setMaxPrice(material.getBigDecimal("max"));
                bo.setMinPrice(material.getBigDecimal("min"));
                bo.setMaterialCode(material.getString("standardMaterialCode"));
                rows.add(bo);
            }
        } else {
            String result = HttpUtil.post(this.lastUrl, req.toJSONString(), new HashMap<String, String>());
            if (StringUtils.isBlank((CharSequence)result)) {
                log.error("\u7269\u6599\u8fd4\u56de\u4e3a\u7a7a");
                rspBO.setRespDesc("\u7269\u6599\u8fd4\u56de\u4e3a\u7a7a");
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            log.debug("\u7269\u6599\u8fd4\u56de\u7684\u62a5\u6587\uff1a" + result);
            JSONObject mResult = JSONObject.parseObject((String)result);
            JSONArray jsonArray = mResult.getJSONArray("result");
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            ArrayList<UocOrdHistoryBO> rows2 = new ArrayList<UocOrdHistoryBO>();
            for (Object o : jsonArray) {
                JSONObject material = (JSONObject)o;
                UocOrdHistoryBO bo = new UocOrdHistoryBO();
                bo.setSalePrice(material.getBigDecimal("taxReferencePriceStr"));
                bo.setAuditTime(DateUtils.strToDateLong((String)material.getString("placeTime")));
                bo.setCurrency(material.getString("currency"));
                bo.setMaterialCode(material.getString("standardMaterialCode"));
                rows2.add(bo);
            }
            rspBO.setRows(rows2);
            return rspBO;
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    @PostMapping(value={"qryAgrHistory"})
    public PebOrdHistryRspBO qryAgrHistory(@RequestBody PebOrdHistryReqBO reqBO) {
        PebOrdHistryRspBO rspBO = new PebOrdHistryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMaterialCode())) {
            goodsPO.setSkuMaterialId(reqBO.getMaterialCode());
            goodsPO = this.ordItemMapper.getSkuMaterial(goodsPO);
            UocOrdHistoryBO historyBO = new UocOrdHistoryBO();
            if (goodsPO == null) {
                historyBO.setMaterialCode(reqBO.getMaterialCode());
                historyBO.setSalePrice(BigDecimal.ZERO);
            } else {
                historyBO.setMaterialCode(goodsPO.getSkuMaterialId());
                historyBO.setSalePrice(MoneyUtil.l4B((Long)goodsPO.getSkuSalePrice()));
            }
            rspBO.setHistory(historyBO);
        } else {
            goodsPO.setSkuMaterialIds(reqBO.getMaterialCodes());
            List list = this.ordItemMapper.getSkuMaterials(goodsPO);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return rspBO;
            }
            ArrayList<UocOrdHistoryBO> rows = new ArrayList<UocOrdHistoryBO>();
            for (OrdGoodsPO po : list) {
                UocOrdHistoryBO historyBO = new UocOrdHistoryBO();
                historyBO.setMaterialCode(po.getSkuMaterialId());
                historyBO.setSalePrice(MoneyUtil.l4B((Long)po.getSkuSalePrice()));
                rows.add(historyBO);
            }
            rspBO.setRows(rows);
        }
        return rspBO;
    }

    @PostMapping(value={"qryLastHistoryBySkuId"})
    public PebOrdHistryRspBO qryLastHistoryBySkuId(@RequestBody PebOrdHistryReqBO reqBO) {
        PebOrdHistryRspBO rspBO = new PebOrdHistryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
        historyPO.setMaterialCode(reqBO.getMaterialCode());
        DycUmcQueryOrgPermissionReqBo permissionReqBo = new DycUmcQueryOrgPermissionReqBo();
        permissionReqBo.setErpCode(reqBO.getUsername());
        permissionReqBo.setPageFlag(false);
        DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission(permissionReqBo);
        ArrayList<String> orgCode = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)permissionRspBo.getRows())) {
            for (DycUmcQueryOrgPermissionBo bo : permissionRspBo.getRows()) {
                orgCode.add(bo.getOrgCode());
            }
        } else {
            orgCode.add(reqBO.getOrgCodeIn());
        }
        historyPO.setOrgCodes(orgCode);
        historyPO.setSkuIds(reqBO.getSkuIds());
        List list = this.uocOrdHistoryMapper.getPriceBySkuId(historyPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        List rows = JSONArray.parseArray((String)JSON.toJSONString((Object)list), UocOrdHistoryBO.class);
        for (UocOrdHistoryBO historyBO : rows) {
            historyBO.setSalePrice(MoneyUtil.b8B((BigDecimal)historyBO.getSalePrice()));
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}

