/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebYCSupplementaryInOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryChangeOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryChangeOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryInOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryOutOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryOutOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.PebSyncHtArriveAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomReqBO;
import com.tydic.uoc.common.busi.api.PebInOrderBusiService;
import com.tydic.uoc.common.busi.api.PebYCSupplementaryInOrderBusiService;
import com.tydic.uoc.common.busi.bo.PebSupplementaryInOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebSupplementaryInOrderBusiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebYCSupplementaryInOrderAbilityService"})
public class PebYCSupplementaryInOrderAbilityServiceImpl
implements PebYCSupplementaryInOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebYCSupplementaryInOrderAbilityServiceImpl.class);
    public static final String CHANGE_TYPE = "2";
    @Autowired
    private PebYCSupplementaryInOrderBusiService pebYCSupplementaryInOrderBusiService;
    @Autowired
    private PebInOrderBusiService pebInOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebSyncHtArriveAtomService pebSyncHtArriveAtomService;

    @PostMapping(value={"supplementaryInOrder"})
    public PebSupplementaryInOrderRspBO supplementaryInOrder(@RequestBody PebSupplementaryInOrderReqBO reqBO) {
        this.checkInput(reqBO);
        PebSupplementaryInOrderBusiRspBO busiRspBO = this.pebYCSupplementaryInOrderBusiService.addSupplementaryInOrder((PebSupplementaryInOrderBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebSupplementaryInOrderBusiReqBO.class)));
        if (busiRspBO.getRespCode().equals("0000") && busiRspBO.getSaleVoucherId() != null) {
            PebInOrderReqBO orderReqBO = new PebInOrderReqBO();
            orderReqBO.setOrderId(reqBO.getOrderId());
            PebInOrderRspBO orderRspBO = this.pebInOrderBusiService.dealInOrderShip(orderReqBO);
            if (CollectionUtils.isNotEmpty((Collection)orderRspBO.getShipId())) {
                UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(busiRspBO.getSaleVoucherId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                for (Long objId : orderRspBO.getShipId()) {
                    ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    ordIdxSyncReqBO.setObjId(objId);
                    ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                    ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
                }
            } else {
                UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(busiRspBO.getSaleVoucherId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
            }
            if (!CollectionUtils.isEmpty((Collection)orderRspBO.getConfirmIdList())) {
                this.syncHt(orderRspBO.getConfirmIdList());
            }
        }
        return (PebSupplementaryInOrderRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), PebSupplementaryInOrderRspBO.class);
    }

    @PostMapping(value={"supplementaryOutOrder"})
    public PebSupplementaryOutOrderRspBO supplementaryOutOrder(@RequestBody PebSupplementaryOutOrderReqBO reqBO) {
        this.valid(reqBO);
        PebSupplementaryOutOrderRspBO orderRspBO = this.pebYCSupplementaryInOrderBusiService.dealSupplementaryInOrderOut(reqBO);
        if (orderRspBO.getRespCode().equals("0000") && orderRspBO.getSaleVoucherId() != null) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(orderRspBO.getSaleVoucherId());
            ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
        }
        return orderRspBO;
    }

    private void valid(PebSupplementaryOutOrderReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getShipId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getShipNo())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderCode())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrgId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e1a\u52a1\u5b9e\u4f53ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTkList())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355\u884c\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        reqBO.getTkList().forEach(e -> {
            if (Objects.isNull(e.getShipId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getWmsItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2dWNS\u5165\u5e93\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getOrdItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6613\u8d2d\u8865\u8d27\u5355\u660e\u7ec6\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getQuality())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u6570\u91cf\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getPrice())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5355\u4ef7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getAmount())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
        });
    }

    private void checkInput(PebSupplementaryInOrderReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getShipId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getShipNo())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderCode())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrgId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e1a\u52a1\u5b9e\u4f53ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRkList())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355\u884c\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        reqBO.getRkList().forEach(e -> {
            if (Objects.isNull(e.getShipId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getWmsItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2dWNS\u5165\u5e93\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getOrdItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6613\u8d2d\u8865\u8d27\u5355\u660e\u7ec6\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getQuality())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u6570\u91cf\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getPrice())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5355\u4ef7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getAmount())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5165\u5e93\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
        });
    }

    private void syncHt(List<Long> ids) {
        try {
            PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
            atomReqBO.setConfirmIdList(ids);
            this.pebSyncHtArriveAtomService.syncHtArrive(atomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"supplementaryChangeOrder"})
    public PebSupplementaryChangeOrderRspBO supplementaryChangeOrder(@RequestBody PebSupplementaryChangeOrderReqBO reqBO) {
        this.validChangeParam(reqBO);
        PebSupplementaryChangeOrderRspBO orderRspBO = this.pebYCSupplementaryInOrderBusiService.dealSupplementaryChangeOrder(reqBO);
        if (orderRspBO.getRespCode().equals("0000") && orderRspBO.getSaleVoucherId() != null) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(orderRspBO.getSaleVoucherId());
            ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
        }
        return orderRspBO;
    }

    private void validChangeParam(PebSupplementaryChangeOrderReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getShipId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u6362\u8d27\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getShipNo())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u6362\u8d27\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrderCode())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8865\u8d27\u5355\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOrgId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e1a\u52a1\u5b9e\u4f53ID(\u91c7\u8d2d\u7ec4\u7ec7ID)\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getTkList())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u6362\u8d27\u5355\u884c\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getChangeType())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u6362\u8d27\u5355\u7c7b\u578b\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getShipVoucherId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u53d1\u8d27\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        if (CHANGE_TYPE.equals(reqBO.getChangeType())) {
            if (Objects.isNull(reqBO.getStoreCode())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355code\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(reqBO.getStoreId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u5165\u5e93\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
        }
        reqBO.getTkList().forEach(e -> {
            if (Objects.isNull(e.getShipId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6362\u8d27\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getWmsItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2dWMS\u6362\u8d27\u5355\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getOrdItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6613\u8d2d\u8865\u8d27\u5355\u660e\u7ec6\u884cID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getQuality())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6362\u8d27\u6570\u91cf\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getPrice())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u5355\u4ef7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getAmount())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u6362\u8d27\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(e.getShipItemId())) {
                throw new UocProBusinessException("107777", "\u5165\u53c2\u884c\u4fe1\u606f\u4e2d\u53d1\u8d27\u5355\u660e\u7ec6id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            }
        });
    }
}

