/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.common.ability.api.UocDealEfficiencyIndexAbilityService;
import com.tydic.uoc.common.ability.bo.OrdEfficiencyIndexQryBO;
import com.tydic.uoc.common.ability.bo.UocEfficiencyIndexAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocEfficiencyIndexAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocDealEfficiencyIndexBusiService;
import com.tydic.uoc.common.busi.bo.UocDealEfficiencyIndexBusiReqBO;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocDealEfficiencyIndexAbilityService"})
public class UocDealEfficiencyIndexAbilityServiceImpl
implements UocDealEfficiencyIndexAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocDealEfficiencyIndexAbilityServiceImpl.class);
    @Value(value="${order.efficiency.index.Indicator6:LYGL-DD-00006}")
    private String LYGL_DD_00006;
    @Value(value="${order.efficiency.index.Indicator7:LYGL-DD-00007}")
    private String LYGL_DD_00007;
    @Value(value="${order.efficiency.index.Indicator8:LYGL-DD-00008}")
    private String LYGL_DD_00008;
    @Value(value="${order.efficiency.index.Indicator9:LYGL-DD-00009}")
    private String LYGL_DD_00009;
    @Value(value="${order.efficiency.index.Indicator10:LYGL-DD-00010}")
    private String LYGL_DD_00010;
    @Value(value="${order.efficiency.index.Indicator11:LYGL-DD-00011}")
    private String LYGL_DD_00011;
    @Value(value="${order.efficiency.index.Indicator15:LYGL-DD-00015}")
    private String LYGL_DD_00015;
    @Value(value="${order.efficiency.index.Indicator16:LYGL-DD-00016}")
    private String LYGL_DD_00016;
    @Value(value="${order.efficiency.index.efficiencyWarningStartTime:2025-07-04 00:00:00}")
    private String efficiencyWarningStartTime;
    private static final int BATCH_SIZE = 500;
    @Autowired
    private UocDealEfficiencyIndexBusiService uocDealEfficiencyIndexBusiService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;

    @PostMapping(value={"batchDealEfficiencyIndex"})
    public UocEfficiencyIndexAbilityRspBO batchDealEfficiencyIndex(@RequestBody UocEfficiencyIndexAbilityReqBO reqBO) {
        if ("1".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexNoDispatchedAfterApprovalLevelOne(reqBO);
        } else if ("2".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexNoDispatchedAfterApprovalLevelTwo(reqBO);
        } else if ("3".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexNotDeliveredAfterDispatchLevelOne(reqBO);
        } else if ("4".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexNotDeliveredAfterDispatchLevelTwo(reqBO);
        } else if ("5".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexNotAcceptedAfterArrived(reqBO);
        } else if ("6".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexUnissuedInvoiceAfterSettlement(reqBO);
        } else if ("7".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexAnalysisOverdueSettlement(reqBO);
        } else if ("8".equals(reqBO.getShardingParameter())) {
            this.dealEfficiencyIndexAnalysisSeriouslyOverdueSettlement(reqBO);
        } else {
            this.dealEfficiencyIndexNoDispatchedAfterApprovalLevelOne(reqBO);
            this.dealEfficiencyIndexNoDispatchedAfterApprovalLevelTwo(reqBO);
            this.dealEfficiencyIndexNotDeliveredAfterDispatchLevelOne(reqBO);
            this.dealEfficiencyIndexNotDeliveredAfterDispatchLevelTwo(reqBO);
            this.dealEfficiencyIndexNotAcceptedAfterArrived(reqBO);
            this.dealEfficiencyIndexUnissuedInvoiceAfterSettlement(reqBO);
            this.dealEfficiencyIndexAnalysisOverdueSettlement(reqBO);
            this.dealEfficiencyIndexAnalysisSeriouslyOverdueSettlement(reqBO);
        }
        UocEfficiencyIndexAbilityRspBO uocEfficiencyIndexAbilityRspBO = new UocEfficiencyIndexAbilityRspBO();
        uocEfficiencyIndexAbilityRspBO.setRespCode("0000");
        uocEfficiencyIndexAbilityRspBO.setRespDesc("\u6210\u529f");
        return uocEfficiencyIndexAbilityRspBO;
    }

    private void dealEfficiencyIndexAnalysisSeriouslyOverdueSettlement(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo16 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00016);
        if (!detailRspBo16.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo16.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo16.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo16.getRuleName())) {
            log.error("LYGL-DD-00016|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo16.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("11"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexAnalysisSeriouslyOverdueSettlement(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00016|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo16);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexAnalysisSeriouslyOverdueSettlement(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexAnalysisOverdueSettlement(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo15 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00015);
        if (!detailRspBo15.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo15.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo15.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo15.getRuleName())) {
            log.error("LYGL-DD-00015|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        XwglRuleGetNoauthDetailRspBo detailRspBo16 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00016);
        if (!detailRspBo16.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo16.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo16.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo16.getRuleName())) {
            log.error("LYGL-DD-00015|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u53f3\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo15.getRuleManagementVariableValue());
        int rightBorder = Integer.parseInt(detailRspBo16.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{},\u53f3\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder, (Object)rightBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setRightBorder(Integer.valueOf(rightBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("10"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexAnalysisOverdueSettlement(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00015|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo15);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexAnalysisOverdueSettlement(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexNotAcceptedAfterArrived(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo11 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00010);
        if (!detailRspBo11.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo11.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo11.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo11.getRuleName())) {
            log.error("LYGL-DD-00010|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo11.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("5"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexNotAcceptedAfterArrived(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00010|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo11);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexNotAcceptedAfterArrived(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexUnissuedInvoiceAfterSettlement(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo11 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00011);
        if (!detailRspBo11.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo11.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo11.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo11.getRuleName())) {
            log.error("LYGL-DD-00011|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo11.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("6"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexUnissuedInvoiceAfterSettlement(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00011|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo11);
        uocDealEfficiencyIndexBusiReqBO.setLeftBorder(leftBorder);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexUnissuedInvoiceAfterSettlement(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexNotDeliveredAfterDispatchLevelTwo(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo09 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00009);
        if (!detailRspBo09.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo09.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo09.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo09.getRuleName())) {
            log.error("LYGL-DD-00009|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo09.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("4"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexNotDeliveredAfterDispatchLevelTwo(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00009|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo09);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexNotDeliveredAfterDispatchLevelTwo(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexNotDeliveredAfterDispatchLevelOne(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo08 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00008);
        if (!detailRspBo08.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo08.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo08.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo08.getRuleName())) {
            log.error("LYGL-DD-00008|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        XwglRuleGetNoauthDetailRspBo detailRspBo09 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00009);
        if (!detailRspBo09.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo09.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo09.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo09.getRuleName())) {
            log.error("LYGL-DD-00008|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u6709\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo08.getRuleManagementVariableValue());
        int rightBorder = Integer.parseInt(detailRspBo09.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}\uff0c\u53c8\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder, (Object)rightBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setRightBorder(Integer.valueOf(rightBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("3"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexNotDeliveredAfterDispatchLevelOne(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00008|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo08);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexNotDeliveredAfterDispatchLevelOne(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexNoDispatchedAfterApprovalLevelTwo(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo07 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00007);
        if (!detailRspBo07.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo07.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo07.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo07.getRuleName())) {
            log.error("LYGL-DD-00007|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo07.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("2"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexNoDispatchedAfterApprovalLevelTwo(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00007|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo07);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexNoDispatchedAfterApprovalLevelTwo(uocDealEfficiencyIndexBusiReqBO);
    }

    private void dealEfficiencyIndexNoDispatchedAfterApprovalLevelOne(UocEfficiencyIndexAbilityReqBO reqBO) {
        XwglRuleGetNoauthDetailRspBo detailRspBo06 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00006);
        if (!detailRspBo06.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo06.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo06.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo06.getRuleName())) {
            log.error("LYGL-DD-00006|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u5de6\u8fb9\u754c");
            return;
        }
        XwglRuleGetNoauthDetailRspBo detailRspBo07 = this.getXwglRuleGetNoauthDetailRspBo(this.LYGL_DD_00007);
        if (!detailRspBo07.getRespCode().equals("0000") || StringUtils.isEmpty((Object)detailRspBo07.getRuleManagementVariableValue()) || StringUtils.isEmpty((Object)detailRspBo07.getRuleContent()) || StringUtils.isEmpty((Object)detailRspBo07.getRuleName())) {
            log.error("LYGL-DD-00006|\u67e5\u8be2\u9884\u8b66\u89c4\u5219\u5931\u8d25|\u53f3\u8fb9\u754c");
            return;
        }
        int leftBorder = Integer.parseInt(detailRspBo06.getRuleManagementVariableValue());
        int rightBorder = Integer.parseInt(detailRspBo07.getRuleManagementVariableValue());
        log.error("\u67e5\u8be2\u5230\u8fb9\u754c\uff0c\u5de6\u8fb9\u754c\u4e3a\uff1a{}\uff0c\u53c8\u8fb9\u754c\u4e3a\uff1a{}", (Object)leftBorder, (Object)rightBorder);
        OrdEfficiencyIndexQryBO ordEfficiencyIndexQryBo = new OrdEfficiencyIndexQryBO();
        ordEfficiencyIndexQryBo.setBatchSize(Integer.valueOf(500));
        ordEfficiencyIndexQryBo.setLeftBorder(Integer.valueOf(leftBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setRightBorder(Integer.valueOf(rightBorder * 60 * 60 * 24));
        ordEfficiencyIndexQryBo.setDealShardSize(reqBO.getDealShardSize());
        ordEfficiencyIndexQryBo.setEfficiencyIndicators(Integer.valueOf("1"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date parse = sdf.parse(this.efficiencyWarningStartTime, pos);
        ordEfficiencyIndexQryBo.setEfficiencyWarningStartTime(parse);
        List batch = this.orderMapper.getEfficiencyIndexNoDispatchedAfterApprovalLevelOne(ordEfficiencyIndexQryBo);
        if (batch.isEmpty()) {
            log.error("LYGL-DD-00006|\u6821\u9a8cSQL\u67e5\u8be2\u4e3a\u7a7a|\u4e0d\u6267\u884c");
            return;
        }
        UocDealEfficiencyIndexBusiReqBO uocDealEfficiencyIndexBusiReqBO = new UocDealEfficiencyIndexBusiReqBO();
        uocDealEfficiencyIndexBusiReqBO.setBatch(batch);
        uocDealEfficiencyIndexBusiReqBO.setXwglRule(detailRspBo06);
        this.uocDealEfficiencyIndexBusiService.dealEfficiencyIndexNoDispatchedAfterApprovalLevelOne(uocDealEfficiencyIndexBusiReqBO);
    }

    private XwglRuleGetNoauthDetailRspBo getXwglRuleGetNoauthDetailRspBo(String ruleNo) {
        XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
        ruleReqBo.setRuleNo(ruleNo);
        log.error("\u67e5\u8be2\u89c4\u5219\uff1a{} \u7684\u914d\u7f6e\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a{}", (Object)ruleNo, (Object)JSON.toJSONString((Object)ruleReqBo));
        XwglRuleGetNoauthDetailRspBo detail = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
        log.error("\u67e5\u8be2\u89c4\u5219\uff1a{} \u7684\u914d\u7f6e\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)ruleNo, (Object)JSON.toJSONString((Object)detail));
        return detail;
    }
}

